/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.transport;

import org.apache.qpid.server.protocol.v1_0.type.ErrorCondition;
import org.apache.qpid.server.protocol.v1_0.type.RestrictedType;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;

public class ConnectionError
implements ErrorCondition,
RestrictedType<Symbol> {
    private final Symbol _val;
    public static final ConnectionError CONNECTION_FORCED = new ConnectionError(Symbol.valueOf("amqp:connection:forced"));
    public static final ConnectionError FRAMING_ERROR = new ConnectionError(Symbol.valueOf("amqp:connection:framing-error"));
    public static final ConnectionError REDIRECT = new ConnectionError(Symbol.valueOf("amqp:connection:redirect"));
    public static final ConnectionError SOCKET_ERROR = new ConnectionError(Symbol.valueOf("amqp:connection:socket-error"));

    private ConnectionError(Symbol val) {
        this._val = val;
    }

    @Override
    public Symbol getValue() {
        return this._val;
    }

    public String toString() {
        if (this == CONNECTION_FORCED) {
            return "connection-forced";
        }
        if (this == FRAMING_ERROR) {
            return "framing-error";
        }
        if (this == REDIRECT) {
            return "redirect";
        }
        if (this == SOCKET_ERROR) {
            return "socket-error";
        }
        return String.valueOf(this._val);
    }

    public static ConnectionError valueOf(Object obj) {
        Symbol val = (Symbol)obj;
        if (ConnectionError.CONNECTION_FORCED._val.equals(val)) {
            return CONNECTION_FORCED;
        }
        if (ConnectionError.FRAMING_ERROR._val.equals(val)) {
            return FRAMING_ERROR;
        }
        if (ConnectionError.REDIRECT._val.equals(val)) {
            return REDIRECT;
        }
        if (ConnectionError.SOCKET_ERROR._val.equals(val)) {
            return SOCKET_ERROR;
        }
        return null;
    }
}

