/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.transport.codec;

import org.apache.qpid.server.protocol.v1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.server.protocol.v1_0.codec.AbstractListWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.transport.Begin;

public class BeginWriter
extends AbstractDescribedTypeWriter<Begin> {
    private Begin _value;
    private int _count = -1;
    private static ValueWriter.Factory<Begin> FACTORY = new ValueWriter.Factory<Begin>(){

        @Override
        public ValueWriter<Begin> newInstance(ValueWriter.Registry registry) {
            return new BeginWriter(registry);
        }
    };

    public BeginWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected void onSetValue(Begin value) {
        this._value = value;
        this._count = this.calculateCount();
    }

    private int calculateCount() {
        if (this._value.getProperties() != null) {
            return 8;
        }
        if (this._value.getDesiredCapabilities() != null) {
            return 7;
        }
        if (this._value.getOfferedCapabilities() != null) {
            return 6;
        }
        if (this._value.getHandleMax() != null) {
            return 5;
        }
        if (this._value.getOutgoingWindow() != null) {
            return 4;
        }
        if (this._value.getIncomingWindow() != null) {
            return 3;
        }
        if (this._value.getNextOutgoingId() != null) {
            return 2;
        }
        if (this._value.getRemoteChannel() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void clear() {
        this._value = null;
        this._count = -1;
    }

    @Override
    protected Object getDescriptor() {
        return UnsignedLong.valueOf(17L);
    }

    @Override
    protected ValueWriter createDescribedWriter() {
        Writer writer = new Writer(this.getRegistry());
        writer.setValue(this._value);
        return writer;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Begin.class, FACTORY);
    }

    private class Writer
    extends AbstractListWriter<Begin> {
        private int _field;

        public Writer(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(Begin value) {
            this.reset();
        }

        @Override
        protected int getCount() {
            return BeginWriter.this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < BeginWriter.this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return BeginWriter.this._value.getRemoteChannel();
                }
                case 1: {
                    return BeginWriter.this._value.getNextOutgoingId();
                }
                case 2: {
                    return BeginWriter.this._value.getIncomingWindow();
                }
                case 3: {
                    return BeginWriter.this._value.getOutgoingWindow();
                }
                case 4: {
                    return BeginWriter.this._value.getHandleMax();
                }
                case 5: {
                    return BeginWriter.this._value.getOfferedCapabilities();
                }
                case 6: {
                    return BeginWriter.this._value.getDesiredCapabilities();
                }
                case 7: {
                    return BeginWriter.this._value.getProperties();
                }
            }
            return null;
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

