/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.transport.codec;

import org.apache.qpid.server.protocol.v1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.server.protocol.v1_0.codec.AbstractListWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.transport.Disposition;

public class DispositionWriter
extends AbstractDescribedTypeWriter<Disposition> {
    private Disposition _value;
    private int _count = -1;
    private static ValueWriter.Factory<Disposition> FACTORY = new ValueWriter.Factory<Disposition>(){

        @Override
        public ValueWriter<Disposition> newInstance(ValueWriter.Registry registry) {
            return new DispositionWriter(registry);
        }
    };

    public DispositionWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected void onSetValue(Disposition value) {
        this._value = value;
        this._count = this.calculateCount();
    }

    private int calculateCount() {
        if (this._value.getBatchable() != null) {
            return 6;
        }
        if (this._value.getState() != null) {
            return 5;
        }
        if (this._value.getSettled() != null) {
            return 4;
        }
        if (this._value.getLast() != null) {
            return 3;
        }
        if (this._value.getFirst() != null) {
            return 2;
        }
        if (this._value.getRole() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void clear() {
        this._value = null;
        this._count = -1;
    }

    @Override
    protected Object getDescriptor() {
        return UnsignedLong.valueOf(21L);
    }

    @Override
    protected ValueWriter createDescribedWriter() {
        Writer writer = new Writer(this.getRegistry());
        writer.setValue(this._value);
        return writer;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Disposition.class, FACTORY);
    }

    private class Writer
    extends AbstractListWriter<Disposition> {
        private int _field;

        public Writer(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(Disposition value) {
            this.reset();
        }

        @Override
        protected int getCount() {
            return DispositionWriter.this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < DispositionWriter.this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return DispositionWriter.this._value.getRole();
                }
                case 1: {
                    return DispositionWriter.this._value.getFirst();
                }
                case 2: {
                    return DispositionWriter.this._value.getLast();
                }
                case 3: {
                    return DispositionWriter.this._value.getSettled();
                }
                case 4: {
                    return DispositionWriter.this._value.getState();
                }
                case 5: {
                    return DispositionWriter.this._value.getBatchable();
                }
            }
            return null;
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

