/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.transport.codec;

import org.apache.qpid.server.protocol.v1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.server.protocol.v1_0.codec.AbstractListWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.transport.Flow;

public class FlowWriter
extends AbstractDescribedTypeWriter<Flow> {
    private Flow _value;
    private int _count = -1;
    private static ValueWriter.Factory<Flow> FACTORY = new ValueWriter.Factory<Flow>(){

        @Override
        public ValueWriter<Flow> newInstance(ValueWriter.Registry registry) {
            return new FlowWriter(registry);
        }
    };

    public FlowWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected void onSetValue(Flow value) {
        this._value = value;
        this._count = this.calculateCount();
    }

    private int calculateCount() {
        if (this._value.getProperties() != null) {
            return 11;
        }
        if (this._value.getEcho() != null) {
            return 10;
        }
        if (this._value.getDrain() != null) {
            return 9;
        }
        if (this._value.getAvailable() != null) {
            return 8;
        }
        if (this._value.getLinkCredit() != null) {
            return 7;
        }
        if (this._value.getDeliveryCount() != null) {
            return 6;
        }
        if (this._value.getHandle() != null) {
            return 5;
        }
        if (this._value.getOutgoingWindow() != null) {
            return 4;
        }
        if (this._value.getNextOutgoingId() != null) {
            return 3;
        }
        if (this._value.getIncomingWindow() != null) {
            return 2;
        }
        if (this._value.getNextIncomingId() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void clear() {
        this._value = null;
        this._count = -1;
    }

    @Override
    protected Object getDescriptor() {
        return UnsignedLong.valueOf(19L);
    }

    @Override
    protected ValueWriter createDescribedWriter() {
        Writer writer = new Writer(this.getRegistry());
        writer.setValue(this._value);
        return writer;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Flow.class, FACTORY);
    }

    private class Writer
    extends AbstractListWriter<Flow> {
        private int _field;

        public Writer(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(Flow value) {
            this.reset();
        }

        @Override
        protected int getCount() {
            return FlowWriter.this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < FlowWriter.this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return FlowWriter.this._value.getNextIncomingId();
                }
                case 1: {
                    return FlowWriter.this._value.getIncomingWindow();
                }
                case 2: {
                    return FlowWriter.this._value.getNextOutgoingId();
                }
                case 3: {
                    return FlowWriter.this._value.getOutgoingWindow();
                }
                case 4: {
                    return FlowWriter.this._value.getHandle();
                }
                case 5: {
                    return FlowWriter.this._value.getDeliveryCount();
                }
                case 6: {
                    return FlowWriter.this._value.getLinkCredit();
                }
                case 7: {
                    return FlowWriter.this._value.getAvailable();
                }
                case 8: {
                    return FlowWriter.this._value.getDrain();
                }
                case 9: {
                    return FlowWriter.this._value.getEcho();
                }
                case 10: {
                    return FlowWriter.this._value.getProperties();
                }
            }
            return null;
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

