/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.protocol.v1_0.AbstractLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.Delivery;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.SequenceNumber;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.UnknownTransactionException;
import org.apache.qpid.server.protocol.v1_0.delivery.UnsettledDelivery;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionDecoder;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionDecoderImpl;
import org.apache.qpid.server.protocol.v1_0.type.BaseTarget;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.transaction.TransactionError;
import org.apache.qpid.server.protocol.v1_0.type.transaction.TransactionalState;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Attach;
import org.apache.qpid.server.protocol.v1_0.type.transport.End;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.Flow;
import org.apache.qpid.server.protocol.v1_0.type.transport.LinkError;
import org.apache.qpid.server.protocol.v1_0.type.transport.ReceiverSettleMode;
import org.apache.qpid.server.protocol.v1_0.type.transport.Role;
import org.apache.qpid.server.protocol.v1_0.type.transport.SessionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;

public abstract class AbstractReceivingLinkEndpoint<T extends BaseTarget>
extends AbstractLinkEndpoint<Source, T> {
    private final SectionDecoder _sectionDecoder;
    final Map<Binary, DeliveryState> _unsettled = Collections.synchronizedMap(new LinkedHashMap());
    private volatile boolean _creditWindow;
    private volatile Delivery _currentDelivery;

    public AbstractReceivingLinkEndpoint(Session_1_0 session, Link_1_0<Source, T> link) {
        super(session, link);
        this._sectionDecoder = new SectionDecoderImpl(session.getConnection().getDescribedTypeRegistry().getSectionDecoderRegistry());
    }

    @Override
    protected Map<Symbol, Object> initProperties(Attach attach) {
        return Collections.emptyMap();
    }

    @Override
    public Role getRole() {
        return Role.RECEIVER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void receiveTransfer(Transfer transfer) {
        if (!this.isErrored()) {
            Error error = this.validateTransfer(transfer);
            if (error != null) {
                transfer.dispose();
                if (this._currentDelivery != null) {
                    this._currentDelivery.discard();
                    this._currentDelivery = null;
                }
                this.close(error);
                return;
            }
            if (this._currentDelivery == null) {
                error = this.validateNewTransfer(transfer);
                if (error != null) {
                    transfer.dispose();
                    this.close(error);
                    return;
                }
                this._currentDelivery = new Delivery(transfer, this);
                this.setLinkCredit(this.getLinkCredit().subtract(UnsignedInteger.ONE));
                this.getDeliveryCount().incr();
                this.getSession().getIncomingDeliveryRegistry().addDelivery(transfer.getDeliveryId(), new UnsettledDelivery(transfer.getDeliveryTag(), this));
            } else {
                error = this.validateSubsequentTransfer(transfer);
                if (error != null) {
                    transfer.dispose();
                    this._currentDelivery.discard();
                    this._currentDelivery = null;
                    this.close(error);
                    return;
                }
                this._currentDelivery.addTransfer(transfer);
            }
            if (this._currentDelivery.getTotalPayloadSize() > this.getSession().getConnection().getMaxMessageSize()) {
                error = new Error(LinkError.MESSAGE_SIZE_EXCEEDED, String.format("delivery '%s' exceeds max-message-size %d", this._currentDelivery.getDeliveryTag(), this.getSession().getConnection().getMaxMessageSize()));
                this._currentDelivery.discard();
                this._currentDelivery = null;
                this.close(error);
                return;
            }
            if (!this._currentDelivery.getResume()) {
                this._unsettled.put(this._currentDelivery.getDeliveryTag(), this._currentDelivery.getState());
            }
            if (this._currentDelivery.isAborted() || this._currentDelivery.getResume() && !this._unsettled.containsKey(this._currentDelivery.getDeliveryTag())) {
                this._unsettled.remove(this._currentDelivery.getDeliveryTag());
                this.getSession().getIncomingDeliveryRegistry().removeDelivery(this._currentDelivery.getDeliveryId());
                this._currentDelivery = null;
                this.setLinkCredit(this.getLinkCredit().add(UnsignedInteger.ONE));
                this.getDeliveryCount().decr();
                return;
            } else {
                if (!this._currentDelivery.isComplete()) return;
                try {
                    if (this._currentDelivery.isSettled()) {
                        this._unsettled.remove(this._currentDelivery.getDeliveryTag());
                        this.getSession().getIncomingDeliveryRegistry().removeDelivery(this._currentDelivery.getDeliveryId());
                    }
                    if ((error = this.receiveDelivery(this._currentDelivery)) == null) return;
                    this.close(error);
                    return;
                }
                finally {
                    this._currentDelivery = null;
                }
            }
        } else {
            End end = new End();
            end.setError(new Error(SessionError.ERRANT_LINK, String.format("Received TRANSFER for link handle %s which is in errored state.", transfer.getHandle())));
            this.getSession().end(end);
        }
    }

    private Error validateTransfer(Transfer transfer) {
        Error error = null;
        if (!ReceiverSettleMode.SECOND.equals(this.getReceivingSettlementMode()) && ReceiverSettleMode.SECOND.equals(transfer.getRcvSettleMode())) {
            error = new Error(AmqpError.INVALID_FIELD, "Transfer \"rcv-settle-mode\" cannot be \"first\" when link \"rcv-settle-mode\" is set to \"second\".");
        } else if (transfer.getState() instanceof TransactionalState) {
            Binary txnId = ((TransactionalState)transfer.getState()).getTxnId();
            try {
                this.getSession().getTransaction(txnId);
            }
            catch (UnknownTransactionException e) {
                error = new Error(TransactionError.UNKNOWN_ID, String.format("Transfer has an unknown transaction-id '%s'.", txnId));
            }
        }
        return error;
    }

    private Error validateNewTransfer(Transfer transfer) {
        Error error = null;
        if (transfer.getDeliveryId() == null) {
            error = new Error(AmqpError.INVALID_FIELD, "Transfer \"delivery-id\" is required for a new delivery.");
        } else if (transfer.getDeliveryTag() == null) {
            error = new Error(AmqpError.INVALID_FIELD, "Transfer \"delivery-tag\" is required for a new delivery.");
        } else if (!Boolean.TRUE.equals(transfer.getResume())) {
            if (this._unsettled.containsKey(transfer.getDeliveryTag())) {
                error = new Error(AmqpError.ILLEGAL_STATE, String.format("Delivery-tag '%s' is used by another unsettled delivery. The delivery-tag MUST be unique amongst all deliveries that could be considered unsettled by either end of the link.", transfer.getDeliveryTag()));
            } else if (this._localIncompleteUnsettled || this._remoteIncompleteUnsettled) {
                error = new Error(AmqpError.ILLEGAL_STATE, "Cannot accept new deliveries while incomplete-unsettled is true.");
            }
        }
        return error;
    }

    private Error validateSubsequentTransfer(Transfer transfer) {
        Error error = null;
        if (transfer.getDeliveryId() != null && !this._currentDelivery.getDeliveryId().equals(transfer.getDeliveryId())) {
            error = new Error(AmqpError.INVALID_FIELD, String.format("Unexpected transfer \"delivery-id\" for multi-transfer delivery: found '%s', expected '%s'.", transfer.getDeliveryId(), this._currentDelivery.getDeliveryId()));
        } else if (transfer.getDeliveryTag() != null && !this._currentDelivery.getDeliveryTag().equals(transfer.getDeliveryTag())) {
            error = new Error(AmqpError.INVALID_FIELD, String.format("Unexpected transfer \"delivery-tag\" for multi-transfer delivery: found '%s', expected '%s'.", transfer.getDeliveryTag(), this._currentDelivery.getDeliveryTag()));
        } else if (this._currentDelivery.getReceiverSettleMode() != null && transfer.getRcvSettleMode() != null && !this._currentDelivery.getReceiverSettleMode().equals(transfer.getRcvSettleMode())) {
            error = new Error(AmqpError.INVALID_FIELD, "Transfer \"rcv-settle-mode\" is set to different value than on previous transfer.");
        } else if (transfer.getMessageFormat() != null && !this._currentDelivery.getMessageFormat().equals(transfer.getMessageFormat())) {
            error = new Error(AmqpError.INVALID_FIELD, "Transfer \"message-format\" is set to different value than on previous transfer.");
        }
        return error;
    }

    protected abstract Error receiveDelivery(Delivery var1);

    @Override
    public void receiveFlow(Flow flow) {
        this.setAvailable(flow.getAvailable());
        this.setDeliveryCount(new SequenceNumber(flow.getDeliveryCount().intValue()));
    }

    private boolean settled(Binary deliveryTag) {
        return this._unsettled.remove(deliveryTag) != null;
    }

    void updateDisposition(Binary deliveryTag, DeliveryState state, boolean settled) {
        this.updateDispositions(Collections.singleton(deliveryTag), state, settled);
    }

    void updateDispositions(Set<Binary> deliveryTags, DeliveryState state, boolean settled) {
        HashSet<Binary> unsettledKeys = new HashSet<Binary>(this._unsettled.keySet());
        unsettledKeys.retainAll(deliveryTags);
        int settledDeliveryCount = deliveryTags.size() - unsettledKeys.size();
        if (!unsettledKeys.isEmpty()) {
            boolean outcomeUpdate = false;
            Outcome outcome = null;
            if (state instanceof Outcome) {
                outcome = (Outcome)state;
            } else if (state instanceof TransactionalState) {
                outcome = ((TransactionalState)state).getOutcome();
            }
            if (outcome != null) {
                for (Binary deliveryTag : unsettledKeys) {
                    if (this._unsettled.get(deliveryTag) instanceof Outcome) continue;
                    DeliveryState oldOutcome = this._unsettled.put(deliveryTag, outcome);
                    outcomeUpdate = outcomeUpdate || !outcome.equals(oldOutcome);
                }
            }
            if (outcomeUpdate || settled) {
                this.getSession().updateDisposition(this.getRole(), unsettledKeys, state, settled);
            }
            if (settled) {
                int credit = 0;
                for (Binary deliveryTag : unsettledKeys) {
                    if (!this.settled(deliveryTag) || this.isDetached() || !this._creditWindow) continue;
                    ++credit;
                }
                if (credit > 0) {
                    this.setLinkCredit(this.getLinkCredit().add(UnsignedInteger.valueOf(credit)));
                    this.sendFlowConditional();
                } else {
                    this.getSession().sendFlowConditional();
                }
            }
        }
        if (settledDeliveryCount > 0 && this._creditWindow) {
            this.setLinkCredit(this.getLinkCredit().add(UnsignedInteger.ONE));
            this.sendFlowConditional();
        }
    }

    void setCreditWindow() {
        this.setCreditWindow(true);
    }

    private void setCreditWindow(boolean window) {
        this._creditWindow = window;
        this.sendFlowConditional();
    }

    SectionDecoder getSectionDecoder() {
        return this._sectionDecoder;
    }

    @Override
    public void settle(Binary deliveryTag) {
        super.settle(deliveryTag);
        this._unsettled.remove(deliveryTag);
        if (this._creditWindow) {
            this.setLinkCredit(this.getLinkCredit().add(UnsignedInteger.ONE));
            this.sendFlowConditional();
        }
    }

    @Override
    public void flowStateChanged() {
    }

    @Override
    protected void detach(Error error, boolean close) {
        try {
            super.detach(error, close);
        }
        finally {
            if (this._currentDelivery != null) {
                this._currentDelivery.discard();
                this._currentDelivery = null;
            }
        }
    }

    @Override
    protected void handleDeliveryState(Binary deliveryTag, DeliveryState state, Boolean settled) {
        if (Boolean.TRUE.equals(settled)) {
            this._unsettled.remove(deliveryTag);
        }
    }
}

