/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.delivery;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.protocol.v1_0.LinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.delivery.DeliveryRegistry;
import org.apache.qpid.server.protocol.v1_0.delivery.UnsettledDelivery;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;

public class DeliveryRegistryImpl
implements DeliveryRegistry {
    private final Map<UnsignedInteger, UnsettledDelivery> _deliveries = new ConcurrentHashMap<UnsignedInteger, UnsettledDelivery>();
    private final Map<Binary, UnsignedInteger> _deliveryIds = new ConcurrentHashMap<Binary, UnsignedInteger>();

    @Override
    public void addDelivery(UnsignedInteger deliveryId, UnsettledDelivery unsettledDelivery) {
        this._deliveries.put(deliveryId, unsettledDelivery);
        this._deliveryIds.put(unsettledDelivery.getDeliveryTag(), deliveryId);
    }

    @Override
    public void removeDelivery(UnsignedInteger deliveryId) {
        UnsettledDelivery unsettledDelivery = this._deliveries.remove(deliveryId);
        if (unsettledDelivery != null) {
            this._deliveryIds.remove(unsettledDelivery.getDeliveryTag());
        }
    }

    @Override
    public UnsettledDelivery getDelivery(UnsignedInteger deliveryId) {
        return this._deliveries.get(deliveryId);
    }

    @Override
    public void removeDeliveriesForLinkEndpoint(LinkEndpoint<?, ?> linkEndpoint) {
        Iterator<UnsettledDelivery> iterator = this._deliveries.values().iterator();
        while (iterator.hasNext()) {
            UnsettledDelivery unsettledDelivery = iterator.next();
            if (unsettledDelivery.getLinkEndpoint() != linkEndpoint) continue;
            iterator.remove();
            this._deliveryIds.remove(unsettledDelivery.getDeliveryTag());
        }
    }

    @Override
    public UnsignedInteger getDeliveryIdByTag(Binary deliveryTag) {
        return this._deliveryIds.get(deliveryTag);
    }

    @Override
    public int size() {
        return this._deliveries.size();
    }
}

