/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.extensions.soleconn;

import org.apache.qpid.server.protocol.v1_0.type.RestrictedType;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;

public class SoleConnectionEnforcementPolicy
implements RestrictedType<UnsignedInteger> {
    public static final SoleConnectionEnforcementPolicy REFUSE_CONNECTION = new SoleConnectionEnforcementPolicy(UnsignedInteger.valueOf(0));
    public static final SoleConnectionEnforcementPolicy CLOSE_EXISTING = new SoleConnectionEnforcementPolicy(UnsignedInteger.valueOf(1));
    private final UnsignedInteger _val;

    private SoleConnectionEnforcementPolicy(UnsignedInteger val) {
        this._val = val;
    }

    @Override
    public UnsignedInteger getValue() {
        return this._val;
    }

    public static SoleConnectionEnforcementPolicy valueOf(Object obj) {
        if (obj instanceof UnsignedInteger) {
            UnsignedInteger val = (UnsignedInteger)obj;
            if (SoleConnectionEnforcementPolicy.REFUSE_CONNECTION._val.equals(val)) {
                return REFUSE_CONNECTION;
            }
            if (SoleConnectionEnforcementPolicy.CLOSE_EXISTING._val.equals(val)) {
                return CLOSE_EXISTING;
            }
        }
        String message = String.format("Cannot convert '%s' into 'sole-connection-enforcement-policy'", obj);
        throw new IllegalArgumentException(message);
    }

    public String toString() {
        if (this == REFUSE_CONNECTION) {
            return "refuse-connection";
        }
        if (this == CLOSE_EXISTING) {
            return "close-existing";
        }
        return String.valueOf(this._val);
    }
}

