/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.Arrays;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.ExchangeMessages;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.DestinationAddress;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.protocol.v1_0.NodeReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.UnroutableMessageException;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.txn.ServerTransaction;

public class AnonymousRelayDestination
implements ReceivingDestination {
    private final Target _target;
    private final NamedAddressSpace _addressSpace;
    private final EventLogger _eventLogger;
    private final boolean _discardUnroutable;

    AnonymousRelayDestination(NamedAddressSpace addressSpace, Target target, EventLogger eventLogger) {
        this._addressSpace = addressSpace;
        this._target = target;
        this._eventLogger = eventLogger;
        this._discardUnroutable = target.getCapabilities() != null && Arrays.asList(target.getCapabilities()).contains(DISCARD_UNROUTABLE);
    }

    @Override
    public Symbol[] getCapabilities() {
        return new Symbol[]{Session_1_0.DELAYED_DELIVERY};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void send(ServerMessage<?> message, ServerTransaction txn, SecurityToken securityToken) throws UnroutableMessageException {
        String routingAddress = message.getTo();
        DestinationAddress destinationAddress = new DestinationAddress(this._addressSpace, routingAddress, true);
        MessageDestination messageDestination = destinationAddress.getMessageDestination();
        ReceivingDestination destination = messageDestination != null ? new NodeReceivingDestination(destinationAddress, this._target.getDurable(), this._target.getExpiryPolicy(), this._target.getCapabilities(), this._eventLogger) : null;
        if (destination == null) {
            if (!this._discardUnroutable) throw new UnroutableMessageException(AmqpError.NOT_FOUND, String.format("Unknown destination '%s'", routingAddress));
            this._eventLogger.message(ExchangeMessages.DISCARDMSG((String)"", (String)routingAddress));
            return;
        } else {
            destination.send(message, txn, securityToken);
        }
    }

    @Override
    public int getCredit() {
        return 20000;
    }

    @Override
    public String getAddress() {
        return "";
    }

    @Override
    public MessageDestination getMessageDestination() {
        return null;
    }
}

