/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.messaging.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructorRegistry;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValueSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.codec.AbstractLazyConstructor;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public class AmqpValueSectionConstructor
implements DescribedTypeConstructor<AmqpValueSection> {
    private static final Object[] DESCRIPTORS = new Object[]{Symbol.valueOf("amqp:amqp-value:*"), UnsignedLong.valueOf(119L)};
    private static final AmqpValueSectionConstructor INSTANCE = new AmqpValueSectionConstructor();

    public static void register(DescribedTypeConstructorRegistry registry) {
        for (Object descriptor : DESCRIPTORS) {
            registry.register(descriptor, INSTANCE);
        }
    }

    @Override
    public TypeConstructor<AmqpValueSection> construct(Object descriptor, QpidByteBuffer in, int originalPosition, ValueHandler valueHandler) throws AmqpErrorException {
        return new LazyConstructor(originalPosition);
    }

    private class LazyConstructor
    extends AbstractLazyConstructor<AmqpValueSection> {
        LazyConstructor(int originalPosition) {
            super(originalPosition);
        }

        @Override
        protected AmqpValueSection createObject(QpidByteBuffer encoding, ValueHandler handler) {
            return new AmqpValueSection(encoding);
        }

        @Override
        protected void skipValue(QpidByteBuffer in) throws AmqpErrorException {
            if (!in.hasRemaining()) {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode AMQP value section.", new Object[0]);
            }
            byte formatCode = in.get();
            if (formatCode == 0) {
                this.skipValue(in);
                this.skipValue(in);
            } else {
                int skipLength;
                int category = formatCode >> 4 & 0xF;
                switch (category) {
                    case 4: {
                        skipLength = 0;
                        break;
                    }
                    case 5: {
                        skipLength = 1;
                        break;
                    }
                    case 6: {
                        skipLength = 2;
                        break;
                    }
                    case 7: {
                        skipLength = 4;
                        break;
                    }
                    case 8: {
                        skipLength = 8;
                        break;
                    }
                    case 9: {
                        skipLength = 16;
                        break;
                    }
                    case 10: 
                    case 12: 
                    case 14: {
                        if (!in.hasRemaining()) {
                            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode AMQP value section.", new Object[0]);
                        }
                        skipLength = in.getUnsignedByte();
                        break;
                    }
                    case 11: 
                    case 13: 
                    case 15: {
                        if (!in.hasRemaining(4)) {
                            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode AMQP value section.", new Object[0]);
                        }
                        skipLength = in.getInt();
                        break;
                    }
                    default: {
                        throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Unknown type", new Object[0]);
                    }
                }
                if (!in.hasRemaining(skipLength)) {
                    throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode AMQP value section.", new Object[0]);
                }
                in.position(in.position() + skipLength);
            }
        }
    }
}

