/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.converter.v0_8_v1_0;

import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.DestinationAddress;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.converter.MessageConversionException;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.protocol.v0_8.transport.BasicContentHeaderProperties;
import org.apache.qpid.server.protocol.v0_8.transport.ContentHeaderBody;
import org.apache.qpid.server.protocol.v0_8.transport.MessagePublishInfo;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_from_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.store.StoredMessage;

@PluggableService
public class MessageConverter_1_0_to_v0_8
implements MessageConverter<Message_1_0, AMQMessage> {
    public Class<Message_1_0> getInputClass() {
        return Message_1_0.class;
    }

    public Class<AMQMessage> getOutputClass() {
        return AMQMessage.class;
    }

    public AMQMessage convert(Message_1_0 serverMsg, NamedAddressSpace addressSpace) {
        return new AMQMessage(this.convertToStoredMessage(serverMsg, addressSpace), null);
    }

    public void dispose(AMQMessage message) {
    }

    private StoredMessage<MessageMetaData> convertToStoredMessage(final Message_1_0 serverMsg, NamedAddressSpace addressSpace) {
        MessageConverter_from_1_0.ConvertedContentAndMimeType convertedContentAndMimeType = MessageConverter_from_1_0.getAmqp0xConvertedContentAndMimeType((Message_1_0)serverMsg);
        final byte[] convertedContent = convertedContentAndMimeType.getContent();
        final MessageMetaData messageMetaData_0_8 = this.convertMetaData(serverMsg, convertedContentAndMimeType.getMimeType(), convertedContent.length, addressSpace);
        final int metadataSize = messageMetaData_0_8.getStorableSize();
        return new StoredMessage<MessageMetaData>(){

            public MessageMetaData getMetaData() {
                return messageMetaData_0_8;
            }

            public long getMessageNumber() {
                return serverMsg.getMessageNumber();
            }

            public QpidByteBuffer getContent(int offset, int length) {
                return QpidByteBuffer.wrap((byte[])convertedContent, (int)offset, (int)length);
            }

            public int getContentSize() {
                return convertedContent.length;
            }

            public int getMetadataSize() {
                return metadataSize;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInMemory() {
                return true;
            }

            public boolean flowToDisk() {
                return false;
            }

            public void reallocate() {
            }
        };
    }

    private MessageMetaData convertMetaData(Message_1_0 serverMsg, String bodyMimeType, int size, NamedAddressSpace addressSpace) {
        FieldTable headers;
        UnsignedInteger groupSequence;
        String groupId;
        MessageMetaData_1_0.MessageHeader_1_0 header = serverMsg.getMessageHeader();
        BasicContentHeaderProperties props = new BasicContentHeaderProperties();
        props.setAppId(serverMsg.getMessageHeader().getAppId());
        props.setContentType(bodyMimeType);
        props.setEncoding(this.convertToShortStringForProperty("content-encoding", serverMsg.getMessageHeader().getEncoding()));
        props.setCorrelationId(this.getCorrelationIdAsShortString(serverMsg));
        props.setDeliveryMode(serverMsg.isPersistent() ? (byte)2 : 1);
        Date absoluteExpiryTime = MessageConverter_from_1_0.getAbsoluteExpiryTime((Message_1_0)serverMsg);
        if (absoluteExpiryTime != null) {
            props.setExpiration(absoluteExpiryTime.getTime());
        } else {
            Long ttl = MessageConverter_from_1_0.getTtl((Message_1_0)serverMsg);
            if (ttl != null) {
                props.setExpiration(ttl + serverMsg.getArrivalTime());
            }
        }
        props.setMessageId(this.getMessageIdAsShortString(serverMsg));
        props.setPriority(serverMsg.getMessageHeader().getPriority());
        props.setReplyTo(this.getReplyTo(serverMsg, addressSpace));
        Date timestamp = MessageConverter_from_1_0.getCreationTime((Message_1_0)serverMsg);
        if (timestamp != null) {
            props.setTimestamp(timestamp.getTime());
        } else {
            props.setTimestamp(serverMsg.getArrivalTime());
        }
        props.setUserId(this.getUserIdAsShortString(serverMsg));
        LinkedHashMap<String, Object> headerProps = new LinkedHashMap<String, Object>();
        if (header.getSubject() != null) {
            headerProps.put("qpid.subject", header.getSubject());
            props.setType(this.convertToShortStringForProperty("subject", header.getSubject()));
        }
        if ((groupId = MessageConverter_from_1_0.getGroupId((Message_1_0)serverMsg)) != null) {
            headerProps.put("JMSXGroupID", groupId);
        }
        if ((groupSequence = MessageConverter_from_1_0.getGroupSequence((Message_1_0)serverMsg)) != null) {
            headerProps.put("JMSXGroupSeq", groupSequence.intValue());
        }
        for (String headerName : serverMsg.getMessageHeader().getHeaderNames()) {
            headerProps.put(headerName, MessageConverter_from_1_0.convertValue((Object)serverMsg.getMessageHeader().getHeader(headerName)));
        }
        try {
            headers = FieldTable.convertToFieldTable(headerProps);
        }
        catch (IllegalArgumentException e) {
            throw new MessageConversionException("Could not convert message from 1.0 to 0-8 because conversion of 'application-properties' failed.", (Throwable)e);
        }
        props.setHeaders(headers);
        ContentHeaderBody chb = new ContentHeaderBody(props);
        chb.setBodySize((long)size);
        MessagePublishInfo publishInfo = this.createMessagePublishInfo(header, addressSpace);
        return new MessageMetaData(publishInfo, chb, serverMsg.getArrivalTime());
    }

    private MessagePublishInfo createMessagePublishInfo(MessageMetaData_1_0.MessageHeader_1_0 header, NamedAddressSpace addressSpace) {
        String routingKey;
        String exchangeName;
        String subject;
        String to = header.getTo();
        String string = subject = header.getSubject() == null ? "" : header.getSubject();
        if (to != null && !"".equals(to)) {
            DestinationAddress destinationAddress = new DestinationAddress(addressSpace, to);
            MessageDestination messageDestination = destinationAddress.getMessageDestination();
            if (messageDestination instanceof Queue) {
                exchangeName = "";
                routingKey = messageDestination.getName();
            } else if (messageDestination instanceof Exchange) {
                exchangeName = messageDestination.getName();
                routingKey = "".equals(destinationAddress.getRoutingKey()) ? subject : destinationAddress.getRoutingKey();
            } else {
                exchangeName = "";
                routingKey = to;
            }
        } else {
            exchangeName = "";
            routingKey = subject;
        }
        return new MessagePublishInfo(this.convertToShortStringForProperty("to", exchangeName), false, false, this.convertToShortStringForProperty("to' or 'subject", routingKey));
    }

    private AMQShortString getUserIdAsShortString(Message_1_0 serverMsg) {
        Binary userId = MessageConverter_from_1_0.getUserId((Message_1_0)serverMsg);
        if (userId != null) {
            try {
                return AMQShortString.createAMQShortString((byte[])userId.getArray());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    private AMQShortString getMessageIdAsShortString(Message_1_0 serverMsg) {
        try {
            Object messageId = MessageConverter_from_1_0.getMessageId((Message_1_0)serverMsg);
            return this.covertMessageIdTo08MessageId(messageId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private AMQShortString covertMessageIdTo08MessageId(Object messageId) {
        if (messageId == null) {
            return null;
        }
        AMQShortString result = messageId instanceof Binary ? AMQShortString.createAMQShortString((byte[])((Binary)messageId).getArray()) : (messageId instanceof byte[] ? AMQShortString.createAMQShortString((byte[])((byte[])messageId)) : AMQShortString.createAMQShortString((String)String.valueOf(messageId)));
        return result;
    }

    private AMQShortString getReplyTo(Message_1_0 serverMsg, NamedAddressSpace addressSpace) {
        String replyTo = serverMsg.getMessageHeader().getReplyTo();
        if (replyTo != null) {
            String replyToBindingUrl;
            DestinationAddress destinationAddress = new DestinationAddress(addressSpace, replyTo);
            MessageDestination messageDestination = destinationAddress.getMessageDestination();
            if (messageDestination instanceof Exchange) {
                Exchange exchange = (Exchange)messageDestination;
                String routingKeyOption = "".equals(destinationAddress.getRoutingKey()) ? "" : String.format("?routingkey='%s'", destinationAddress.getRoutingKey());
                replyToBindingUrl = String.format("%s://%s//%s", exchange.getType(), exchange.getName(), routingKeyOption);
            } else {
                replyToBindingUrl = messageDestination instanceof Queue ? String.format("%s:////%s", "direct", messageDestination.getName()) : String.format("%s:////?routingkey='%s'", "direct", destinationAddress.getRoutingKey());
            }
            try {
                return AMQShortString.valueOf((String)replyToBindingUrl);
            }
            catch (IllegalArgumentException e) {
                throw new MessageConversionException("Could not convert message from 1.0 to 0-8 because conversion of 'reply-to' failed.", (Throwable)e);
            }
        }
        return null;
    }

    private AMQShortString getCorrelationIdAsShortString(Message_1_0 serverMsg) {
        try {
            Object correlationIdObject = MessageConverter_from_1_0.getCorrelationId((Message_1_0)serverMsg);
            return this.covertMessageIdTo08MessageId(correlationIdObject);
        }
        catch (IllegalArgumentException e) {
            throw new MessageConversionException("Could not convert message from 1.0 to 0-8 because conversion of 'correlation-id' failed.", (Throwable)e);
        }
    }

    private AMQShortString convertToShortStringForProperty(String propertyName, String s) {
        try {
            return AMQShortString.valueOf((String)s);
        }
        catch (IllegalArgumentException e) {
            throw new MessageConversionException(String.format("Could not convert message from 1.0 to 0-8 because conversion of '%s' failed.", propertyName), (Throwable)e);
        }
    }

    public String getType() {
        return "v1-0 to v0-8";
    }
}

