/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.converter.v0_8_v1_0;

import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.converter.MessageConversionException;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.transport.BasicContentHeaderProperties;
import org.apache.qpid.server.protocol.v0_8.transport.MessagePublishInfo;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_to_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoder;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedByte;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DataSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.EncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Header;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Properties;
import org.apache.qpid.server.url.AMQBindingURL;

@PluggableService
public class MessageConverter_0_8_to_1_0
extends MessageConverter_to_1_0<AMQMessage> {
    public Class<AMQMessage> getInputClass() {
        return AMQMessage.class;
    }

    protected MessageMetaData_1_0 convertMetaData(AMQMessage serverMessage, EncodingRetainingSection<?> bodySection, SectionEncoder sectionEncoder) {
        ApplicationProperties applicationProperties;
        Object jmsxGroupSeq;
        LinkedHashMap applicationPropertiesMap;
        AMQShortString messageId;
        Header header = new Header();
        Properties props = new Properties();
        header.setDurable(Boolean.valueOf(serverMessage.isPersistent()));
        BasicContentHeaderProperties contentHeader = serverMessage.getContentHeaderBody().getProperties();
        header.setPriority(UnsignedByte.valueOf((byte)contentHeader.getPriority()));
        if (contentHeader.hasExpiration()) {
            long expiration = serverMessage.getExpiration();
            long arrivalTime = serverMessage.getArrivalTime();
            header.setTtl(UnsignedInteger.valueOf((long)Math.max(0L, expiration - arrivalTime)));
        }
        if (!"gzip".equals(contentHeader.getEncodingAsString()) && bodySection instanceof DataSection) {
            props.setContentEncoding(Symbol.valueOf((String)contentHeader.getEncodingAsString()));
        }
        Symbol contentType = MessageConverter_0_8_to_1_0.getContentType((String)contentHeader.getContentTypeAsString());
        props.setContentType(contentType);
        AMQShortString correlationId = contentHeader.getCorrelationId();
        if (correlationId != null) {
            String correlationIdAsString;
            byte[] correlationIdAsBytes = correlationId.getBytes();
            if (Arrays.equals(correlationIdAsBytes, (correlationIdAsString = contentHeader.getCorrelationIdAsString()).getBytes(StandardCharsets.UTF_8))) {
                props.setCorrelationId(this.convertMessageId(correlationId));
            } else {
                props.setCorrelationId((Object)correlationIdAsBytes);
            }
        }
        if ((messageId = contentHeader.getMessageId()) != null) {
            props.setMessageId(this.convertMessageId(messageId));
        }
        if (contentHeader.getReplyTo() != null) {
            props.setReplyTo(this.convertReplyTo(contentHeader.getReplyTo()));
        }
        if (contentHeader.getUserId() != null) {
            props.setUserId(new Binary(contentHeader.getUserId().getBytes()));
        }
        if (contentHeader.hasTimestamp()) {
            props.setCreationTime(new Date(contentHeader.getTimestamp()));
        } else {
            props.setCreationTime(new Date(serverMessage.getArrivalTime()));
        }
        if (contentHeader.getType() != null) {
            props.setSubject(contentHeader.getType().toString());
        }
        if ((applicationPropertiesMap = new LinkedHashMap(contentHeader.getHeadersAsMap())).containsKey("qpid.subject")) {
            props.setSubject(String.valueOf(applicationPropertiesMap.get("qpid.subject")));
            applicationPropertiesMap.remove("qpid.subject");
        }
        if (applicationPropertiesMap.containsKey("JMSXGroupID")) {
            props.setGroupId(String.valueOf(applicationPropertiesMap.get("JMSXGroupID")));
            applicationPropertiesMap.remove("JMSXGroupID");
        }
        if (applicationPropertiesMap.containsKey("JMSXGroupSeq") && (jmsxGroupSeq = applicationPropertiesMap.get("JMSXGroupSeq")) instanceof Integer) {
            props.setGroupSequence(UnsignedInteger.valueOf((int)((Integer)jmsxGroupSeq)));
            applicationPropertiesMap.remove("JMSXGroupSeq");
        }
        MessagePublishInfo messagePublishInfo = serverMessage.getMessagePublishInfo();
        String to = AMQShortString.toString((AMQShortString)messagePublishInfo.getExchange());
        if (messagePublishInfo.getRoutingKey() != null) {
            String routingKey = AMQShortString.toString((AMQShortString)messagePublishInfo.getRoutingKey());
            to = to != null && !"".equals(to) ? to + "/" + routingKey : routingKey;
        }
        props.setTo(to);
        try {
            applicationProperties = new ApplicationProperties(applicationPropertiesMap);
        }
        catch (IllegalArgumentException e) {
            throw new MessageConversionException("Could not convert message from 0-8 to 1.0 because headers conversion failed.", (Throwable)e);
        }
        MessageAnnotations messageAnnotations = MessageConverter_0_8_to_1_0.createMessageAnnotation(bodySection, (String)contentHeader.getContentTypeAsString());
        return new MessageMetaData_1_0(header.createEncodingRetainingSection(), null, messageAnnotations == null ? null : messageAnnotations.createEncodingRetainingSection(), props.createEncodingRetainingSection(), applicationProperties.createEncodingRetainingSection(), null, serverMessage.getArrivalTime(), bodySection.getEncodedSize());
    }

    private Object convertMessageId(AMQShortString messageId) {
        try {
            String messageIdAsString = messageId.toString();
            if (messageIdAsString.startsWith("ID:")) {
                messageIdAsString = messageIdAsString.substring(3);
            }
            return UUID.fromString(messageIdAsString);
        }
        catch (IllegalArgumentException e) {
            return messageId.toString();
        }
    }

    private String convertReplyTo(AMQShortString replyTo) {
        String convertedReplyTo;
        String originalReplyTo = String.valueOf(replyTo);
        try {
            AMQBindingURL burl = new AMQBindingURL(originalReplyTo);
            if (burl.getExchangeName() != null && !burl.getExchangeName().equals("")) {
                convertedReplyTo = burl.getExchangeName();
                if (burl.getRoutingKey() != null) {
                    convertedReplyTo = convertedReplyTo + "/" + burl.getRoutingKey();
                }
            } else {
                convertedReplyTo = burl.getQueueName() != null && !burl.getQueueName().equals("") ? burl.getQueueName() : (burl.getRoutingKey() != null ? burl.getRoutingKey() : originalReplyTo);
            }
        }
        catch (URISyntaxException e) {
            convertedReplyTo = originalReplyTo;
        }
        return convertedReplyTo;
    }

    public String getType() {
        return "v0-8 to v1-0";
    }
}

