/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.derby;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.qpid.server.store.StoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyUtils {
    public static final String MEMORY_STORE_LOCATION = ":memory:";
    public static final String DERBY_SINGLE_DB_SHUTDOWN_CODE = "08006";
    private static final String SQL_DRIVER_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String TABLE_EXISTENCE_QUERY = "SELECT 1 FROM SYS.SYSTABLES WHERE TABLENAME = ?";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final Logger DERBY_LOG = LoggerFactory.getLogger((String)"DERBY");
    public static final DerbyLogWriter DERBY_LOG_WRITER = new DerbyLogWriter();
    public static final String DERBY_STREAM_ERROR_METHOD = "derby.stream.error.method";

    public static void loadDerbyDriver() {
        try {
            System.setProperty(DERBY_STREAM_ERROR_METHOD, "org.apache.qpid.server.store.derby.DerbyUtils.getDerbyLogWriter");
            Class<?> driverClass = Class.forName(SQL_DRIVER_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new StoreException("Failed to load driver org.apache.derby.jdbc.EmbeddedDriver", (Throwable)e);
        }
    }

    public static Writer getDerbyLogWriter() {
        return DERBY_LOG_WRITER;
    }

    public static String createConnectionUrl(String name, String databasePath) {
        if (DerbyUtils.isInMemoryDatabase(databasePath)) {
            return "jdbc:derby::memory:/" + name + ";create=true";
        }
        File environmentPath = new File(databasePath);
        if (!environmentPath.exists() && !environmentPath.mkdirs()) {
            throw new IllegalArgumentException("Environment path " + environmentPath + " could not be read or created. " + "Ensure the path is correct and that the permissions are correct.");
        }
        return "jdbc:derby:" + databasePath + "/" + name + ";create=true";
    }

    public static boolean isInMemoryDatabase(String databasePath) {
        return MEMORY_STORE_LOCATION.equals(databasePath);
    }

    public static void shutdownDatabase(String connectionURL) throws SQLException {
        block2: {
            try {
                Connection conn = DriverManager.getConnection(connectionURL + ";shutdown=true");
                conn.close();
            }
            catch (SQLException e) {
                if (e.getSQLState().equalsIgnoreCase(DERBY_SINGLE_DB_SHUTDOWN_CODE)) break block2;
                throw e;
            }
        }
    }

    public static String getBlobAsString(ResultSet rs, int col) throws SQLException {
        Blob blob = rs.getBlob(col);
        if (blob == null) {
            return null;
        }
        byte[] bytes = blob.getBytes(1L, (int)blob.length());
        return new String(bytes, UTF8_CHARSET);
    }

    protected static byte[] getBlobAsBytes(ResultSet rs, int col) throws SQLException {
        Blob dataAsBlob = rs.getBlob(col);
        return dataAsBlob.getBytes(1L, (int)dataAsBlob.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(String tableName, Connection conn) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(TABLE_EXISTENCE_QUERY);){
            boolean bl;
            stmt.setString(1, tableName);
            ResultSet rs = stmt.executeQuery();
            try {
                bl = rs.next();
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return bl;
        }
    }

    private static class DerbyLogWriter
    extends Writer {
        public static final String DERBY_STARTUP_MESSAGE = "Booting Derby version ";
        public static final String DERBY_SHUTDOWN_MESSAGE = "Shutting down instance ";
        public static final String DERBY_CLASS_LOADER_STARTED_MESSAGE = "Database Class Loader started";
        public static final String DERBY_SYSTEM_HOME = "derby.system.home";
        public static final String DASHED_LINE = "\\s*-*\\s*";
        private final ThreadLocal<StringBuilder> _threadLocalBuffer = new ThreadLocal<StringBuilder>(){

            @Override
            protected StringBuilder initialValue() {
                return new StringBuilder();
            }
        };

        private DerbyLogWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this._threadLocalBuffer.get().append(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            String logMessage = this._threadLocalBuffer.get().toString();
            if (!logMessage.matches(DASHED_LINE)) {
                if (logMessage.contains(DERBY_STARTUP_MESSAGE)) {
                    logMessage = logMessage.substring(logMessage.indexOf(10) + 1);
                }
                if (logMessage.startsWith(DERBY_STARTUP_MESSAGE) || logMessage.startsWith(DERBY_SHUTDOWN_MESSAGE)) {
                    DERBY_LOG.info(logMessage);
                } else if (logMessage.startsWith(DERBY_SYSTEM_HOME) || logMessage.startsWith(DerbyUtils.DERBY_STREAM_ERROR_METHOD) || logMessage.startsWith("java.vendor") || logMessage.startsWith(DERBY_CLASS_LOADER_STARTED_MESSAGE)) {
                    DERBY_LOG.debug(logMessage);
                } else {
                    DERBY_LOG.warn(logMessage);
                }
            }
            this._threadLocalBuffer.set(new StringBuilder());
        }

        @Override
        public void close() throws IOException {
        }
    }
}

