/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode.derby;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.ConfigStoreMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.derby.DerbyConfigurationStore;
import org.apache.qpid.server.store.derby.DerbyUtils;
import org.apache.qpid.server.store.jdbc.JDBCContainer;
import org.apache.qpid.server.store.jdbc.JDBCDetails;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.FileHelper;
import org.apache.qpid.server.virtualhostnode.AbstractStandardVirtualHostNode;
import org.apache.qpid.server.virtualhostnode.derby.DerbyVirtualHostNode;

@ManagedObject(category=false, type="DERBY", validChildTypes="org.apache.qpid.server.virtualhostnode.derby.DerbyVirtualHostNodeImpl#getSupportedChildTypes()")
public class DerbyVirtualHostNodeImpl
extends AbstractStandardVirtualHostNode<DerbyVirtualHostNodeImpl>
implements DerbyVirtualHostNode<DerbyVirtualHostNodeImpl>,
JDBCContainer {
    public static final String VIRTUAL_HOST_NODE_TYPE = "DERBY";
    @ManagedAttributeField
    private String _storePath;

    @ManagedObjectFactoryConstructor(conditionallyAvailable=true, condition="org.apache.qpid.server.store.derby.DerbyUtils#isAvailable()")
    public DerbyVirtualHostNodeImpl(Map<String, Object> attributes, Broker<?> parent) {
        super(attributes, parent);
    }

    protected void writeLocationEventLog() {
        this.getEventLogger().message((LogSubject)this.getConfigurationStoreLogSubject(), ConfigStoreMessages.STORE_LOCATION((String)this.getStorePath()));
    }

    protected DurableConfigurationStore createConfigurationStore() {
        return new DerbyConfigurationStore(VirtualHost.class);
    }

    @Override
    public String getStorePath() {
        return this._storePath;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.getId() + ", name=" + this.getName() + ", storePath=" + this.getStorePath() + "]";
    }

    public static Map<String, Collection<String>> getSupportedChildTypes() {
        return Collections.singletonMap(VirtualHost.class.getSimpleName(), DerbyVirtualHostNodeImpl.getSupportedVirtualHostTypes((boolean)true));
    }

    public void validateOnCreate() {
        if (!new FileHelper().isWritableDirectory(this.getStorePath())) {
            throw new IllegalConfigurationException("The store path is not writable directory");
        }
    }

    public PreferenceStore getPreferenceStore() {
        return ((DerbyConfigurationStore)this.getConfigurationStore()).getPreferenceStore();
    }

    public JDBCDetails getJDBCDetails() {
        return JDBCDetails.getJdbcDetails((String)"derby", (ConfiguredObject)this);
    }

    public Connection getConnection() {
        try {
            return ((DerbyConfigurationStore)this.getConfigurationStore()).getConnection();
        }
        catch (SQLException e) {
            throw new ConnectionScopedRuntimeException(String.format("Error opening connection to database for VirtualHostNode '%s'", this.getName()));
        }
    }

    public String getTableNamePrefix() {
        return "";
    }

    static {
        DerbyUtils.configureDerbyLogging();
    }
}

