/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.derby;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreProvider;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.derby.AbstractDerbyMessageStore;
import org.apache.qpid.server.store.derby.DerbyUtils;
import org.apache.qpid.server.store.jdbc.AbstractJDBCConfigurationStore;
import org.apache.qpid.server.store.jdbc.AbstractJDBCPreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyConfigurationStore
extends AbstractJDBCConfigurationStore
implements MessageStoreProvider,
DurableConfigurationStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerbyConfigurationStore.class);
    private final ProvidedDerbyMessageStore _providedMessageStore = new ProvidedDerbyMessageStore();
    private final ProvidedPreferenceStore _providedPreferenceStore = new ProvidedPreferenceStore();
    private String _connectionURL;
    private ConfiguredObject<?> _parent;
    private final Class<? extends ConfiguredObject> _rootClass;

    public DerbyConfigurationStore(Class<? extends ConfiguredObject> rootClass) {
        this._rootClass = rootClass;
    }

    public void init(ConfiguredObject<?> parent) throws StoreException {
        this.changeState(AbstractJDBCConfigurationStore.State.CLOSED, AbstractJDBCConfigurationStore.State.CONFIGURED);
        this._parent = parent;
        DerbyUtils.loadDerbyDriver();
        this._connectionURL = DerbyUtils.createConnectionUrl(parent.getName(), ((FileBasedSettings)this._parent).getStorePath());
        this.createOrOpenConfigurationStoreDatabase();
    }

    public void upgradeStoreStructure() throws StoreException {
        this.upgradeIfNecessary(this._parent);
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this._connectionURL);
    }

    public void closeConfigurationStore() throws StoreException {
        if (this._providedMessageStore.isMessageStoreOpen()) {
            throw new IllegalStateException("Cannot close the store as the provided message store is still open");
        }
        this.doIfNotState(AbstractJDBCConfigurationStore.State.CLOSED, () -> {
            try {
                DerbyUtils.shutdownDatabase(this._connectionURL);
            }
            catch (SQLException e) {
                throw new StoreException("Error closing configuration store", (Throwable)e);
            }
        });
        this.setState(AbstractJDBCConfigurationStore.State.CLOSED);
    }

    protected String getSqlBlobType() {
        return "blob";
    }

    protected String getSqlBlobStorage(String columnName) {
        return "";
    }

    protected String getSqlVarBinaryType(int size) {
        return "varchar(" + size + ") for bit data";
    }

    protected String getSqlBigIntType() {
        return "bigint";
    }

    protected String getBlobAsString(ResultSet rs, int col) throws SQLException {
        return DerbyUtils.getBlobAsString(rs, col);
    }

    public void onDelete(ConfiguredObject<?> parent) {
        if (this._providedMessageStore.isMessageStoreOpen()) {
            throw new IllegalStateException("Cannot delete the store as the provided message store is still open");
        }
        FileBasedSettings fileBasedSettings = (FileBasedSettings)parent;
        String storePath = fileBasedSettings.getStorePath();
        if (!"memory:".equals(storePath) && storePath != null) {
            LOGGER.debug("Deleting store {}", (Object)storePath);
            File configFile = new File(storePath);
            if (!FileUtils.delete((File)configFile, (boolean)true)) {
                LOGGER.info("Failed to delete the store at location " + storePath);
            }
        }
    }

    public MessageStore getMessageStore() {
        return this._providedMessageStore;
    }

    public PreferenceStore getPreferenceStore() {
        return this._providedPreferenceStore;
    }

    protected boolean tableExists(String tableName, Connection conn) throws SQLException {
        return DerbyUtils.tableExists(tableName, conn);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    private class ProvidedPreferenceStore
    extends AbstractJDBCPreferenceStore {
        private final Logger LOGGER = LoggerFactory.getLogger(ProvidedPreferenceStore.class);

        private ProvidedPreferenceStore() {
        }

        protected Logger getLogger() {
            return this.LOGGER;
        }

        protected Connection getConnection() throws SQLException {
            return DerbyConfigurationStore.this.getConnection();
        }

        protected String getSqlBlobType() {
            return "blob";
        }

        protected String getBlobAsString(ResultSet rs, int col) throws SQLException {
            return DerbyUtils.getBlobAsString(rs, col);
        }

        protected void doDelete() {
            try {
                this.dropTables(DerbyConfigurationStore.this.getConnection());
            }
            catch (SQLException e) {
                this.getLogger().warn("Could not drop preference database tables on deletion", (Throwable)e);
            }
        }

        public void doClose() {
        }
    }

    private class ProvidedDerbyMessageStore
    extends AbstractDerbyMessageStore {
        private ProvidedDerbyMessageStore() {
        }

        @Override
        protected void doOpen(ConfiguredObject<?> parent) {
        }

        public Connection getConnection() throws SQLException {
            this.checkMessageStoreOpen();
            return DerbyConfigurationStore.this.getConnection();
        }

        @Override
        protected void doClose() {
        }

        public String getStoreLocation() {
            return ((FileBasedSettings)DerbyConfigurationStore.this._parent).getStorePath();
        }

        public File getStoreLocationAsFile() {
            return DerbyUtils.isInMemoryDatabase(this.getStoreLocation()) ? null : new File(this.getStoreLocation());
        }

        public void onDelete(ConfiguredObject<?> parent) {
            if (this.isMessageStoreOpen()) {
                throw new IllegalStateException("Cannot delete the store as store is still open");
            }
            try (Connection connection = DerbyConfigurationStore.this.getConnection();){
                this.onDelete(connection);
            }
            catch (SQLException e) {
                throw new StoreException("Cannot get connection to perform deletion", (Throwable)e);
            }
        }

        protected Logger getLogger() {
            return DerbyConfigurationStore.this.getLogger();
        }
    }
}

