/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback.jdbc;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import com.google.common.util.concurrent.ListenableFuture;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.logging.logback.AbstractBrokerLogger;
import org.apache.qpid.server.logging.logback.BrokerLoggerStatusListener;
import org.apache.qpid.server.logging.logback.jdbc.JDBCBrokerLogger;
import org.apache.qpid.server.logging.logback.jdbc.JDBCLoggerHelper;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.BrokerLogger;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.security.FileKeyStore;
import org.apache.qpid.server.security.FileTrustStore;

@ManagedObject(category=false, type="JDBC", validChildTypes="org.apache.qpid.server.logging.logback.AbstractLogger#getSupportedBrokerLoggerChildTypes()")
public class JDBCBrokerLoggerImpl
extends AbstractBrokerLogger<JDBCBrokerLoggerImpl>
implements JDBCBrokerLogger<JDBCBrokerLoggerImpl> {
    static final String CONFIGURED_OBJECT_TYPE = "JDBC";
    private final JDBCLoggerHelper _jdbcLoggerHelper = new JDBCLoggerHelper();
    private volatile BrokerLoggerStatusListener _logbackStatusListener;
    private volatile StatusManager _statusManager;
    @ManagedAttributeField(afterSet="restartConnectionSourceIfExists")
    private String _connectionUrl;
    @ManagedAttributeField(afterSet="restartConnectionSourceIfExists")
    private String _connectionPoolType;
    @ManagedAttributeField(afterSet="restartConnectionSourceIfExists")
    private String _username;
    @ManagedAttributeField(afterSet="restartConnectionSourceIfExists")
    private String _password;
    @ManagedAttributeField(afterSet="restartAppenderIfExists")
    private String _tableNamePrefix;
    @ManagedAttributeField(afterSet="restartConnectionSourceIfExists")
    private FileKeyStore<?> _keyStore;
    @ManagedAttributeField(afterSet="restartConnectionSourceIfExists")
    private String _keyStorePathPropertyName;
    @ManagedAttributeField(afterSet="restartConnectionSourceIfExists")
    private String _keyStorePasswordPropertyName;
    @ManagedAttributeField(afterSet="restartConnectionSourceIfExists")
    private FileTrustStore<?> _trustStore;
    @ManagedAttributeField(afterSet="restartConnectionSourceIfExists")
    private String _trustStorePathPropertyName;
    @ManagedAttributeField(afterSet="restartConnectionSourceIfExists")
    private String _trustStorePasswordPropertyName;

    @ManagedObjectFactoryConstructor
    protected JDBCBrokerLoggerImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    public String getConnectionUrl() {
        return this._connectionUrl;
    }

    @Override
    public String getConnectionPoolType() {
        return this._connectionPoolType;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public String getTableNamePrefix() {
        return this._tableNamePrefix;
    }

    @Override
    public FileKeyStore<?> getKeyStore() {
        return this._keyStore;
    }

    @Override
    public String getKeyStorePathPropertyName() {
        return this._keyStorePathPropertyName;
    }

    @Override
    public String getKeyStorePasswordPropertyName() {
        return this._keyStorePasswordPropertyName;
    }

    @Override
    public FileTrustStore<?> getTrustStore() {
        return this._trustStore;
    }

    @Override
    public String getTrustStorePathPropertyName() {
        return this._trustStorePathPropertyName;
    }

    @Override
    public String getTrustStorePasswordPropertyName() {
        return this._trustStorePasswordPropertyName;
    }

    protected ListenableFuture<Void> onClose() {
        this.onCloseOrDelete();
        return super.onClose();
    }

    protected ListenableFuture<Void> onDelete() {
        this.onCloseOrDelete();
        return super.onDelete();
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        if (changedAttributes.contains("connectionUrl") || changedAttributes.contains("username") || changedAttributes.contains("password") || changedAttributes.contains("connectionPoolType")) {
            this._jdbcLoggerHelper.validateConnectionSourceSettings((ConfiguredObject<?>)this, (JDBCBrokerLogger)proxyForValidation);
        }
    }

    protected void validateOnCreate() {
        super.validateOnCreate();
        this._jdbcLoggerHelper.validateConnectionSourceSettings((ConfiguredObject<?>)this, this);
    }

    protected Appender<ILoggingEvent> createAppenderInstance(Context context) {
        SystemConfig systemConfig = (SystemConfig)this.getAncestor(SystemConfig.class);
        this._logbackStatusListener = new BrokerLoggerStatusListener((BrokerLogger)this, systemConfig, "qpid.broker.failOnJdbcLoggerError", new Class[]{SQLException.class});
        this._statusManager = context.getStatusManager();
        this._statusManager.add((StatusListener)this._logbackStatusListener);
        return this._jdbcLoggerHelper.createAppenderInstance(context, (ConfiguredObject<?>)this, this);
    }

    private void onCloseOrDelete() {
        if (this._statusManager != null) {
            this._statusManager.remove((StatusListener)this._logbackStatusListener);
        }
    }

    private void restartAppenderIfExists() {
        this._jdbcLoggerHelper.restartAppenderIfExists(this.getAppender());
    }

    private void restartConnectionSourceIfExists() {
        this._jdbcLoggerHelper.restartConnectionSourceIfExists(this.getAppender());
    }
}

