/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc.bonecp;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;

public class BoneCPConnectionProvider
implements ConnectionProvider {
    public static final int DEFAULT_MIN_CONNECTIONS_PER_PARTITION = 5;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_PARTITION = 10;
    public static final int DEFAULT_PARTITION_COUNT = 4;
    private final BoneCP _connectionPool;

    public BoneCPConnectionProvider(String connectionUrl, VirtualHost virtualHost) throws SQLException {
        BoneCPConfig config = new BoneCPConfig();
        config.setJdbcUrl(connectionUrl);
        config.setMinConnectionsPerPartition(this.getIntegerAttribute(virtualHost, "minConnectionsPerPartition", 5));
        config.setMaxConnectionsPerPartition(this.getIntegerAttribute(virtualHost, "maxConnectionsPerPartition", 10));
        config.setPartitionCount(this.getIntegerAttribute(virtualHost, "partitionCount", 4));
        this._connectionPool = new BoneCP(config);
    }

    private int getIntegerAttribute(VirtualHost virtualHost, String attributeName, int defaultVal) {
        Object attrValue = virtualHost.getAttribute(attributeName);
        if (attrValue != null) {
            if (attrValue instanceof Number) {
                return ((Number)attrValue).intValue();
            }
            if (attrValue instanceof String) {
                try {
                    return Integer.parseInt((String)attrValue);
                }
                catch (NumberFormatException e) {
                    return defaultVal;
                }
            }
        }
        return defaultVal;
    }

    public Connection getConnection() throws SQLException {
        return this._connectionPool.getConnection();
    }

    public void close() throws SQLException {
        this._connectionPool.shutdown();
    }
}

