/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.plugin.JDBCConnectionProviderFactory;
import org.apache.qpid.server.store.AbstractJDBCMessageStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;
import org.apache.qpid.server.store.jdbc.DefaultConnectionProviderFactory;

public class JDBCMessageStore
extends AbstractJDBCMessageStore
implements MessageStore {
    private static final Logger _logger = Logger.getLogger(JDBCMessageStore.class);
    public static final String TYPE = "JDBC";
    public static final String CONNECTION_URL = "connectionURL";
    protected String _connectionURL;
    private ConnectionProvider _connectionProvider;
    private static JDBCDetails DERBY_DETAILS = new JDBCDetails("derby", "blob", "varchar(%d) for bit data", "bigint", false);
    private static JDBCDetails POSTGRESQL_DETAILS = new JDBCDetails("postgresql", "bytea", "bytea", "bigint", true);
    private static JDBCDetails MYSQL_DETAILS = new JDBCDetails("mysql", "blob", "varbinary(%d)", "bigint", false);
    private static JDBCDetails SYBASE_DETAILS = new JDBCDetails("sybase", "image", "varbinary(%d)", "bigint", false);
    private static JDBCDetails ORACLE_DETAILS = new JDBCDetails("oracle", "blob", "raw(%d)", "number", false);
    private static Map<String, JDBCDetails> VENDOR_DETAILS = new HashMap<String, JDBCDetails>();
    private String _blobType;
    private String _varBinaryType;
    private String _bigIntType;
    private boolean _useBytesMethodsForBlob;
    private List<RecordedJDBCTransaction> _transactions = new CopyOnWriteArrayList<RecordedJDBCTransaction>();

    private static void addDetails(JDBCDetails details) {
        VENDOR_DETAILS.put(details.getVendor(), details);
    }

    protected Logger getLogger() {
        return _logger;
    }

    protected String getSqlBlobType() {
        return this._blobType;
    }

    protected String getSqlVarBinaryType(int size) {
        return String.format(this._varBinaryType, size);
    }

    public String getSqlBigIntType() {
        return this._bigIntType;
    }

    protected void doClose() throws AMQStoreException {
        while (!this._transactions.isEmpty()) {
            RecordedJDBCTransaction txn = this._transactions.get(0);
            txn.abortTran();
        }
        try {
            this._connectionProvider.close();
        }
        catch (SQLException e) {
            throw new AMQStoreException("Unable to close connection provider ", (Throwable)e);
        }
    }

    protected Connection getConnection() throws SQLException {
        return this._connectionProvider.getConnection();
    }

    protected void implementationSpecificConfiguration(String name, VirtualHost virtualHost) throws ClassNotFoundException, SQLException {
        Object poolAttribute;
        String connectionPoolType;
        JDBCConnectionProviderFactory connectionProviderFactory;
        String connectionURL = virtualHost.getAttribute(CONNECTION_URL) == null ? String.valueOf(virtualHost.getAttribute("storePath")) : String.valueOf(virtualHost.getAttribute(CONNECTION_URL));
        JDBCDetails details = null;
        String[] components = connectionURL.split(":", 3);
        if (components.length >= 2) {
            String vendor = components[1];
            details = VENDOR_DETAILS.get(vendor);
        }
        if (details == null) {
            this.getLogger().info((Object)("Do not recognize vendor from connection URL: " + connectionURL));
            details = DERBY_DETAILS;
        }
        if ((connectionProviderFactory = JDBCConnectionProviderFactory.FACTORIES.get((String)(connectionPoolType = (poolAttribute = virtualHost.getAttribute("connectionPool")) == null ? "DEFAULT" : String.valueOf(poolAttribute)))) == null) {
            _logger.warn((Object)("Unknown connection pool type: " + connectionPoolType + ".  no connection pooling will be used"));
            connectionProviderFactory = new DefaultConnectionProviderFactory();
        }
        this._connectionProvider = connectionProviderFactory.getConnectionProvider(connectionURL, virtualHost);
        this._blobType = this.getStringAttribute(virtualHost, "jdbcBlobType", details.getBlobType());
        this._varBinaryType = this.getStringAttribute(virtualHost, "jdbcVarbinaryType", details.getVarBinaryType());
        this._useBytesMethodsForBlob = this.getBooleanAttribute(virtualHost, "jdbcBytesForBlob", details.isUseBytesMethodsForBlob());
        this._bigIntType = this.getStringAttribute(virtualHost, "jdbcBigIntType", details.getBigintType());
    }

    private String getStringAttribute(VirtualHost virtualHost, String attributeName, String defaultVal) {
        Object attrValue = virtualHost.getAttribute(attributeName);
        if (attrValue != null) {
            return attrValue.toString();
        }
        return defaultVal;
    }

    private boolean getBooleanAttribute(VirtualHost virtualHost, String attributeName, boolean defaultVal) {
        Object attrValue = virtualHost.getAttribute(attributeName);
        if (attrValue != null) {
            if (attrValue instanceof Boolean) {
                return (Boolean)attrValue;
            }
            if (attrValue instanceof String) {
                return Boolean.parseBoolean((String)attrValue);
            }
        }
        return defaultVal;
    }

    protected void storedSizeChange(int contentSize) {
    }

    public String getStoreLocation() {
        return "";
    }

    public String getStoreType() {
        return TYPE;
    }

    protected byte[] getBlobAsBytes(ResultSet rs, int col) throws SQLException {
        if (this._useBytesMethodsForBlob) {
            return rs.getBytes(col);
        }
        Blob dataAsBlob = rs.getBlob(col);
        return dataAsBlob.getBytes(1L, (int)dataAsBlob.length());
    }

    protected String getBlobAsString(ResultSet rs, int col) throws SQLException {
        if (this._useBytesMethodsForBlob) {
            byte[] bytes = rs.getBytes(col);
            return new String(bytes, UTF8_CHARSET);
        }
        Blob blob = rs.getBlob(col);
        if (blob == null) {
            return null;
        }
        byte[] bytes = blob.getBytes(1L, (int)blob.length());
        return new String(bytes, UTF8_CHARSET);
    }

    public Transaction newTransaction() {
        return new RecordedJDBCTransaction();
    }

    static {
        JDBCMessageStore.addDetails(DERBY_DETAILS);
        JDBCMessageStore.addDetails(POSTGRESQL_DETAILS);
        JDBCMessageStore.addDetails(MYSQL_DETAILS);
        JDBCMessageStore.addDetails(SYBASE_DETAILS);
        JDBCMessageStore.addDetails(ORACLE_DETAILS);
    }

    private class RecordedJDBCTransaction
    extends AbstractJDBCMessageStore.JDBCTransaction {
        private RecordedJDBCTransaction() {
            super((AbstractJDBCMessageStore)JDBCMessageStore.this);
            JDBCMessageStore.this._transactions.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commitTran() throws AMQStoreException {
            try {
                super.commitTran();
            }
            finally {
                JDBCMessageStore.this._transactions.remove((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StoreFuture commitTranAsync() throws AMQStoreException {
            try {
                StoreFuture storeFuture = super.commitTranAsync();
                return storeFuture;
            }
            finally {
                JDBCMessageStore.this._transactions.remove((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abortTran() throws AMQStoreException {
            try {
                super.abortTran();
            }
            finally {
                JDBCMessageStore.this._transactions.remove((Object)this);
            }
        }
    }

    private static class JDBCDetails {
        private final String _vendor;
        private String _blobType;
        private String _varBinaryType;
        private String _bigintType;
        private boolean _useBytesMethodsForBlob;

        private JDBCDetails(String vendor, String blobType, String varBinaryType, String bigIntType, boolean useBytesMethodsForBlob) {
            this._vendor = vendor;
            this.setBlobType(blobType);
            this.setVarBinaryType(varBinaryType);
            this.setBigintType(bigIntType);
            this.setUseBytesMethodsForBlob(useBytesMethodsForBlob);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JDBCDetails that = (JDBCDetails)o;
            return this.getVendor().equals(that.getVendor());
        }

        public int hashCode() {
            return this.getVendor().hashCode();
        }

        public String toString() {
            return "JDBCDetails{vendor='" + this.getVendor() + '\'' + ", blobType='" + this.getBlobType() + '\'' + ", varBinaryType='" + this.getVarBinaryType() + '\'' + ", bigIntType='" + this.getBigintType() + '\'' + ", useBytesMethodsForBlob=" + this.isUseBytesMethodsForBlob() + '}';
        }

        public String getVendor() {
            return this._vendor;
        }

        public String getBlobType() {
            return this._blobType;
        }

        public void setBlobType(String blobType) {
            this._blobType = blobType;
        }

        public String getVarBinaryType() {
            return this._varBinaryType;
        }

        public void setVarBinaryType(String varBinaryType) {
            this._varBinaryType = varBinaryType;
        }

        public boolean isUseBytesMethodsForBlob() {
            return this._useBytesMethodsForBlob;
        }

        public void setUseBytesMethodsForBlob(boolean useBytesMethodsForBlob) {
            this._useBytesMethodsForBlob = useBytesMethodsForBlob;
        }

        public String getBigintType() {
            return this._bigintType;
        }

        public void setBigintType(String bigintType) {
            this._bigintType = bigintType;
        }
    }
}

