/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.qpid.server.plugin.MessageStoreFactory;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.jdbc.JDBCMessageStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCMessageStoreFactory
implements MessageStoreFactory {
    public String getType() {
        return "JDBC";
    }

    public MessageStore createMessageStore() {
        return new JDBCMessageStore();
    }

    public Map<String, Object> convertStoreConfiguration(Configuration storeConfiguration) {
        HashMap<String, Object> convertedMap = new HashMap<String, Object>();
        convertedMap.put("jdbcBlobType", storeConfiguration.getString("sqlBlobType"));
        convertedMap.put("jdbcVarbinaryType", storeConfiguration.getString("sqlVarbinaryType"));
        if (storeConfiguration.containsKey("useBytesForBlob")) {
            convertedMap.put("jdbcUseBytesForBlob", storeConfiguration.getBoolean("useBytesForBlob"));
        }
        convertedMap.put("jdbcBigIntType", storeConfiguration.getString("sqlBigIntType"));
        convertedMap.put("connectionPool", storeConfiguration.getString("pool.type"));
        convertedMap.put("minConnectionsPerPartition", storeConfiguration.getInteger("pool.minConnectionsPerPartition", null));
        convertedMap.put("maxConnectionsPerPartition", storeConfiguration.getInteger("pool.maxConnectionsPerPartition", null));
        convertedMap.put("partitionCount", storeConfiguration.getInteger("pool.partitionCount", null));
        return convertedMap;
    }

    public void validateAttributes(Map<String, Object> attributes) {
        Object storePath;
        Object connectionURL = attributes.get("connectionURL");
        if (!(connectionURL instanceof String) && !((storePath = attributes.get("storePath")) instanceof String)) {
            throw new IllegalArgumentException("Attribute 'connectionURL' is required and must be of type String.");
        }
    }
}

