/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.AbstractJDBCMessageStore;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.Transaction;

public abstract class GenericAbstractJDBCMessageStore
extends AbstractJDBCMessageStore {
    private final AtomicBoolean _messageStoreOpen = new AtomicBoolean(false);
    private final List<RecordedJDBCTransaction> _transactions = new CopyOnWriteArrayList<RecordedJDBCTransaction>();
    private ConfiguredObject<?> _parent;

    public final void openMessageStore(ConfiguredObject<?> parent) {
        if (this._messageStoreOpen.compareAndSet(false, true)) {
            this._parent = parent;
            this.doOpen(parent);
            this.createOrOpenMessageStoreDatabase();
            this.setMaximumMessageId();
        }
    }

    protected abstract void doOpen(ConfiguredObject<?> var1) throws StoreException;

    public final void upgradeStoreStructure() throws StoreException {
        this.checkMessageStoreOpen();
        this.upgrade(this._parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeMessageStore() {
        if (this._messageStoreOpen.compareAndSet(true, false)) {
            try {
                while (!this._transactions.isEmpty()) {
                    RecordedJDBCTransaction txn = this._transactions.get(0);
                    txn.abortTran();
                }
            }
            finally {
                this.doClose();
                super.closeMessageStore();
            }
        }
    }

    protected abstract void doClose();

    protected boolean isMessageStoreOpen() {
        return this._messageStoreOpen.get();
    }

    protected void checkMessageStoreOpen() {
        if (!this._messageStoreOpen.get()) {
            throw new IllegalStateException("Message store is not open");
        }
    }

    protected void storedSizeChange(int contentSize) {
    }

    public Transaction newTransaction() {
        return new RecordedJDBCTransaction();
    }

    private class RecordedJDBCTransaction
    extends AbstractJDBCMessageStore.JDBCTransaction {
        private RecordedJDBCTransaction() {
            super((AbstractJDBCMessageStore)GenericAbstractJDBCMessageStore.this);
            GenericAbstractJDBCMessageStore.this._transactions.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commitTran() {
            try {
                super.commitTran();
            }
            finally {
                GenericAbstractJDBCMessageStore.this._transactions.remove((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <X> ListenableFuture<X> commitTranAsync(X val) {
            try {
                ListenableFuture listenableFuture = super.commitTranAsync(val);
                return listenableFuture;
            }
            finally {
                GenericAbstractJDBCMessageStore.this._transactions.remove((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abortTran() {
            try {
                super.abortTran();
            }
            finally {
                GenericAbstractJDBCMessageStore.this._transactions.remove((Object)this);
            }
        }
    }
}

