/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;

public abstract class JDBCDetails {
    public static final String CONTEXT_JDBCSTORE_BIGINTTYPE = "qpid.jdbcstore.bigIntType";
    public static final String CONTEXT_JDBCSTORE_VARBINARYTYPE = "qpid.jdbcstore.varBinaryType";
    public static final String CONTEXT_JDBCSTORE_BLOBTYPE = "qpid.jdbcstore.blobType";
    public static final String CONTEXT_JDBCSTORE_USEBYTESFORBLOB = "qpid.jdbcstore.useBytesForBlob";

    public abstract String getVendor();

    public abstract String getBlobType();

    public abstract String getVarBinaryType();

    public abstract String getBigintType();

    public abstract boolean isUseBytesMethodsForBlob();

    public abstract boolean isKnownVendor();

    public abstract boolean isOverridden();

    public String toString() {
        return "JDBCDetails{vendor='" + this.getVendor() + '\'' + ", blobType='" + this.getBlobType() + '\'' + ", varBinaryType='" + this.getVarBinaryType() + '\'' + ", bigIntType='" + this.getBigintType() + '\'' + ", useBytesMethodsForBlob=" + this.isUseBytesMethodsForBlob() + ", knownVendor=" + this.isKnownVendor() + ", overridden=" + this.isOverridden() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JDBCDetails that = (JDBCDetails)o;
        if (this.isKnownVendor() != that.isKnownVendor()) {
            return false;
        }
        if (this.isOverridden() != that.isOverridden()) {
            return false;
        }
        if (this.isUseBytesMethodsForBlob() != that.isUseBytesMethodsForBlob()) {
            return false;
        }
        if (this.getBigintType() != null ? !this.getBigintType().equals(that.getBigintType()) : that.getBigintType() != null) {
            return false;
        }
        if (this.getBlobType() != null ? !this.getBlobType().equals(that.getBlobType()) : that.getBlobType() != null) {
            return false;
        }
        if (this.getVarBinaryType() != null ? !this.getVarBinaryType().equals(that.getVarBinaryType()) : that.getVarBinaryType() != null) {
            return false;
        }
        return !(this.getVendor() != null ? !this.getVendor().equals(that.getVendor()) : that.getVendor() != null);
    }

    public int hashCode() {
        int result = this.getVendor() != null ? this.getVendor().hashCode() : 0;
        result = 31 * result + (this.getBlobType() != null ? this.getBlobType().hashCode() : 0);
        result = 31 * result + (this.getVarBinaryType() != null ? this.getVarBinaryType().hashCode() : 0);
        result = 31 * result + (this.getBigintType() != null ? this.getBigintType().hashCode() : 0);
        result = 31 * result + (this.isUseBytesMethodsForBlob() ? 1 : 0);
        result = 31 * result + (this.isKnownVendor() ? 1 : 0);
        result = 31 * result + (this.isOverridden() ? 1 : 0);
        return result;
    }

    public static JDBCDetails getDetailsForJdbcUrl(String jdbcUrl, final ConfiguredObject<?> object) {
        final Set contextKeys = object.getContextKeys(false);
        AbstractMap<String, String> mapConversion = new AbstractMap<String, String>(){

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return new AbstractSet<Map.Entry<String, String>>(){

                    @Override
                    public Iterator<Map.Entry<String, String>> iterator() {
                        final Iterator underlying = contextKeys.iterator();
                        return new Iterator<Map.Entry<String, String>>(){

                            @Override
                            public boolean hasNext() {
                                return underlying.hasNext();
                            }

                            @Override
                            public Map.Entry<String, String> next() {
                                final String key = (String)underlying.next();
                                final String value = (String)object.getContextValue(String.class, key);
                                return new Map.Entry<String, String>(){

                                    @Override
                                    public String getKey() {
                                        return key;
                                    }

                                    @Override
                                    public String getValue() {
                                        return value;
                                    }

                                    @Override
                                    public String setValue(String value2) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return contextKeys.size();
                    }
                };
            }
        };
        return JDBCDetails.getDetailsForJdbcUrl(jdbcUrl, (Map<String, String>)mapConversion);
    }

    public static JDBCDetails getDetailsForJdbcUrl(String jdbcUrl, final Map<String, String> contextMap) {
        JDBCDetails details;
        String[] components = jdbcUrl.split(":", 3);
        if (components.length >= 2) {
            String vendor = components[1];
            details = KnownJDBCDetails.VENDOR_DETAILS.containsKey(vendor) ? (JDBCDetails)KnownJDBCDetails.VENDOR_DETAILS.get(vendor) : KnownJDBCDetails.FALLBACK;
        } else {
            details = KnownJDBCDetails.FALLBACK;
        }
        return new JDBCDetails(){

            @Override
            public String getVendor() {
                return details.getVendor();
            }

            @Override
            public String getBlobType() {
                return contextMap.containsKey(JDBCDetails.CONTEXT_JDBCSTORE_BLOBTYPE) ? String.valueOf(contextMap.get(JDBCDetails.CONTEXT_JDBCSTORE_BLOBTYPE)) : details.getBlobType();
            }

            @Override
            public String getVarBinaryType() {
                return contextMap.containsKey(JDBCDetails.CONTEXT_JDBCSTORE_VARBINARYTYPE) ? String.valueOf(contextMap.get(JDBCDetails.CONTEXT_JDBCSTORE_VARBINARYTYPE)) : details.getVarBinaryType();
            }

            @Override
            public String getBigintType() {
                return contextMap.containsKey(JDBCDetails.CONTEXT_JDBCSTORE_BIGINTTYPE) ? String.valueOf(contextMap.get(JDBCDetails.CONTEXT_JDBCSTORE_BIGINTTYPE)) : details.getBigintType();
            }

            @Override
            public boolean isUseBytesMethodsForBlob() {
                return contextMap.containsKey(JDBCDetails.CONTEXT_JDBCSTORE_USEBYTESFORBLOB) ? Boolean.parseBoolean((String)contextMap.get(JDBCDetails.CONTEXT_JDBCSTORE_USEBYTESFORBLOB)) : details.isUseBytesMethodsForBlob();
            }

            @Override
            public boolean isKnownVendor() {
                return details.isKnownVendor();
            }

            @Override
            public boolean isOverridden() {
                return contextMap.containsKey(JDBCDetails.CONTEXT_JDBCSTORE_USEBYTESFORBLOB) || contextMap.containsKey(JDBCDetails.CONTEXT_JDBCSTORE_BIGINTTYPE) || contextMap.containsKey(JDBCDetails.CONTEXT_JDBCSTORE_VARBINARYTYPE) || contextMap.containsKey(JDBCDetails.CONTEXT_JDBCSTORE_BLOBTYPE);
            }
        };
    }

    static class KnownJDBCDetails
    extends JDBCDetails {
        private static final JDBCDetails FALLBACK = new KnownJDBCDetails("fallback", "blob", "varchar(%d) for bit data", "bigint", false, false);
        private static final JDBCDetails ORACLE = new KnownJDBCDetails("oracle", "blob", "raw(%d)", "number", false, true);
        private static final JDBCDetails SYBASE = new KnownJDBCDetails("sybase", "image", "varbinary(%d)", "bigint", false, true);
        private static final JDBCDetails POSTGRES = new KnownJDBCDetails("postgresql", "bytea", "bytea", "bigint", true, true);
        private static final JDBCDetails DERBY = new KnownJDBCDetails("derby", "blob", "varchar(%d) for bit data", "bigint", false, true);
        private static final Map<String, JDBCDetails> VENDOR_DETAILS;
        private final String _vendor;
        private final String _blobType;
        private final String _varBinaryType;
        private final String _bigintType;
        private final boolean _useBytesMethodsForBlob;
        private final boolean _isKnownVendor;

        KnownJDBCDetails(String vendor, String blobType, String varBinaryType, String bigIntType, boolean useBytesMethodsForBlob, boolean knownVendor) {
            this._vendor = vendor;
            this._blobType = blobType;
            this._varBinaryType = varBinaryType;
            this._bigintType = bigIntType;
            this._useBytesMethodsForBlob = useBytesMethodsForBlob;
            this._isKnownVendor = knownVendor;
        }

        @Override
        public String getVendor() {
            return this._vendor;
        }

        @Override
        public String getBlobType() {
            return this._blobType;
        }

        @Override
        public String getVarBinaryType() {
            return this._varBinaryType;
        }

        @Override
        public boolean isUseBytesMethodsForBlob() {
            return this._useBytesMethodsForBlob;
        }

        @Override
        public String getBigintType() {
            return this._bigintType;
        }

        @Override
        public boolean isKnownVendor() {
            return this._isKnownVendor;
        }

        @Override
        public boolean isOverridden() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            HashMap<String, JDBCDetails> map = new HashMap<String, JDBCDetails>();
            try {
                map.put(ORACLE.getVendor(), ORACLE);
                map.put(SYBASE.getVendor(), SYBASE);
                map.put(POSTGRES.getVendor(), POSTGRES);
                map.put(DERBY.getVendor(), DERBY);
                map.put(FALLBACK.getVendor(), FALLBACK);
            }
            finally {
                VENDOR_DETAILS = Collections.unmodifiableMap(map);
            }
        }
    }
}

