/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.io.File;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.plugin.JDBCConnectionProviderFactory;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;
import org.apache.qpid.server.store.jdbc.DefaultConnectionProviderFactory;
import org.apache.qpid.server.store.jdbc.GenericAbstractJDBCMessageStore;
import org.apache.qpid.server.store.jdbc.JDBCDetails;
import org.apache.qpid.server.store.jdbc.JDBCSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJDBCMessageStore
extends GenericAbstractJDBCMessageStore {
    private static final Logger _logger = LoggerFactory.getLogger(GenericJDBCMessageStore.class);
    protected String _connectionURL;
    private ConnectionProvider _connectionProvider;
    private String _blobType;
    private String _varBinaryType;
    private String _bigIntType;
    private boolean _useBytesMethodsForBlob;

    @Override
    protected void doOpen(ConfiguredObject<?> parent) throws StoreException {
        JDBCSettings settings = (JDBCSettings)parent;
        this._connectionURL = settings.getConnectionUrl();
        JDBCDetails details = JDBCDetails.getDetailsForJdbcUrl(this._connectionURL, parent);
        if (!details.isKnownVendor() && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Do not recognize vendor from connection URL: " + this._connectionURL + " Using fallback settings " + details);
        }
        if (details.isOverridden() && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("One or more JDBC details were overridden from context.  Using settings : " + details);
        }
        this._blobType = details.getBlobType();
        this._varBinaryType = details.getVarBinaryType();
        this._useBytesMethodsForBlob = details.isUseBytesMethodsForBlob();
        this._bigIntType = details.getBigintType();
        String connectionPoolType = settings.getConnectionPoolType() == null ? "NONE" : settings.getConnectionPoolType();
        JDBCConnectionProviderFactory connectionProviderFactory = JDBCConnectionProviderFactory.FACTORIES.get((String)connectionPoolType);
        if (connectionProviderFactory == null) {
            _logger.warn("Unknown connection pool type: " + connectionPoolType + ".  No connection pooling will be used");
            connectionProviderFactory = new DefaultConnectionProviderFactory();
        }
        try {
            HashMap<String, Object> providerAttributes = new HashMap<String, Object>();
            HashSet providerAttributeNames = new HashSet(connectionProviderFactory.getProviderAttributeNames());
            providerAttributeNames.retainAll(parent.getContextKeys(false));
            for (String attr : providerAttributeNames) {
                providerAttributes.put(attr, parent.getContextValue(String.class, attr));
            }
            this._connectionProvider = connectionProviderFactory.getConnectionProvider(this._connectionURL, settings.getUsername(), settings.getPassword(), providerAttributes);
        }
        catch (SQLException e) {
            throw new StoreException("Failed to create connection provider for connectionUrl: " + this._connectionURL + " and username: " + settings.getUsername());
        }
    }

    @Override
    protected String getTablePrefix(ConfiguredObject<?> parent) {
        JDBCSettings settings = (JDBCSettings)parent;
        return settings.getTableNamePrefix();
    }

    protected Connection getConnection() throws SQLException {
        return this._connectionProvider.getConnection();
    }

    @Override
    protected void doClose() {
        try {
            this._connectionProvider.close();
        }
        catch (SQLException e) {
            throw new StoreException("Unable to close connection provider ", (Throwable)e);
        }
    }

    protected Logger getLogger() {
        return _logger;
    }

    protected String getSqlBlobType() {
        return this._blobType;
    }

    protected String getSqlVarBinaryType(int size) {
        return String.format(this._varBinaryType, size);
    }

    protected byte[] getBlobAsBytes(ResultSet rs, int col) throws SQLException {
        if (this._useBytesMethodsForBlob) {
            return rs.getBytes(col);
        }
        Blob dataAsBlob = rs.getBlob(col);
        return dataAsBlob.getBytes(1L, (int)dataAsBlob.length());
    }

    public String getSqlBigIntType() {
        return this._bigIntType;
    }

    public String getStoreLocation() {
        return this._connectionURL;
    }

    public File getStoreLocationAsFile() {
        return null;
    }
}

