/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreProvider;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.jdbc.AbstractJDBCConfigurationStore;
import org.apache.qpid.server.store.jdbc.AbstractJDBCPreferenceStore;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;
import org.apache.qpid.server.store.jdbc.DefaultConnectionProviderFactory;
import org.apache.qpid.server.store.jdbc.GenericAbstractJDBCMessageStore;
import org.apache.qpid.server.store.jdbc.JDBCConnectionProviderFactory;
import org.apache.qpid.server.store.jdbc.JDBCDetails;
import org.apache.qpid.server.store.jdbc.JDBCSettings;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJDBCConfigurationStore
extends AbstractJDBCConfigurationStore
implements MessageStoreProvider {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericJDBCConfigurationStore.class);
    private final MessageStore _providedMessageStore = new ProvidedMessageStore();
    private final PreferenceStore _providedPreferenceStore = new ProvidedPreferenceStore();
    private String _connectionURL;
    private ConnectionProvider _connectionProvider;
    private String _blobType;
    private String _varBinaryType;
    private String _bigIntType;
    private boolean _useBytesMethodsForBlob;
    private ConfiguredObject<?> _parent;
    private final Class<? extends ConfiguredObject> _rootClass;

    public GenericJDBCConfigurationStore(Class<? extends ConfiguredObject> rootClass) {
        this._rootClass = rootClass;
    }

    public void init(ConfiguredObject<?> parent) throws StoreException {
        String connectionPoolType;
        JDBCConnectionProviderFactory connectionProviderFactory;
        this.changeState(AbstractJDBCConfigurationStore.State.CLOSED, AbstractJDBCConfigurationStore.State.CONFIGURED);
        this._parent = parent;
        JDBCSettings settings = (JDBCSettings)parent;
        super.setTableNamePrefix(settings.getTableNamePrefix());
        this._connectionURL = settings.getConnectionUrl();
        JDBCDetails details = JDBCDetails.getDetailsForJdbcUrl(this._connectionURL, parent);
        if (!details.isKnownVendor() && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Do not recognize vendor from connection URL: " + this._connectionURL + " Using fallback settings " + details);
        }
        if (details.isOverridden() && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("One or more JDBC details were overridden from context.  Using settings : " + details);
        }
        if ((connectionProviderFactory = JDBCConnectionProviderFactory.FACTORIES.get(connectionPoolType = settings.getConnectionPoolType() == null ? "NONE" : settings.getConnectionPoolType())) == null) {
            LOGGER.warn("Unknown connection pool type: " + connectionPoolType + ".  no connection pooling will be used");
            connectionProviderFactory = new DefaultConnectionProviderFactory();
        }
        try {
            HashMap<String, String> providerAttributes = new HashMap<String, String>();
            HashSet<String> providerAttributeNames = new HashSet<String>(connectionProviderFactory.getProviderAttributeNames());
            providerAttributeNames.retainAll(parent.getContextKeys(false));
            for (String attr : providerAttributeNames) {
                providerAttributes.put(attr, (String)parent.getContextValue(String.class, attr));
            }
            this._connectionProvider = connectionProviderFactory.getConnectionProvider(this._connectionURL, settings.getUsername(), settings.getPassword(), providerAttributes);
        }
        catch (SQLException e) {
            throw new StoreException(String.format("Failed to create connection provider for connectionUrl: '%s' and username: '%s'", this._connectionURL, settings.getUsername()), (Throwable)e);
        }
        this._blobType = details.getBlobType();
        this._varBinaryType = details.getVarBinaryType();
        this._useBytesMethodsForBlob = details.isUseBytesMethodsForBlob();
        this._bigIntType = details.getBigintType();
        this.createOrOpenConfigurationStoreDatabase();
    }

    public void upgradeStoreStructure() throws StoreException {
        this.upgradeIfNecessary(this._parent);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._connectionProvider.getConnection();
    }

    public void closeConfigurationStore() throws StoreException {
        try {
            this._connectionProvider.close();
        }
        catch (SQLException e) {
            throw new StoreException("Unable to close connection provider ", (Throwable)e);
        }
        this.setState(AbstractJDBCConfigurationStore.State.CLOSED);
    }

    @Override
    protected String getSqlBlobType() {
        return this._blobType;
    }

    @Override
    protected String getSqlVarBinaryType(int size) {
        return String.format(this._varBinaryType, size);
    }

    @Override
    public String getSqlBigIntType() {
        return this._bigIntType;
    }

    @Override
    protected String getBlobAsString(ResultSet rs, int col) throws SQLException {
        if (this._useBytesMethodsForBlob) {
            byte[] bytes = rs.getBytes(col);
            return new String(bytes, UTF8_CHARSET);
        }
        Blob blob = rs.getBlob(col);
        if (blob == null) {
            return null;
        }
        byte[] bytes = blob.getBytes(1L, (int)blob.length());
        return new String(bytes, UTF8_CHARSET);
    }

    protected InputStream getBlobAsInputStream(ResultSet rs, int col) throws SQLException {
        if (this._useBytesMethodsForBlob) {
            return new ByteArrayInputStream(rs.getBytes(col));
        }
        Blob dataAsBlob = rs.getBlob(col);
        return dataAsBlob.getBinaryStream();
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public MessageStore getMessageStore() {
        return this._providedMessageStore;
    }

    public PreferenceStore getPreferenceStore() {
        return this._providedPreferenceStore;
    }

    private class ProvidedPreferenceStore
    extends AbstractJDBCPreferenceStore {
        private final Logger LOGGER = LoggerFactory.getLogger(ProvidedPreferenceStore.class);

        private ProvidedPreferenceStore() {
        }

        @Override
        protected Logger getLogger() {
            return this.LOGGER;
        }

        @Override
        protected Connection getConnection() throws SQLException {
            return GenericJDBCConfigurationStore.this.getConnection();
        }

        @Override
        protected String getSqlBlobType() {
            return GenericJDBCConfigurationStore.this.getSqlBlobType();
        }

        @Override
        protected String getBlobAsString(ResultSet rs, int col) throws SQLException {
            return GenericJDBCConfigurationStore.this.getBlobAsString(rs, col);
        }

        @Override
        protected void doDelete() {
            try {
                this.dropTables(GenericJDBCConfigurationStore.this.getConnection());
            }
            catch (SQLException e) {
                this.getLogger().warn("Could not drop preference database tables on deletion", (Throwable)e);
            }
        }

        @Override
        public void doClose() {
        }
    }

    private class ProvidedMessageStore
    extends GenericAbstractJDBCMessageStore {
        private ProvidedMessageStore() {
        }

        @Override
        protected String getTablePrefix(ConfiguredObject<?> parent) {
            return ((JDBCSettings)GenericJDBCConfigurationStore.this._parent).getTableNamePrefix();
        }

        @Override
        protected void doOpen(ConfiguredObject<?> parent) {
        }

        @Override
        public Connection getConnection() throws SQLException {
            return GenericJDBCConfigurationStore.this.getConnection();
        }

        @Override
        protected void doClose() {
        }

        public String getStoreLocation() {
            return GenericJDBCConfigurationStore.this._connectionURL;
        }

        public File getStoreLocationAsFile() {
            return null;
        }

        @Override
        protected Logger getLogger() {
            return GenericJDBCConfigurationStore.this.getLogger();
        }

        @Override
        protected String getSqlBlobType() {
            return GenericJDBCConfigurationStore.this.getSqlBlobType();
        }

        @Override
        protected String getSqlVarBinaryType(int size) {
            return GenericJDBCConfigurationStore.this.getSqlVarBinaryType(size);
        }

        @Override
        protected String getSqlBigIntType() {
            return GenericJDBCConfigurationStore.this.getSqlBigIntType();
        }

        @Override
        protected InputStream getBlobAsInputStream(ResultSet rs, int col) throws SQLException {
            return GenericJDBCConfigurationStore.this.getBlobAsInputStream(rs, col);
        }
    }
}

