/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.Duration;
import java.util.HashSet;
import java.util.Map;
import org.apache.qpid.server.logging.logback.AbstractBrokerLogger;
import org.apache.qpid.server.logging.logback.BrokerLogbackSocketLogger;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.slf4j.MDC;

public class BrokerLogbackSocketLoggerImpl
extends AbstractBrokerLogger<BrokerLogbackSocketLoggerImpl>
implements BrokerLogbackSocketLogger<BrokerLogbackSocketLoggerImpl> {
    @ManagedAttributeField
    private String _remoteHost;
    @ManagedAttributeField
    private long _reconnectionDelay;
    @ManagedAttributeField
    private int _port;
    @ManagedAttributeField
    private boolean _includeCallerData;
    @ManagedAttributeField
    private Map<String, String> _mappedDiagnosticContext;

    @ManagedObjectFactoryConstructor
    protected BrokerLogbackSocketLoggerImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    public String getRemoteHost() {
        return this._remoteHost;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public long getReconnectionDelay() {
        return this._reconnectionDelay;
    }

    @Override
    public boolean getIncludeCallerData() {
        return this._includeCallerData;
    }

    @Override
    public Map<String, String> getMappedDiagnosticContext() {
        return this._mappedDiagnosticContext;
    }

    @Override
    protected Appender<ILoggingEvent> createAppenderInstance(Context loggerContext) {
        SocketAppender socketAppender = new SocketAppender(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void append(ILoggingEvent event) {
                HashSet keys = new HashSet();
                try {
                    for (Map.Entry entry : BrokerLogbackSocketLoggerImpl.this._mappedDiagnosticContext.entrySet()) {
                        MDC.put((String)((String)entry.getKey()), (String)((String)entry.getValue()));
                        keys.add(entry.getKey());
                    }
                    event.prepareForDeferredProcessing();
                    super.append((Object)event);
                }
                finally {
                    for (String key : keys) {
                        MDC.remove((String)key);
                    }
                }
            }
        };
        socketAppender.setPort(this._port);
        socketAppender.setRemoteHost(this._remoteHost);
        socketAppender.setIncludeCallerData(this._includeCallerData);
        socketAppender.setReconnectionDelay(Duration.buildByMilliseconds((double)this._reconnectionDelay));
        return socketAppender;
    }
}

