/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.logging.logback.LogBackLogInclusionRule;

public class CompositeFilter
extends Filter<ILoggingEvent> {
    private List<Filter<ILoggingEvent>> _filterList = new CopyOnWriteArrayList<Filter<ILoggingEvent>>();
    private final AtomicLong _warnCount = new AtomicLong();
    private final AtomicLong _errorCount = new AtomicLong();

    public void addLogInclusionRule(LogBackLogInclusionRule logInclusionRule) {
        Filter<ILoggingEvent> f = logInclusionRule.asFilter();
        f.setName(logInclusionRule.getName());
        this._filterList.add(f);
    }

    public void removeLogInclusionRule(LogBackLogInclusionRule logInclusionRule) {
        for (Filter<ILoggingEvent> f : this._filterList) {
            if (!f.getName().equals(logInclusionRule.getName())) continue;
            this._filterList.remove(f);
            break;
        }
    }

    public FilterReply decide(ILoggingEvent event) {
        Filter<ILoggingEvent> filter;
        FilterReply reply = FilterReply.DENY;
        Iterator<Filter<ILoggingEvent>> i$ = this._filterList.iterator();
        while (i$.hasNext() && (reply = (filter = i$.next()).decide((Object)event)) != FilterReply.DENY && reply != FilterReply.ACCEPT) {
        }
        if (reply == FilterReply.ACCEPT) {
            switch (event.getLevel().toInt()) {
                case 30000: {
                    this._warnCount.incrementAndGet();
                    break;
                }
                case 40000: {
                    this._errorCount.incrementAndGet();
                    break;
                }
            }
            return FilterReply.ACCEPT;
        }
        return FilterReply.DENY;
    }

    public long getErrorCount() {
        return this._errorCount.get();
    }

    public long getWarnCount() {
        return this._warnCount.get();
    }
}

