/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.amqp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.management.amqp.ManagementNode;
import org.apache.qpid.server.management.amqp.ManagementResponse;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.util.StateChangeListener;

class ManagementNodeConsumer
implements ConsumerImpl {
    private final long _id = ConsumerImpl.CONSUMER_NUMBER_GENERATOR.getAndIncrement();
    private final ManagementNode _managementNode;
    private final List<ManagementResponse> _queue = Collections.synchronizedList(new ArrayList());
    private final ConsumerTarget _target;
    private final Lock _stateChangeLock = new ReentrantLock();
    private final String _name;
    private final StateChangeListener<ConsumerTarget, ConsumerTarget.State> _targetChangeListener = new TargetChangeListener();

    public ManagementNodeConsumer(String consumerName, ManagementNode managementNode, ConsumerTarget target) {
        this._name = consumerName;
        this._managementNode = managementNode;
        this._target = target;
        target.setStateListener(this._targetChangeListener);
    }

    public void externalStateChange() {
    }

    public long getBytesOut() {
        return 0L;
    }

    public long getMessagesOut() {
        return 0L;
    }

    public long getUnacknowledgedBytes() {
        return 0L;
    }

    public long getUnacknowledgedMessages() {
        return 0L;
    }

    public AMQSessionModel getSessionModel() {
        return this._target.getSessionModel();
    }

    public MessageSource getMessageSource() {
        return this._managementNode;
    }

    public long getConsumerNumber() {
        return this._id;
    }

    public boolean isSuspended() {
        return false;
    }

    public boolean isClosed() {
        return false;
    }

    public boolean acquires() {
        return true;
    }

    public boolean seesRequeues() {
        return false;
    }

    public void close() {
    }

    public boolean trySendLock() {
        return this._stateChangeLock.tryLock();
    }

    public void getSendLock() {
        this._stateChangeLock.lock();
    }

    public void releaseSendLock() {
        this._stateChangeLock.unlock();
    }

    public boolean isActive() {
        return false;
    }

    public String getName() {
        return this._name;
    }

    public void flush() {
    }

    ManagementNode getManagementNode() {
        return this._managementNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(InternalMessage response) {
        this.getSendLock();
        try {
            ManagementResponse responseEntry = new ManagementResponse(this, response);
            if (this._queue.isEmpty() && this._target.allocateCredit((ServerMessage)response)) {
                this._target.send((MessageInstance)responseEntry, false);
            } else {
                this._queue.add(responseEntry);
            }
        }
        finally {
            this.releaseSendLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverMessages() {
        this.getSendLock();
        try {
            while (!this._queue.isEmpty()) {
                ManagementResponse managementResponse = this._queue.get(0);
                if (!this._target.isSuspended() && this._target.allocateCredit(managementResponse.getMessage())) {
                    this._queue.remove(0);
                    this._target.send((MessageInstance)managementResponse, false);
                    continue;
                }
                break;
            }
        }
        finally {
            this.releaseSendLock();
        }
    }

    private class TargetChangeListener
    implements StateChangeListener<ConsumerTarget, ConsumerTarget.State> {
        private TargetChangeListener() {
        }

        public void stateChanged(ConsumerTarget object, ConsumerTarget.State oldState, ConsumerTarget.State newState) {
            if (newState == ConsumerTarget.State.ACTIVE) {
                ManagementNodeConsumer.this.deliverMessages();
            }
        }
    }
}

