/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.amqp;

import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.management.amqp.ManagementNodeConsumer;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.StateChangeListener;

class ManagementResponse
implements MessageInstance {
    private final ManagementNodeConsumer _consumer;
    private int _deliveryCount;
    private boolean _isRedelivered;
    private boolean _isDelivered;
    private boolean _isDeleted;
    private InternalMessage _message;

    ManagementResponse(ManagementNodeConsumer consumer, InternalMessage message) {
        this._consumer = consumer;
        this._message = message;
    }

    public int getDeliveryCount() {
        return 0;
    }

    public void incrementDeliveryCount() {
        ++this._deliveryCount;
    }

    public void decrementDeliveryCount() {
        --this._deliveryCount;
    }

    public void addStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.State> listener) {
    }

    public boolean removeStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.State> listener) {
        return false;
    }

    public boolean acquiredByConsumer() {
        return !this.isDeleted();
    }

    public ConsumerImpl getAcquiringConsumer() {
        return this._consumer;
    }

    public MessageEnqueueRecord getEnqueueRecord() {
        return null;
    }

    public boolean isAcquiredBy(ConsumerImpl consumer) {
        return consumer == this._consumer && !this.isDeleted();
    }

    public boolean removeAcquisitionFromConsumer(ConsumerImpl consumer) {
        return consumer == this._consumer;
    }

    public void setRedelivered() {
        this._isRedelivered = true;
    }

    public boolean isRedelivered() {
        return this._isRedelivered;
    }

    public ManagementNodeConsumer getDeliveredConsumer() {
        return this.isDeleted() ? null : this._consumer;
    }

    public void reject() {
        this.delete();
    }

    public boolean isRejectedBy(ConsumerImpl consumer) {
        return false;
    }

    public boolean getDeliveredToConsumer() {
        return this._isDelivered;
    }

    public boolean expired() {
        return false;
    }

    public boolean acquire(ConsumerImpl sub) {
        return false;
    }

    public boolean lockAcquisition() {
        return false;
    }

    public boolean unlockAcquisition() {
        return false;
    }

    public int getMaximumDeliveryCount() {
        return 0;
    }

    public int routeToAlternate(Action<? super MessageInstance> action, ServerTransaction txn) {
        return 0;
    }

    public Filterable asFilterable() {
        return null;
    }

    public boolean isAvailable() {
        return false;
    }

    public boolean acquire() {
        return false;
    }

    public boolean isAcquired() {
        return !this.isDeleted();
    }

    public void release() {
        this.delete();
    }

    public boolean resend() {
        return false;
    }

    public void delete() {
        this._isDeleted = true;
    }

    public boolean isDeleted() {
        return this._isDeleted;
    }

    public ServerMessage getMessage() {
        return this._message;
    }

    public InstanceProperties getInstanceProperties() {
        return InstanceProperties.EMPTY;
    }

    public TransactionLogResource getOwningResource() {
        return this._consumer.getManagementNode();
    }
}

