/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.amqp;

import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.management.amqp.ManagedEntityType;
import org.apache.qpid.server.management.amqp.ManagementNodeConsumer;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageNode;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.SystemNodeCreator;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.StateChangeListener;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;

class ManagementNode
implements MessageSource,
MessageDestination {
    public static final String NAME_ATTRIBUTE = "name";
    public static final String IDENTITY_ATTRIBUTE = "identity";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String OPERATION_HEADER = "operation";
    public static final String SELF_NODE_NAME = "self";
    public static final String MANAGEMENT_TYPE = "org.amqp.management";
    public static final String GET_TYPES = "GET-TYPES";
    public static final String GET_ATTRIBUTES = "GET-ATTRIBUTES";
    public static final String GET_OPERATIONS = "GET-OPERATIONS";
    public static final String QUERY = "QUERY";
    public static final String ENTITY_TYPE_HEADER = "entityType";
    public static final String STATUS_CODE_HEADER = "statusCode";
    public static final int STATUS_CODE_OK = 200;
    public static final String ATTRIBUTES_HEADER = "attributes";
    public static final String OFFSET_HEADER = "offset";
    public static final String COUNT_HEADER = "count";
    public static final String MANAGEMENT_NODE_NAME = "$management";
    public static final String CREATE_OPERATION = "CREATE";
    public static final String READ_OPERATION = "READ";
    public static final String UPDATE_OPERATION = "UPDATE";
    public static final String DELETE_OPERATION = "DELETE";
    public static final String STATUS_DESCRIPTION_HEADER = "statusDescription";
    public static final int NOT_FOUND_STATUS_CODE = 404;
    public static final int NOT_IMPLEMENTED_STATUS_CODE = 501;
    public static final int STATUS_CODE_NO_CONTENT = 204;
    public static final int STATUS_CODE_FORBIDDEN = 403;
    public static final int STATUS_CODE_BAD_REQUEST = 400;
    public static final int STATUS_CODE_INTERNAL_ERROR = 500;
    public static final String ATTRIBUTE_NAMES = "attributeNames";
    public static final String RESULTS = "results";
    private final VirtualHostImpl _virtualHost;
    private final UUID _id;
    private final SystemNodeCreator.SystemNodeRegistry _registry;
    private final ConfiguredObject<?> _managedObject;
    private Map<String, ManagementNodeConsumer> _consumers = new ConcurrentHashMap<String, ManagementNodeConsumer>();
    private Map<String, ManagedEntityType> _entityTypes = Collections.synchronizedMap(new LinkedHashMap());
    private Map<ManagedEntityType, Map<String, ConfiguredObject>> _entities = Collections.synchronizedMap(new LinkedHashMap());

    public ManagementNode(SystemNodeCreator.SystemNodeRegistry registry, ConfiguredObject<?> configuredObject) {
        this._virtualHost = registry.getVirtualHost();
        this._registry = registry;
        String name = configuredObject.getId() + MANAGEMENT_NODE_NAME;
        this._id = UUID.nameUUIDFromBytes(name.getBytes(Charset.defaultCharset()));
        this._managedObject = configuredObject;
        configuredObject.addChangeListener((ConfigurationChangeListener)new ModelObjectListener());
    }

    private Class getManagementClass(Class objectClass) {
        if (objectClass.getAnnotation(ManagedObject.class) != null) {
            return objectClass;
        }
        List<Class> allClasses = Collections.singletonList(objectClass);
        ArrayList<Class> testedClasses = new ArrayList<Class>();
        do {
            testedClasses.addAll(allClasses);
            allClasses = new ArrayList<Class>();
            for (Class c : testedClasses) {
                for (Class<?> i : c.getInterfaces()) {
                    if (allClasses.contains(i)) continue;
                    allClasses.add(i);
                }
                if (c.getSuperclass() == null || allClasses.contains(c.getSuperclass())) continue;
                allClasses.add(c.getSuperclass());
            }
            allClasses.removeAll(testedClasses);
            for (Class c : allClasses) {
                if (c.getAnnotation(ManagedObject.class) == null) continue;
                return c;
            }
        } while (!allClasses.isEmpty());
        return null;
    }

    private boolean populateTypeMetaData(Class<? extends ConfiguredObject> objectClass, boolean allowCreate) {
        Class clazz = this.getManagementClass(objectClass);
        if (clazz != null) {
            ManagedObject annotation = clazz.getAnnotation(ManagedObject.class);
            this.populateTypeMetaData(clazz, annotation);
            return true;
        }
        return false;
    }

    private ManagedEntityType populateTypeMetaData(Class clazz, ManagedObject entityType) {
        ManagedEntityType managedEntityType = this._entityTypes.get(clazz.getName());
        if (managedEntityType == null) {
            ArrayList<String> opsList = new ArrayList<String>(Arrays.asList(entityType.operations()));
            if (entityType.creatable()) {
                boolean isCreatableChild = false;
                Collection parentTypes = this._managedObject.getModel().getParentTypes(clazz);
                for (Class clazz2 : parentTypes) {
                    isCreatableChild = clazz2.isAssignableFrom(this._managedObject.getClass());
                    if (!isCreatableChild) continue;
                    opsList.add(CREATE_OPERATION);
                    break;
                }
            }
            opsList.addAll(Arrays.asList(READ_OPERATION, UPDATE_OPERATION, DELETE_OPERATION));
            HashSet<ManagedEntityType> parentSet = new HashSet<ManagedEntityType>();
            ArrayList allClasses = new ArrayList(Arrays.asList(clazz.getInterfaces()));
            if (clazz.getSuperclass() != null) {
                allClasses.add(clazz.getSuperclass());
            }
            for (Class clazz3 : allClasses) {
                if (clazz3.getAnnotation(ManagedObject.class) == null) continue;
                ManagedEntityType parentType = this.populateTypeMetaData(clazz3, clazz3.getAnnotation(ManagedObject.class));
                parentSet.add(parentType);
                parentSet.addAll(Arrays.asList(parentType.getParents()));
            }
            managedEntityType = new ManagedEntityType(clazz.getName(), parentSet.toArray(new ManagedEntityType[parentSet.size()]), this._managedObject.getModel().getTypeRegistry().getAttributeNames(clazz).toArray(new String[0]), opsList.toArray(new String[opsList.size()]));
            this._entityTypes.put(clazz.getName(), managedEntityType);
            this._entities.put(managedEntityType, Collections.synchronizedMap(new LinkedHashMap()));
            if (ConfiguredObject.class.isAssignableFrom(clazz)) {
                Collection childTypes = this._managedObject.getModel().getChildTypes(clazz);
                for (Class childClass : childTypes) {
                    this.populateTypeMetaData((Class<? extends ConfiguredObject>)childClass, true);
                }
            }
        }
        return managedEntityType;
    }

    public <M extends ServerMessage<? extends StorableMessageMetaData>> int send(M message, String routingAddress, final InstanceProperties instanceProperties, ServerTransaction txn, final Action<? super MessageInstance> postEnqueueAction) {
        MessageConverter converter = MessageConverterRegistry.getConverter(message.getClass(), InternalMessage.class);
        final InternalMessage msg = (InternalMessage)converter.convert(message, this._virtualHost);
        if (this.validateMessage((ServerMessage)msg)) {
            txn.addPostTransactionAction(new ServerTransaction.Action(){

                public void postCommit() {
                    ManagementNode.this.enqueue(msg, instanceProperties, (Action<? super MessageInstance>)postEnqueueAction);
                }

                public void onRollback() {
                }
            });
            return 1;
        }
        return 0;
    }

    private boolean validateMessage(ServerMessage message) {
        AMQMessageHeader header = message.getMessageHeader();
        return this.containsStringHeader(header, TYPE_ATTRIBUTE) && this.containsStringHeader(header, OPERATION_HEADER) && (this.containsStringHeader(header, NAME_ATTRIBUTE) || this.containsStringHeader(header, IDENTITY_ATTRIBUTE));
    }

    private boolean containsStringHeader(AMQMessageHeader header, String name) {
        return header.containsHeader(name) && header.getHeader(name) instanceof String;
    }

    synchronized void enqueue(InternalMessage message, InstanceProperties properties, Action<? super MessageInstance> postEnqueueAction) {
        ConfiguredObject entity;
        if (postEnqueueAction != null) {
            postEnqueueAction.performAction((Object)new ConsumedMessageInstance((ServerMessage)message, properties));
        }
        String name = (String)message.getMessageHeader().getHeader(NAME_ATTRIBUTE);
        String id = (String)message.getMessageHeader().getHeader(IDENTITY_ATTRIBUTE);
        String type = (String)message.getMessageHeader().getHeader(TYPE_ATTRIBUTE);
        String operation = (String)message.getMessageHeader().getHeader(OPERATION_HEADER);
        InternalMessage response = SELF_NODE_NAME.equals(name) && type.equals(MANAGEMENT_TYPE) ? this.performManagementOperation(message) : (CREATE_OPERATION.equals(operation) ? this.performCreateOperation(message, type) : ((entity = this.findSubject(name, id, type)) != null ? this.performOperation(message, entity) : (id != null ? this.createFailureResponse(message, 404, "No entity with id {0} of type {1} found", id, type) : this.createFailureResponse(message, 404, "No entity with name {0} of type {1} found", name, type))));
        ManagementNodeConsumer consumer = this._consumers.get(message.getMessageHeader().getReplyTo());
        response.setInitialRoutingAddress(message.getMessageHeader().getReplyTo());
        if (consumer != null) {
            consumer.send(response);
        } else {
            this._virtualHost.getDefaultDestination().send((ServerMessage)response, message.getMessageHeader().getReplyTo(), InstanceProperties.EMPTY, (ServerTransaction)new AutoCommitTransaction(this._virtualHost.getMessageStore()), null);
        }
    }

    private InternalMessage performCreateOperation(InternalMessage message, String type) {
        InternalMessage response;
        ManagedEntityType entityType = this._entityTypes.get(type);
        if (type != null) {
            if (Arrays.asList(entityType.getOperations()).contains(CREATE_OPERATION)) {
                Object messageBody = message.getMessageBody();
                if (messageBody instanceof Map) {
                    try {
                        Class<?> clazz = Class.forName(type);
                        try {
                            ConfiguredObject child = this._managedObject.createChild(clazz, (Map)messageBody, new ConfiguredObject[0]);
                            if (child == null) {
                                child = this._entities.get(entityType).get(message.getMessageHeader().getHeader(NAME_ATTRIBUTE));
                            }
                            response = this.performReadOperation(message, child);
                        }
                        catch (AccessControlException e) {
                            response = this.createFailureResponse(message, 403, e.getMessage(), new Object[0]);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        response = this.createFailureResponse(message, 500, "Unable to instantiate an instance of {0} ", type);
                    }
                } else {
                    response = this.createFailureResponse(message, 400, "The message body in the request was not of the correct type", new Object[0]);
                }
            } else {
                response = this.createFailureResponse(message, 403, "Cannot CREATE entities of type {0}", type);
            }
        } else {
            response = this.createFailureResponse(message, 404, "Unknown type {0}", type);
        }
        return response;
    }

    private InternalMessage performOperation(InternalMessage requestMessage, ConfiguredObject entity) {
        String operation = (String)requestMessage.getMessageHeader().getHeader(OPERATION_HEADER);
        if (READ_OPERATION.equals(operation)) {
            return this.performReadOperation(requestMessage, entity);
        }
        if (DELETE_OPERATION.equals(operation)) {
            return this.performDeleteOperation(requestMessage, entity);
        }
        if (UPDATE_OPERATION.equals(operation)) {
            return this.performUpdateOperation(requestMessage, entity);
        }
        return this.createFailureResponse(requestMessage, 501, "Unable to perform the {0} operation", operation);
    }

    private InternalMessage performReadOperation(InternalMessage requestMessage, ConfiguredObject entity) {
        InternalMessageHeader requestHeader = requestMessage.getMessageHeader();
        MutableMessageHeader responseHeader = new MutableMessageHeader();
        responseHeader.setCorrelationId(requestHeader.getCorrelationId() == null ? requestHeader.getMessageId() : requestHeader.getCorrelationId());
        responseHeader.setMessageId(UUID.randomUUID().toString());
        responseHeader.setHeader(NAME_ATTRIBUTE, entity.getName());
        responseHeader.setHeader(IDENTITY_ATTRIBUTE, entity.getId().toString());
        responseHeader.setHeader(STATUS_CODE_HEADER, 200);
        String type = this.getManagementClass(entity.getClass()).getName();
        responseHeader.setHeader(TYPE_ATTRIBUTE, type);
        LinkedHashMap<String, Object> responseBody = new LinkedHashMap<String, Object>();
        ManagedEntityType entityType = this._entityTypes.get(type);
        for (String attribute : entityType.getAttributes()) {
            responseBody.put(attribute, this.fixValue(entity.getAttribute(attribute)));
        }
        return InternalMessage.createMapMessage((MessageStore)this._virtualHost.getMessageStore(), (AMQMessageHeader)responseHeader, responseBody);
    }

    private InternalMessage performDeleteOperation(InternalMessage requestMessage, ConfiguredObject entity) {
        InternalMessageHeader requestHeader = requestMessage.getMessageHeader();
        MutableMessageHeader responseHeader = new MutableMessageHeader();
        responseHeader.setCorrelationId(requestHeader.getCorrelationId() == null ? requestHeader.getMessageId() : requestHeader.getCorrelationId());
        responseHeader.setMessageId(UUID.randomUUID().toString());
        responseHeader.setHeader(NAME_ATTRIBUTE, entity.getName());
        responseHeader.setHeader(IDENTITY_ATTRIBUTE, entity.getId().toString());
        String type = this.getManagementClass(entity.getClass()).getName();
        responseHeader.setHeader(TYPE_ATTRIBUTE, type);
        try {
            entity.delete();
            responseHeader.setHeader(STATUS_CODE_HEADER, 204);
        }
        catch (AccessControlException e) {
            responseHeader.setHeader(STATUS_CODE_HEADER, 403);
        }
        return InternalMessage.createMapMessage((MessageStore)this._virtualHost.getMessageStore(), (AMQMessageHeader)responseHeader, Collections.emptyMap());
    }

    private InternalMessage performUpdateOperation(InternalMessage requestMessage, ConfiguredObject entity) {
        InternalMessageHeader requestHeader = requestMessage.getMessageHeader();
        MutableMessageHeader responseHeader = new MutableMessageHeader();
        responseHeader.setCorrelationId(requestHeader.getCorrelationId() == null ? requestHeader.getMessageId() : requestHeader.getCorrelationId());
        responseHeader.setMessageId(UUID.randomUUID().toString());
        responseHeader.setHeader(NAME_ATTRIBUTE, entity.getName());
        responseHeader.setHeader(IDENTITY_ATTRIBUTE, entity.getId().toString());
        String type = this.getManagementClass(entity.getClass()).getName();
        responseHeader.setHeader(TYPE_ATTRIBUTE, type);
        Object messageBody = requestMessage.getMessageBody();
        if (messageBody instanceof Map) {
            try {
                entity.setAttributes((Map)messageBody);
                return this.performReadOperation(requestMessage, entity);
            }
            catch (AccessControlException e) {
                return this.createFailureResponse(requestMessage, 403, e.getMessage(), new Object[0]);
            }
        }
        return this.createFailureResponse(requestMessage, 400, "The message body in the request was not of the correct type", new Object[0]);
    }

    private ConfiguredObject findSubject(String name, String id, String type) {
        ManagedEntityType met = this._entityTypes.get(type);
        if (met == null) {
            return null;
        }
        ConfiguredObject subject = this.findSubject(name, id, met);
        if (subject == null) {
            ArrayList<ManagedEntityType> allTypes = new ArrayList<ManagedEntityType>(this._entityTypes.values());
            for (ManagedEntityType entityType : allTypes) {
                if (!Arrays.asList(entityType.getParents()).contains(met) || (subject = this.findSubject(name, id, entityType)) == null) continue;
                return subject;
            }
        }
        return subject;
    }

    private ConfiguredObject findSubject(String name, String id, ManagedEntityType entityType) {
        Map<String, ConfiguredObject> objects = this._entities.get(entityType);
        if (name != null) {
            ConfiguredObject subject = objects.get(name);
            if (subject != null) {
                return subject;
            }
        } else {
            ArrayList<ConfiguredObject> values = new ArrayList<ConfiguredObject>(objects.values());
            for (ConfiguredObject o : values) {
                if (!o.getId().toString().equals(id)) continue;
                return o;
            }
        }
        return null;
    }

    private InternalMessage createFailureResponse(InternalMessage requestMessage, int statusCode, String stateDescription, Object ... params) {
        InternalMessageHeader requestHeader = requestMessage.getMessageHeader();
        MutableMessageHeader responseHeader = new MutableMessageHeader();
        responseHeader.setCorrelationId(requestHeader.getCorrelationId() == null ? requestHeader.getMessageId() : requestHeader.getCorrelationId());
        responseHeader.setMessageId(UUID.randomUUID().toString());
        for (String header : requestHeader.getHeaderNames()) {
            responseHeader.setHeader(header, requestHeader.getHeader(header));
        }
        responseHeader.setHeader(STATUS_CODE_HEADER, statusCode);
        responseHeader.setHeader(STATUS_DESCRIPTION_HEADER, MessageFormat.format(stateDescription, params));
        return InternalMessage.createBytesMessage((MessageStore)this._virtualHost.getMessageStore(), (AMQMessageHeader)responseHeader, (byte[])new byte[0]);
    }

    private InternalMessage performManagementOperation(InternalMessage msg) {
        InternalMessageHeader requestHeader = msg.getMessageHeader();
        MutableMessageHeader responseHeader = new MutableMessageHeader();
        responseHeader.setCorrelationId(requestHeader.getCorrelationId() == null ? requestHeader.getMessageId() : requestHeader.getCorrelationId());
        responseHeader.setMessageId(UUID.randomUUID().toString());
        String operation = (String)requestHeader.getHeader(OPERATION_HEADER);
        InternalMessage responseMessage = GET_TYPES.equals(operation) ? this.performGetTypes(requestHeader, responseHeader) : (GET_ATTRIBUTES.equals(operation) ? this.performGetAttributes(requestHeader, responseHeader) : (GET_OPERATIONS.equals(operation) ? this.performGetOperations(requestHeader, responseHeader) : (QUERY.equals(operation) ? this.performQuery(requestHeader, msg.getMessageBody(), responseHeader) : InternalMessage.createBytesMessage((MessageStore)this._virtualHost.getMessageStore(), (AMQMessageHeader)requestHeader, (byte[])new byte[0]))));
        return responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalMessage performGetTypes(InternalMessageHeader requestHeader, MutableMessageHeader responseHeader) {
        LinkedHashMap<String, ManagedEntityType> entityMapCopy;
        ArrayList<String> restriction = requestHeader.containsHeader(ENTITY_TYPE_HEADER) ? new ArrayList<String>(Collections.singletonList((String)requestHeader.getHeader(ENTITY_TYPE_HEADER))) : null;
        responseHeader.setHeader(STATUS_CODE_HEADER, 200);
        LinkedHashMap responseMap = new LinkedHashMap();
        Map<String, ManagedEntityType> map = this._entityTypes;
        synchronized (map) {
            entityMapCopy = new LinkedHashMap<String, ManagedEntityType>(this._entityTypes);
        }
        for (ManagedEntityType type : entityMapCopy.values()) {
            if (restriction != null && !this.meetsIndirectRestriction(type, restriction)) continue;
            ManagedEntityType[] parents = type.getParents();
            ArrayList<String> parentNames = new ArrayList<String>();
            if (parents != null) {
                for (ManagedEntityType parent : parents) {
                    parentNames.add(parent.getName());
                }
            }
            responseMap.put(type.getName(), parentNames);
        }
        InternalMessage responseMessage = InternalMessage.createMapMessage((MessageStore)this._virtualHost.getMessageStore(), (AMQMessageHeader)responseHeader, responseMap);
        return responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalMessage performGetAttributes(InternalMessageHeader requestHeader, MutableMessageHeader responseHeader) {
        LinkedHashMap<String, ManagedEntityType> entityMapCopy;
        String restriction = requestHeader.containsHeader(ENTITY_TYPE_HEADER) ? (String)requestHeader.getHeader(ENTITY_TYPE_HEADER) : null;
        responseHeader.setHeader(STATUS_CODE_HEADER, 200);
        LinkedHashMap<String, List<String>> responseMap = new LinkedHashMap<String, List<String>>();
        Map<String, ManagedEntityType> map = this._entityTypes;
        synchronized (map) {
            entityMapCopy = new LinkedHashMap<String, ManagedEntityType>(this._entityTypes);
        }
        if (restriction == null) {
            for (ManagedEntityType type : entityMapCopy.values()) {
                responseMap.put(type.getName(), Arrays.asList(type.getAttributes()));
            }
        } else if (entityMapCopy.containsKey(restriction)) {
            responseMap.put(restriction, Arrays.asList(((ManagedEntityType)entityMapCopy.get(restriction)).getAttributes()));
        }
        InternalMessage responseMessage = InternalMessage.createMapMessage((MessageStore)this._virtualHost.getMessageStore(), (AMQMessageHeader)responseHeader, responseMap);
        return responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalMessage performGetOperations(InternalMessageHeader requestHeader, MutableMessageHeader responseHeader) {
        LinkedHashMap<String, ManagedEntityType> entityMapCopy;
        String restriction = requestHeader.containsHeader(ENTITY_TYPE_HEADER) ? (String)requestHeader.getHeader(ENTITY_TYPE_HEADER) : null;
        responseHeader.setHeader(STATUS_CODE_HEADER, 200);
        LinkedHashMap<String, List<String>> responseMap = new LinkedHashMap<String, List<String>>();
        Map<String, ManagedEntityType> map = this._entityTypes;
        synchronized (map) {
            entityMapCopy = new LinkedHashMap<String, ManagedEntityType>(this._entityTypes);
        }
        if (restriction == null) {
            for (ManagedEntityType type : entityMapCopy.values()) {
                responseMap.put(type.getName(), Arrays.asList(type.getOperations()));
            }
        } else if (entityMapCopy.containsKey(restriction)) {
            ManagedEntityType type = (ManagedEntityType)entityMapCopy.get(restriction);
            responseMap.put(type.getName(), Arrays.asList(type.getOperations()));
        }
        InternalMessage responseMessage = InternalMessage.createMapMessage((MessageStore)this._virtualHost.getMessageStore(), (AMQMessageHeader)responseHeader, responseMap);
        return responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalMessage performQuery(InternalMessageHeader requestHeader, Object messageBody, MutableMessageHeader responseHeader) {
        int offset;
        ArrayList attributes;
        ArrayList<String> restriction;
        if (requestHeader.containsHeader(ENTITY_TYPE_HEADER)) {
            restriction = new ArrayList<String>(Collections.singletonList((String)requestHeader.getHeader(ENTITY_TYPE_HEADER)));
            responseHeader.setHeader(ENTITY_TYPE_HEADER, restriction);
        } else {
            restriction = new ArrayList<String>(this._entityTypes.keySet());
        }
        if (messageBody instanceof Map && ((Map)messageBody).get(ATTRIBUTE_NAMES) instanceof List) {
            attributes = (ArrayList)((Map)messageBody).get(ATTRIBUTE_NAMES);
        } else {
            LinkedHashMap attributeSet = new LinkedHashMap();
            for (String entityType : restriction) {
                ManagedEntityType managedEntityType = this._entityTypes.get(entityType);
                if (managedEntityType == null) continue;
                for (String string : managedEntityType.getAttributes()) {
                    attributeSet.put(string, null);
                }
            }
            attributes = new ArrayList(attributeSet.keySet());
        }
        if (requestHeader.containsHeader(OFFSET_HEADER)) {
            offset = ((Number)requestHeader.getHeader(OFFSET_HEADER)).intValue();
            responseHeader.setHeader(OFFSET_HEADER, offset);
        } else {
            offset = 0;
        }
        int count = requestHeader.containsHeader(COUNT_HEADER) ? ((Number)requestHeader.getHeader(COUNT_HEADER)).intValue() : Integer.MAX_VALUE;
        responseHeader.setHeader(STATUS_CODE_HEADER, 200);
        ArrayList<List<Object>> responseList = new ArrayList<List<Object>>();
        int rowNo = 0;
        for (String string : restriction) {
            Map<String, ConfiguredObject> entityMap;
            ManagedEntityType entityType = this._entityTypes.get(string);
            if (entityType != null && (entityMap = this._entities.get(entityType)) != null) {
                ArrayList<ConfiguredObject> entities;
                Map<String, ConfiguredObject> map = entityMap;
                synchronized (map) {
                    entities = new ArrayList<ConfiguredObject>(entityMap.values());
                }
                for (ConfiguredObject entity : entities) {
                    if (rowNo++ >= offset) {
                        Object[] attrValue = new Object[attributes.size()];
                        int col = 0;
                        for (String attr : attributes) {
                            Object value = TYPE_ATTRIBUTE.equals(attr) ? entityType.getName() : this.fixValue(entity.getAttribute(attr));
                            attrValue[col++] = value;
                        }
                        responseList.add(Arrays.asList(attrValue));
                    }
                    if (responseList.size() != count + 1) continue;
                    break;
                }
            }
            if (responseList.size() != count) continue;
            break;
        }
        responseHeader.setHeader(COUNT_HEADER, responseList.size());
        HashMap<String, ArrayList<Object>> responseMap = new HashMap<String, ArrayList<Object>>();
        responseMap.put(ATTRIBUTE_NAMES, attributes);
        responseMap.put(RESULTS, responseList);
        InternalMessage responseMessage = InternalMessage.createMapMessage((MessageStore)this._virtualHost.getMessageStore(), (AMQMessageHeader)responseHeader, responseMap);
        return responseMessage;
    }

    private Object fixValue(Object value) {
        Object fixedValue;
        if (value instanceof Enum) {
            fixedValue = value.toString();
        } else if (value instanceof Map) {
            Map oldValue = (Map)value;
            LinkedHashMap<Object, Object> newValue = new LinkedHashMap<Object, Object>();
            for (Map.Entry entry : oldValue.entrySet()) {
                newValue.put(this.fixValue(entry.getKey()), this.fixValue(entry.getValue()));
            }
            fixedValue = newValue;
        } else if (value instanceof Collection) {
            Collection oldValue = (Collection)value;
            ArrayList<Object> newValue = new ArrayList<Object>(oldValue.size());
            for (Object o : oldValue) {
                newValue.add(this.fixValue(o));
            }
            fixedValue = newValue;
        } else {
            fixedValue = value != null && value.getClass().isArray() && !(value instanceof byte[]) ? this.fixValue(Arrays.asList((Object[])value)) : value;
        }
        return fixedValue;
    }

    private boolean meetsIndirectRestriction(ManagedEntityType type, List<String> restriction) {
        if (restriction.contains(type.getName())) {
            return true;
        }
        if (type.getParents() != null) {
            for (ManagedEntityType parent : type.getParents()) {
                if (!this.meetsIndirectRestriction(parent, restriction)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized ManagementNodeConsumer addConsumer(ConsumerTarget target, FilterManager filters, Class<? extends ServerMessage> messageClass, String consumerName, EnumSet<ConsumerImpl.Option> options) {
        ManagementNodeConsumer managementNodeConsumer = new ManagementNodeConsumer(consumerName, this, target);
        target.consumerAdded((ConsumerImpl)managementNodeConsumer);
        this._consumers.put(consumerName, managementNodeConsumer);
        return managementNodeConsumer;
    }

    public synchronized Collection<ManagementNodeConsumer> getConsumers() {
        return new ArrayList<ManagementNodeConsumer>(this._consumers.values());
    }

    public boolean verifySessionAccess(AMQSessionModel<?> session) {
        return true;
    }

    public String getName() {
        return MANAGEMENT_NODE_NAME;
    }

    public UUID getId() {
        return this._id;
    }

    public MessageDurability getMessageDurability() {
        return MessageDurability.NEVER;
    }

    private static class MutableMessageHeader
    implements AMQMessageHeader {
        private final LinkedHashMap<String, Object> _headers = new LinkedHashMap();
        private String _correlationId;
        private long _expiration;
        private String _userId;
        private String _appId;
        private String _messageId;
        private String _mimeType;
        private String _encoding;
        private byte _priority;
        private long _timestamp;
        private long _notValidBefore;
        private String _type;
        private String _replyTo;

        private MutableMessageHeader() {
        }

        public void setCorrelationId(String correlationId) {
            this._correlationId = correlationId;
        }

        public void setExpiration(long expiration) {
            this._expiration = expiration;
        }

        public void setUserId(String userId) {
            this._userId = userId;
        }

        public void setAppId(String appId) {
            this._appId = appId;
        }

        public void setMessageId(String messageId) {
            this._messageId = messageId;
        }

        public void setMimeType(String mimeType) {
            this._mimeType = mimeType;
        }

        public void setEncoding(String encoding) {
            this._encoding = encoding;
        }

        public void setPriority(byte priority) {
            this._priority = priority;
        }

        public void setTimestamp(long timestamp) {
            this._timestamp = timestamp;
        }

        public void setNotValidBefore(long notValidBefore) {
            this._notValidBefore = notValidBefore;
        }

        public void setType(String type) {
            this._type = type;
        }

        public void setReplyTo(String replyTo) {
            this._replyTo = replyTo;
        }

        public String getCorrelationId() {
            return this._correlationId;
        }

        public long getExpiration() {
            return this._expiration;
        }

        public String getUserId() {
            return this._userId;
        }

        public String getAppId() {
            return this._appId;
        }

        public String getMessageId() {
            return this._messageId;
        }

        public String getMimeType() {
            return this._mimeType;
        }

        public String getEncoding() {
            return this._encoding;
        }

        public byte getPriority() {
            return this._priority;
        }

        public long getTimestamp() {
            return this._timestamp;
        }

        public long getNotValidBefore() {
            return this._notValidBefore;
        }

        public String getType() {
            return this._type;
        }

        public String getReplyTo() {
            return this._replyTo;
        }

        public Object getHeader(String name) {
            return this._headers.get(name);
        }

        public boolean containsHeaders(Set<String> names) {
            return this._headers.keySet().containsAll(names);
        }

        public boolean containsHeader(String name) {
            return this._headers.containsKey(name);
        }

        public Collection<String> getHeaderNames() {
            return Collections.unmodifiableCollection(this._headers.keySet());
        }

        public void setHeader(String header, Object value) {
            this._headers.put(header, value);
        }
    }

    private class ModelObjectListener
    implements ConfigurationChangeListener {
        private ModelObjectListener() {
        }

        public void stateChanged(ConfiguredObject object, State oldState, State newState) {
            if (newState == State.DELETED) {
                ManagementNode.this._registry.removeSystemNode((MessageNode)ManagementNode.this);
            } else if (newState == State.ACTIVE && object instanceof VirtualHost) {
                ManagementNode.this.populateTypeMetaData((Class<? extends ConfiguredObject>)object.getClass(), false);
                Class managementClass = ManagementNode.this.getManagementClass(ManagementNode.this._managedObject.getClass());
                ((Map)ManagementNode.this._entities.get(ManagementNode.this._entityTypes.get(managementClass.getName()))).put(ManagementNode.this._managedObject.getName(), ManagementNode.this._managedObject);
                Collection childClasses = object.getModel().getChildTypes(managementClass);
                for (Class childClass : childClasses) {
                    if (ManagementNode.this.getManagementClass(childClass) == null) continue;
                    for (ConfiguredObject child : ManagementNode.this._managedObject.getChildren(childClass)) {
                        ((Map)ManagementNode.this._entities.get(ManagementNode.this._entityTypes.get(ManagementNode.this.getManagementClass(childClass).getName()))).put(child.getName(), child);
                    }
                }
            }
        }

        public void childAdded(ConfiguredObject object, ConfiguredObject child) {
            Class managementClass = ManagementNode.this.getManagementClass(child.getClass());
            ManagedEntityType entityType = (ManagedEntityType)ManagementNode.this._entityTypes.get(managementClass.getName());
            if (entityType != null) {
                ((Map)ManagementNode.this._entities.get(entityType)).put(child.getName(), child);
            }
        }

        public void childRemoved(ConfiguredObject object, ConfiguredObject child) {
            ManagedEntityType entityType = (ManagedEntityType)ManagementNode.this._entityTypes.get(ManagementNode.this.getManagementClass(child.getClass()).getName());
            if (entityType != null) {
                ((Map)ManagementNode.this._entities.get(entityType)).remove(child.getName());
            }
        }

        public void attributeSet(ConfiguredObject object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
        }

        public void bulkChangeStart(ConfiguredObject<?> object) {
        }

        public void bulkChangeEnd(ConfiguredObject<?> object) {
        }
    }

    private class ConsumedMessageInstance
    implements MessageInstance {
        private final ServerMessage _message;
        private final InstanceProperties _properties;

        public ConsumedMessageInstance(ServerMessage message, InstanceProperties properties) {
            this._message = message;
            this._properties = properties;
        }

        public int getDeliveryCount() {
            return 0;
        }

        public void incrementDeliveryCount() {
        }

        public void decrementDeliveryCount() {
        }

        public void addStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.State> listener) {
        }

        public boolean removeStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.State> listener) {
            return false;
        }

        public boolean acquiredByConsumer() {
            return false;
        }

        public ConsumerImpl getAcquiringConsumer() {
            return null;
        }

        public MessageEnqueueRecord getEnqueueRecord() {
            return null;
        }

        public boolean isAcquiredBy(ConsumerImpl consumer) {
            return false;
        }

        public boolean removeAcquisitionFromConsumer(ConsumerImpl consumer) {
            return false;
        }

        public void setRedelivered() {
        }

        public boolean isRedelivered() {
            return false;
        }

        public ConsumerImpl getDeliveredConsumer() {
            return null;
        }

        public void reject() {
        }

        public boolean isRejectedBy(ConsumerImpl consumer) {
            return false;
        }

        public boolean getDeliveredToConsumer() {
            return true;
        }

        public boolean expired() {
            return false;
        }

        public boolean acquire(ConsumerImpl sub) {
            return false;
        }

        public boolean lockAcquisition(ConsumerImpl consumer) {
            return false;
        }

        public boolean unlockAcquisition() {
            return false;
        }

        public int getMaximumDeliveryCount() {
            return 0;
        }

        public int routeToAlternate(Action<? super MessageInstance> action, ServerTransaction txn) {
            return 0;
        }

        public Filterable asFilterable() {
            return null;
        }

        public boolean isAvailable() {
            return false;
        }

        public boolean acquire() {
            return false;
        }

        public boolean isAcquired() {
            return false;
        }

        public void release() {
        }

        public void release(ConsumerImpl release) {
        }

        public boolean resend() {
            return false;
        }

        public void delete() {
        }

        public boolean isDeleted() {
            return false;
        }

        public ServerMessage getMessage() {
            return this._message;
        }

        public InstanceProperties getInstanceProperties() {
            return this._properties;
        }

        public TransactionLogResource getOwningResource() {
            return ManagementNode.this;
        }
    }
}

