/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.amqp;

import java.security.AccessControlException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.qpid.server.management.amqp.ManagementAddressSpacePrincipal;
import org.apache.qpid.server.management.amqp.ManagementNode;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.plugin.SystemAddressSpaceCreator;
import org.apache.qpid.server.protocol.LinkModel;
import org.apache.qpid.server.protocol.LinkRegistry;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.store.MemoryMessageStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.txn.DtxNotSupportedException;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.virtualhost.VirtualHostPropertiesNode;

public class ManagementAddressSpace
implements NamedAddressSpace {
    public static final String MANAGEMENT_ADDRESS_SPACE_NAME = "$management";
    private static final String MANAGEMENT_NODE_NAME = "$management";
    private final String _name;
    private final SystemAddressSpaceCreator.AddressSpaceRegistry _addressSpaceRegistry;
    private final ManagementNode _managementNode;
    private final VirtualHostPropertiesNode _propertiesNode;
    private final MessageStore _messageStore;
    private final MessageDestination _defaultDestination = new DefaultDestination();
    private final List<AMQPConnection<?>> _connections = new CopyOnWriteArrayList();
    private final LinkRegistry _linkRegistry = new NonDurableLinkRegistry();
    private final Broker<?> _broker;
    private final Principal _principal;

    public ManagementAddressSpace(SystemAddressSpaceCreator.AddressSpaceRegistry addressSpaceRegistry) {
        this("$management", addressSpaceRegistry);
    }

    public ManagementAddressSpace(String name, SystemAddressSpaceCreator.AddressSpaceRegistry addressSpaceRegistry) {
        this._name = name;
        this._addressSpaceRegistry = addressSpaceRegistry;
        this._broker = addressSpaceRegistry.getBroker();
        this._managementNode = new ManagementNode(this, (ConfiguredObject<?>)addressSpaceRegistry.getBroker(), null);
        this._propertiesNode = new VirtualHostPropertiesNode((NamedAddressSpace)this);
        this._messageStore = new MemoryMessageStore();
        this._principal = new ManagementAddressSpacePrincipal(this);
    }

    public MessageSource getAttainedMessageSource(String name) {
        if (this._managementNode.getName().equals(name)) {
            return this._managementNode;
        }
        if (this._propertiesNode.getName().equals(name)) {
            return this._propertiesNode;
        }
        return null;
    }

    public MessageDestination getAttainedMessageDestination(String name) {
        if (this._managementNode.getName().equals(name)) {
            return this._managementNode;
        }
        return null;
    }

    public void registerConnection(AMQPConnection<?> connection) {
        this._connections.add(connection);
    }

    public void deregisterConnection(AMQPConnection<?> connection) {
        this._connections.remove(connection);
    }

    public String getRedirectHost(AmqpPort<?> port) {
        return null;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public boolean isActive() {
        return true;
    }

    public MessageDestination getDefaultDestination() {
        return this._defaultDestination;
    }

    public LinkRegistry getLinkRegistry(String remoteContainerId) {
        return this._linkRegistry;
    }

    public boolean authoriseCreateConnection(AMQPConnection<?> connection) {
        this._broker.authorise(Operation.ACTION((String)"manage"));
        return true;
    }

    public DtxRegistry getDtxRegistry() {
        throw new DtxNotSupportedException("Distributed Transactions are not supported within this address space");
    }

    public MessageStore getMessageStore() {
        return this._messageStore;
    }

    public <T extends MessageSource> T createMessageSource(Class<T> clazz, Map<String, Object> attributes) {
        return null;
    }

    public <T extends MessageDestination> T createMessageDestination(Class<T> clazz, Map<String, Object> attributes) {
        return null;
    }

    public boolean hasMessageSources() {
        return true;
    }

    public Collection<? extends Connection<?>> getConnections() {
        return Collections.unmodifiableList(this._connections);
    }

    public String getName() {
        return this._name;
    }

    public List<String> getGlobalAddressDomains() {
        return Collections.emptyList();
    }

    private class NonDurableLinkRegistry
    implements LinkRegistry {
        private NonDurableLinkRegistry() {
        }

        public LinkModel getDurableSendingLink(String name) {
            return null;
        }

        public boolean registerSendingLink(String name, LinkModel link) {
            throw new ConnectionScopedRuntimeException("Durable links are not supported");
        }

        public boolean unregisterSendingLink(String name) {
            return false;
        }

        public LinkModel getDurableReceivingLink(String name) {
            return null;
        }

        public boolean registerReceivingLink(String name, LinkModel link) {
            throw new ConnectionScopedRuntimeException("Durable links are not supported");
        }
    }

    private class DefaultDestination
    implements MessageDestination {
        private DefaultDestination() {
        }

        public NamedAddressSpace getAddressSpace() {
            return ManagementAddressSpace.this;
        }

        public void authorisePublish(SecurityToken token, Map<String, Object> arguments) throws AccessControlException {
        }

        public String getName() {
            return "";
        }

        public <M extends ServerMessage<? extends StorableMessageMetaData>> int send(M message, String routingAddress, InstanceProperties instanceProperties, ServerTransaction txn, Action<? super MessageInstance> postEnqueueAction) {
            MessageDestination destination = ManagementAddressSpace.this.getAttainedMessageDestination(routingAddress);
            if (destination == null || destination == this) {
                return 0;
            }
            return destination.send(message, routingAddress, instanceProperties, txn, postEnqueueAction);
        }
    }
}

