/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.amqp;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.management.amqp.ManagementNode;
import org.apache.qpid.server.management.amqp.ManagementResponse;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.StateChangeListener;

class ManagementNodeConsumer
implements ConsumerImpl,
MessageDestination {
    private final long _id = ConsumerImpl.CONSUMER_NUMBER_GENERATOR.getAndIncrement();
    private final ManagementNode _managementNode;
    private final List<ManagementResponse> _queue = Collections.synchronizedList(new ArrayList());
    private final ConsumerTarget _target;
    private final String _name;
    private final StateChangeListener<ConsumerTarget, ConsumerTarget.State> _targetChangeListener = new TargetChangeListener();

    public ManagementNodeConsumer(String consumerName, ManagementNode managementNode, ConsumerTarget target) {
        this._name = consumerName;
        this._managementNode = managementNode;
        this._target = target;
        target.addStateListener(this._targetChangeListener);
    }

    public void externalStateChange() {
    }

    public boolean hasAvailableMessages() {
        return !this._queue.isEmpty();
    }

    public void pullMessage() {
    }

    public long getBytesOut() {
        return 0L;
    }

    public long getMessagesOut() {
        return 0L;
    }

    public long getUnacknowledgedBytes() {
        return 0L;
    }

    public long getUnacknowledgedMessages() {
        return 0L;
    }

    public AMQSessionModel getSessionModel() {
        return this._target.getSessionModel();
    }

    public MessageSource getMessageSource() {
        return this._managementNode;
    }

    public long getConsumerNumber() {
        return this._id;
    }

    public boolean isSuspended() {
        return false;
    }

    public boolean isClosed() {
        return false;
    }

    public boolean acquires() {
        return true;
    }

    public boolean seesRequeues() {
        return false;
    }

    public void close() {
    }

    public boolean trySendLock() {
        return this._target.trySendLock();
    }

    public void getSendLock() {
        this._target.getSendLock();
    }

    public void releaseSendLock() {
        this._target.releaseSendLock();
    }

    public boolean isActive() {
        return false;
    }

    public NamedAddressSpace getAddressSpace() {
        return this._managementNode.getAddressSpace();
    }

    public void authorisePublish(SecurityToken token, Map<String, Object> arguments) throws AccessControlException {
        this._managementNode.authorisePublish(token, arguments);
    }

    public String getName() {
        return this._name;
    }

    public <M extends ServerMessage<? extends StorableMessageMetaData>> int send(M message, String routingAddress, InstanceProperties instanceProperties, ServerTransaction txn, Action<? super MessageInstance> postEnqueueAction) {
        this.send((InternalMessage)message);
        return 1;
    }

    public void flush() {
    }

    public ConsumerTarget getTarget() {
        return this._target;
    }

    ManagementNode getManagementNode() {
        return this._managementNode;
    }

    void send(InternalMessage response) {
        this._target.getSendLock();
        try {
            ManagementResponse responseEntry = new ManagementResponse(this, response);
            if (this._queue.isEmpty() && this._target.allocateCredit((ServerMessage)response)) {
                this._target.send((ConsumerImpl)this, (MessageInstance)responseEntry, false);
            } else {
                this._queue.add(responseEntry);
            }
        }
        finally {
            this._target.releaseSendLock();
        }
    }

    private void deliverMessages() {
        this._target.getSendLock();
        try {
            while (!this._queue.isEmpty()) {
                ManagementResponse managementResponse = this._queue.get(0);
                if (!this._target.isSuspended() && this._target.allocateCredit(managementResponse.getMessage())) {
                    this._queue.remove(0);
                    this._target.send((ConsumerImpl)this, (MessageInstance)managementResponse, false);
                    continue;
                }
                break;
            }
        }
        finally {
            this._target.releaseSendLock();
        }
    }

    private class TargetChangeListener
    implements StateChangeListener<ConsumerTarget, ConsumerTarget.State> {
        private TargetChangeListener() {
        }

        public void stateChanged(ConsumerTarget object, ConsumerTarget.State oldState, ConsumerTarget.State newState) {
            if (newState == ConsumerTarget.State.ACTIVE) {
                ManagementNodeConsumer.this.deliverMessages();
            }
        }
    }
}

