/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.amqp;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.exchange.DestinationReferrer;
import org.apache.qpid.server.management.amqp.ManagementNode;
import org.apache.qpid.server.management.amqp.ManagementResponse;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageContainer;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.MessageSender;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.util.Action;

class ManagementNodeConsumer<T extends ConsumerTarget>
implements MessageInstanceConsumer<T>,
MessageDestination,
BaseQueue {
    private final ManagementNode _managementNode;
    private final List<ManagementResponse> _queue = Collections.synchronizedList(new ArrayList());
    private final T _target;
    private final String _name;
    private final UUID _identifier = UUID.randomUUID();

    public ManagementNodeConsumer(String consumerName, ManagementNode managementNode, T target) {
        this._name = consumerName;
        this._managementNode = managementNode;
        this._target = target;
    }

    public void externalStateChange() {
        if (!this._queue.isEmpty()) {
            this._target.notifyWork();
        }
    }

    public Object getIdentifier() {
        return this._identifier;
    }

    public MessageContainer pullMessage() {
        if (!this._queue.isEmpty()) {
            ManagementResponse managementResponse = this._queue.get(0);
            if (!this._target.isSuspended() && this._target.allocateCredit(managementResponse.getMessage())) {
                this._queue.remove(0);
                return new MessageContainer((MessageInstance)managementResponse, managementResponse.getMessageReference());
            }
        }
        return null;
    }

    public void setNotifyWorkDesired(boolean desired) {
        if (desired && !this._queue.isEmpty()) {
            this._target.notifyWork();
        }
    }

    AMQPSession<?, ?> getSession() {
        return this._target.getSession();
    }

    public boolean isClosed() {
        return false;
    }

    public boolean acquires() {
        return true;
    }

    public void close() {
        this._queue.forEach(ManagementResponse::delete);
        this._managementNode.unregisterConsumer(this);
    }

    public NamedAddressSpace getAddressSpace() {
        return this._managementNode.getAddressSpace();
    }

    public void authorisePublish(SecurityToken token, Map<String, Object> arguments) throws AccessControlException {
        this._managementNode.authorisePublish(token, arguments);
    }

    public String getName() {
        return this._name;
    }

    public UUID getId() {
        return this._identifier;
    }

    public MessageDurability getMessageDurability() {
        return MessageDurability.NEVER;
    }

    public <M extends ServerMessage<? extends StorableMessageMetaData>> RoutingResult<M> route(M message, String routingAddress, InstanceProperties instanceProperties) {
        RoutingResult result = new RoutingResult(message);
        result.addQueue((BaseQueue)this);
        return result;
    }

    public boolean isDurable() {
        return false;
    }

    public void linkAdded(MessageSender sender, PublishingLink link) {
    }

    public void linkRemoved(MessageSender sender, PublishingLink link) {
    }

    public MessageDestination getAlternateBindingDestination() {
        return null;
    }

    public void removeReference(DestinationReferrer destinationReferrer) {
    }

    public void addReference(DestinationReferrer destinationReferrer) {
    }

    public T getTarget() {
        return this._target;
    }

    ManagementNode getManagementNode() {
        return this._managementNode;
    }

    private void send(ManagementResponse responseEntry) {
        this._queue.add(responseEntry);
        this._target.notifyWork();
    }

    public void enqueue(ServerMessage message, Action<? super MessageInstance> action, MessageEnqueueRecord record) {
        InternalMessage internalMessage = (InternalMessage)message;
        ManagementResponse responseEntry = new ManagementResponse(this, internalMessage);
        this.send(responseEntry);
        if (action != null) {
            action.performAction((Object)responseEntry);
        }
    }

    public boolean isDeleted() {
        return this.isClosed();
    }
}

