/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.amqp;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.connection.AmqpConnectionMetaData;
import org.apache.qpid.server.connection.ConnectionPrincipal;
import org.apache.qpid.server.connection.SessionPrincipal;
import org.apache.qpid.server.consumer.ConsumerOption;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.exchange.DestinationReferrer;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.management.amqp.ManagementInputConverter;
import org.apache.qpid.server.management.amqp.ManagementNodeConsumer;
import org.apache.qpid.server.management.amqp.ManagementOutputConverter;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.MessageSender;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFinder;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.OperationParameter;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.StateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManagementNode
implements MessageSource,
MessageDestination,
BaseQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementNode.class);
    public static final String IDENTITY_ATTRIBUTE = "identity";
    public static final String INDEX_ATTRIBUTE = "index";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String ACTUALS_ATTRIBUTE = "actuals";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String OPERATION_HEADER = "operation";
    public static final String SELF_NODE_NAME = "self";
    public static final String MANAGEMENT_TYPE = "org.amqp.management";
    public static final String GET_TYPES = "GET-TYPES";
    public static final String GET_ATTRIBUTES = "GET-ATTRIBUTES";
    public static final String GET_OPERATIONS = "GET-OPERATIONS";
    public static final String QUERY = "QUERY";
    public static final String ENTITY_TYPE_HEADER = "entityType";
    public static final String STATUS_CODE_HEADER = "statusCode";
    public static final String OFFSET_HEADER = "offset";
    public static final String COUNT_HEADER = "count";
    public static final String MANAGEMENT_NODE_NAME = "$management";
    public static final String STATUS_DESCRIPTION_HEADER = "statusDescription";
    public static final String ATTRIBUTES_HEADER = "attributes";
    public static final String ATTRIBUTE_NAMES = "attributeNames";
    public static final String RESULTS = "results";
    static final String OBJECT_PATH = "object-path";
    static final String QPID_TYPE = "qpid-type";
    public static final int STATUS_CODE_OK = 200;
    private static final int STATUS_CODE_CREATED = 201;
    public static final int STATUS_CODE_NO_CONTENT = 204;
    public static final int STATUS_CODE_BAD_REQUEST = 400;
    public static final int STATUS_CODE_FORBIDDEN = 403;
    public static final int STATUS_CODE_NOT_FOUND = 404;
    public static final int STATUS_CODE_CONFLICT = 409;
    public static final int STATUS_CODE_INTERNAL_ERROR = 500;
    public static final int STATUS_CODE_NOT_IMPLEMENTED = 501;
    private static final Comparator<? super ConfiguredObject<?>> OBJECT_COMPARATOR = new Comparator<ConfiguredObject<?>>(){

        @Override
        public int compare(ConfiguredObject<?> o1, ConfiguredObject<?> o2) {
            if (o1 == o2) {
                return 0;
            }
            int result = o1.getCategoryClass().getSimpleName().compareTo(o2.getCategoryClass().getSimpleName());
            if (result == 0) {
                result = o1.getName().compareTo(o2.getName());
            }
            if (result == 0) {
                result = o1.getId().compareTo(o2.getId());
            }
            return result;
        }
    };
    private final NamedAddressSpace _addressSpace;
    private final UUID _id;
    private final ConfiguredObject<?> _managedObject;
    private final Model _model;
    private final Map<Class<? extends ConfiguredObject>, ConfiguredObjectOperation<?>> _associatedChildrenOperations = new HashMap();
    private final ConfiguredObjectFinder _configuredObjectFinder;
    private List<ManagementNodeConsumer> _consumers = new CopyOnWriteArrayList<ManagementNodeConsumer>();
    private final Set<Class<? extends ConfiguredObject>> _managedCategories = new HashSet<Class<? extends ConfiguredObject>>();
    private final Map<String, Class<? extends ConfiguredObject>> _managedTypes = new HashMap<String, Class<? extends ConfiguredObject>>();
    private final Map<Class<? extends ConfiguredObject>, Map<String, StandardOperation>> _standardOperations = new HashMap<Class<? extends ConfiguredObject>, Map<String, StandardOperation>>();
    private final ManagementOutputConverter _managementOutputConverter;
    private final ManagementInputConverter _managementInputConverter;
    private static final InstanceProperties CONSUMED_INSTANCE_PROPERTIES = prop -> null;
    private final StandardOperation CREATE_OPERATION = new StandardOperation(){

        @Override
        public String getName() {
            return "CREATE";
        }

        @Override
        public InternalMessage performOperation(Class<? extends ConfiguredObject> clazz, InternalMessage message) {
            return ManagementNode.this.performCreateOperation(clazz, message);
        }
    };
    private final StandardOperation READ_OPERATION = new StandardOperation(){

        @Override
        public String getName() {
            return "READ";
        }

        @Override
        public InternalMessage performOperation(Class<? extends ConfiguredObject> clazz, InternalMessage message) {
            return ManagementNode.this.performReadOperation(clazz, message);
        }
    };
    private final StandardOperation UPDATE_OPERATION = new StandardOperation(){

        @Override
        public String getName() {
            return "UPDATE";
        }

        @Override
        public InternalMessage performOperation(Class<? extends ConfiguredObject> clazz, InternalMessage message) {
            return ManagementNode.this.performUpdateOperation(clazz, message);
        }
    };
    private final StandardOperation DELETE_OPERATION = new StandardOperation(){

        @Override
        public String getName() {
            return "DELETE";
        }

        @Override
        public InternalMessage performOperation(Class<? extends ConfiguredObject> clazz, InternalMessage message) {
            return ManagementNode.this.performDeleteOperation(clazz, message);
        }
    };
    private final Set<String> STANDARD_OPERATIONS = Sets.newHashSet((Object[])new String[]{this.CREATE_OPERATION.getName(), this.READ_OPERATION.getName(), this.UPDATE_OPERATION.getName(), this.DELETE_OPERATION.getName()});

    ManagementNode(NamedAddressSpace addressSpace, ConfiguredObject<?> configuredObject) {
        this._addressSpace = addressSpace;
        String name = configuredObject.getId() + MANAGEMENT_NODE_NAME;
        this._id = UUID.nameUUIDFromBytes(name.getBytes(Charset.defaultCharset()));
        this._model = configuredObject.getModel();
        this._managedObject = configuredObject;
        this.populateMetaData();
        this._managementOutputConverter = new ManagementOutputConverter(this);
        this._managementInputConverter = new ManagementInputConverter(this);
        this._configuredObjectFinder = new ConfiguredObjectFinder(configuredObject);
    }

    ConfiguredObject<?> getManagedObject() {
        return this._managedObject;
    }

    boolean isSyntheticChildClass(Class<? extends ConfiguredObject> clazz) {
        return this._associatedChildrenOperations.containsKey(clazz);
    }

    private void populateMetaData() {
        this.populateManagedCategories();
        this.populateManagedTypes();
        this.populateStandardOperations();
    }

    private void populateStandardOperations() {
        for (Class<? extends ConfiguredObject> type : this._managedTypes.values()) {
            HashMap<String, StandardOperation> operationsMap = new HashMap<String, StandardOperation>();
            this._standardOperations.put(type, operationsMap);
            operationsMap.put(this.READ_OPERATION.getName(), this.READ_OPERATION);
            operationsMap.put(this.UPDATE_OPERATION.getName(), this.UPDATE_OPERATION);
            if (ConfiguredObjectTypeRegistry.getCategory(type) == this._managedObject.getCategoryClass()) continue;
            operationsMap.put(this.DELETE_OPERATION.getName(), this.DELETE_OPERATION);
            if (!type.getAnnotation(ManagedObject.class).creatable()) continue;
            operationsMap.put(this.CREATE_OPERATION.getName(), this.CREATE_OPERATION);
        }
    }

    private void populateManagedTypes() {
        for (Class<? extends ConfiguredObject> category : this._managedCategories) {
            this._managedTypes.put(this.getAmqpName(category), category);
            if (category != this._managedObject.getCategoryClass()) {
                for (Class type : this._model.getTypeRegistry().getTypeSpecialisations(category)) {
                    if (type.getAnnotation(ManagedObject.class) == null) continue;
                    this._managedTypes.put(this.getAmqpName(type), type);
                }
                continue;
            }
            if (this._managedObject.getTypeClass() == this._managedObject.getCategoryClass()) continue;
            this._managedTypes.put(this.getAmqpName(this._managedObject.getTypeClass()), this._managedObject.getTypeClass());
        }
    }

    private void populateManagedCategories() {
        Class managedCategory = this._managedObject.getCategoryClass();
        this.addManagedCategories(managedCategory);
        for (ConfiguredObjectOperation operation : this._model.getTypeRegistry().getOperations(managedCategory).values()) {
            if (!operation.isAssociateAsIfChildren() || !ConfiguredObjectTypeRegistry.returnsCollectionOfConfiguredObjects((ConfiguredObjectOperation)operation)) continue;
            Class associatedChildCategory = this.getCollectionMemberType((ParameterizedType)operation.getGenericReturnType());
            this._associatedChildrenOperations.put(associatedChildCategory, operation);
            this.addManagedCategories(associatedChildCategory);
        }
    }

    private Class getCollectionMemberType(ParameterizedType collectionType) {
        return ConfiguredObjectTypeRegistry.getRawType((Type)collectionType.getActualTypeArguments()[0]);
    }

    String getAmqpName(Class<? extends ConfiguredObject> type) {
        ManagedObject annotation = type.getAnnotation(ManagedObject.class);
        return "".equals(annotation.amqpName()) ? type.getName() : annotation.amqpName();
    }

    private void addManagedCategories(Class<? extends ConfiguredObject> category) {
        if (this._managedCategories.add(category)) {
            for (Class childClass : this._model.getChildTypes(category)) {
                this.addManagedCategories(childClass);
            }
        }
    }

    public <M extends ServerMessage<? extends StorableMessageMetaData>> RoutingResult<M> route(M message, String routingAddress, InstanceProperties instanceProperties) {
        MessageConverter converter;
        RoutingResult result = new RoutingResult(message);
        if (message.isResourceAcceptable((TransactionLogResource)this) && (converter = MessageConverterRegistry.getConverter(message.getClass(), InternalMessage.class)) != null) {
            result.addQueue((BaseQueue)this);
        }
        return result;
    }

    public boolean isDurable() {
        return true;
    }

    public void linkAdded(MessageSender sender, PublishingLink link) {
    }

    public void linkRemoved(MessageSender sender, PublishingLink link) {
    }

    public MessageDestination getAlternateBindingDestination() {
        return null;
    }

    public void removeReference(DestinationReferrer destinationReferrer) {
    }

    public void addReference(DestinationReferrer destinationReferrer) {
    }

    private synchronized void processRequest(InternalMessage message) {
        String id = (String)message.getMessageHeader().getHeader(IDENTITY_ATTRIBUTE);
        String type = (String)message.getMessageHeader().getHeader(TYPE_ATTRIBUTE);
        String operation = (String)message.getMessageHeader().getHeader(OPERATION_HEADER);
        LOGGER.debug("Management Node identity: {}, type: {}, operation {}", new Object[]{id, type, operation});
        InternalMessage response = SELF_NODE_NAME.equals(id) && type.equals(MANAGEMENT_TYPE) ? this.performManagementOperation(operation, message) : (this._managedTypes.containsKey(type) ? this.performOperation(this._managedTypes.get(type), operation, message) : this.createFailureResponse(message, 404, "Unknown type {0}", type));
        this.sendResponse(message, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(ServerMessage message, Action<? super MessageInstance> action, MessageEnqueueRecord record) {
        MessageConverter converter = MessageConverterRegistry.getConverter(message.getClass(), InternalMessage.class);
        InternalMessage msg = (InternalMessage)converter.convert(message, this._addressSpace);
        try {
            if (action != null) {
                action.performAction((Object)new ConsumedMessageInstance((ServerMessage)msg));
            }
            this.processRequest(msg);
        }
        finally {
            converter.dispose((ServerMessage)msg);
        }
    }

    public boolean isDeleted() {
        return false;
    }

    private InternalMessage performOperation(Class<? extends ConfiguredObject> clazz, String operation, InternalMessage message) {
        try {
            if (this.STANDARD_OPERATIONS.contains(operation)) {
                StandardOperation standardOperation = this._standardOperations.get(clazz).get(operation);
                if (standardOperation != null) {
                    return standardOperation.performOperation(clazz, message);
                }
            } else {
                InternalMessageHeader requestHeader = message.getMessageHeader();
                Map headers = requestHeader.getHeaderMap();
                ConfiguredObject<?> object = this.findObject(clazz, headers);
                if (object == null) {
                    return this.createFailureResponse(message, 404, "Not found", new Object[0]);
                }
                Map operations = this._model.getTypeRegistry().getOperations(object.getClass());
                ConfiguredObjectOperation method = (ConfiguredObjectOperation)operations.get(operation);
                if (method != null) {
                    return this.performConfiguredObjectOperation(object, message, method);
                }
            }
            return this.createFailureResponse(message, 501, "Not implemented", new Object[0]);
        }
        catch (RuntimeException e) {
            return this.createFailureResponse(message, 500, e.getMessage(), new Object[0]);
        }
    }

    private InternalMessage performDeleteOperation(Class<? extends ConfiguredObject> clazz, InternalMessage message) {
        InternalMessageHeader requestHeader = message.getMessageHeader();
        Map headers = requestHeader.getHeaderMap();
        ConfiguredObject<?> object = this.findObject(clazz, headers);
        if (object != null) {
            try {
                object.delete();
                MutableMessageHeader responseHeader = new MutableMessageHeader();
                responseHeader.setCorrelationId(requestHeader.getCorrelationId() == null ? requestHeader.getMessageId() : requestHeader.getCorrelationId());
                responseHeader.setMessageId(UUID.randomUUID().toString());
                responseHeader.setHeader(STATUS_CODE_HEADER, 204);
                return InternalMessage.createMapMessage((MessageStore)this._addressSpace.getMessageStore(), (AMQMessageHeader)responseHeader, Collections.emptyMap());
            }
            catch (IntegrityViolationException e) {
                return this.createFailureResponse(message, 403, e.getMessage(), new Object[0]);
            }
        }
        return this.createFailureResponse(message, 404, "Not Found", new Object[0]);
    }

    private InternalMessage performUpdateOperation(Class<? extends ConfiguredObject> clazz, InternalMessage message) {
        InternalMessageHeader requestHeader = message.getMessageHeader();
        Map headers = requestHeader.getHeaderMap();
        ConfiguredObject<?> object = this.findObject(clazz, headers);
        if (object != null) {
            if (message.getMessageBody() instanceof Map) {
                String attributeName;
                Object parentValue;
                HashMap<String, String> attributes = new HashMap<String, String>((Map)message.getMessageBody());
                Object id = attributes.remove(IDENTITY_ATTRIBUTE);
                if (id != null && !String.valueOf(id).equals(object.getId().toString())) {
                    return this.createFailureResponse(message, 403, "Cannot change the value of 'identity'", new Object[0]);
                }
                String path = (String)attributes.remove(OBJECT_PATH);
                Class parentType = this._model.getParentType(clazz);
                if (parentType != null && (parentValue = attributes.remove(attributeName = parentType.getSimpleName().toLowerCase())) != null && !String.valueOf(parentValue).equals(object.getParent().getName())) {
                    return this.createFailureResponse(message, 403, "Cannot change the value of '" + attributeName + "'", new Object[0]);
                }
                if (path != null && !attributes.containsKey("name")) {
                    String[] pathElements = this.getPathElements(path);
                    attributes.put("name", pathElements[pathElements.length - 1]);
                }
                object.setAttributes(attributes);
                MutableMessageHeader responseHeader = new MutableMessageHeader();
                responseHeader.setCorrelationId(requestHeader.getCorrelationId() == null ? requestHeader.getMessageId() : requestHeader.getCorrelationId());
                responseHeader.setMessageId(UUID.randomUUID().toString());
                responseHeader.setHeader(STATUS_CODE_HEADER, 200);
                return InternalMessage.createMapMessage((MessageStore)this._addressSpace.getMessageStore(), (AMQMessageHeader)responseHeader, this._managementOutputConverter.convertToOutput(object, true));
            }
            return this.createFailureResponse(message, 400, "Message body must be a map", new Object[0]);
        }
        return this.createFailureResponse(message, 404, "No such object", new Object[0]);
    }

    private String[] getPathElements(String path) {
        String[] pathElements = path.split("(?<!\\\\)" + Pattern.quote("/"));
        for (int i = 0; i < pathElements.length; ++i) {
            pathElements[i] = pathElements[i].replaceAll("\\\\(.)", "$1");
        }
        return pathElements;
    }

    private InternalMessage performReadOperation(Class<? extends ConfiguredObject> clazz, InternalMessage message) {
        InternalMessageHeader requestHeader = message.getMessageHeader();
        Map headers = requestHeader.getHeaderMap();
        boolean actuals = headers.get(ACTUALS_ATTRIBUTE) == null || Boolean.parseBoolean(String.valueOf(headers.get(ACTUALS_ATTRIBUTE)));
        ConfiguredObject<?> object = this.findObject(clazz, headers);
        if (object != null) {
            MutableMessageHeader responseHeader = new MutableMessageHeader();
            responseHeader.setCorrelationId(requestHeader.getCorrelationId() == null ? requestHeader.getMessageId() : requestHeader.getCorrelationId());
            responseHeader.setMessageId(UUID.randomUUID().toString());
            responseHeader.setHeader(STATUS_CODE_HEADER, 200);
            return InternalMessage.createMapMessage((MessageStore)this._addressSpace.getMessageStore(), (AMQMessageHeader)responseHeader, this._managementOutputConverter.convertToOutput(object, actuals));
        }
        return this.createFailureResponse(message, 404, "Not found", new Object[0]);
    }

    private InternalMessage performCreateOperation(Class<? extends ConfiguredObject> clazz, InternalMessage message) {
        InternalMessageHeader requestHeader = message.getMessageHeader();
        MutableMessageHeader responseHeader = new MutableMessageHeader();
        responseHeader.setCorrelationId(requestHeader.getCorrelationId() == null ? requestHeader.getMessageId() : requestHeader.getCorrelationId());
        responseHeader.setMessageId(UUID.randomUUID().toString());
        responseHeader.setHeader(STATUS_CODE_HEADER, 201);
        if (message.getMessageBody() instanceof Map) {
            Class typeClass;
            String type;
            Map attributes = (Map)message.getMessageBody();
            if (attributes.containsKey(IDENTITY_ATTRIBUTE)) {
                return this.createFailureResponse(message, 400, "The 'identity' cannot be set when creating an object", new Object[0]);
            }
            if (attributes.containsKey("id")) {
                return this.createFailureResponse(message, 400, "The 'id' cannot be set when creating an object", new Object[0]);
            }
            if (!attributes.containsKey(QPID_TYPE) && ConfiguredObjectTypeRegistry.getCategory(clazz) != clazz && !"".equals(type = (typeClass = this._model.getTypeRegistry().getTypeClass(clazz)).getAnnotation(ManagedObject.class).type())) {
                attributes.put(QPID_TYPE, type);
            }
            if (attributes.containsKey(OBJECT_PATH)) {
                String path = String.valueOf(attributes.remove(OBJECT_PATH));
                ConfiguredObject theParent = this._managedObject;
                Class[] hierarchy = this._configuredObjectFinder.getHierarchy(clazz);
                if (hierarchy.length > 1) {
                    ConfiguredObject parent = this._configuredObjectFinder.findObjectParentsFromPath(Arrays.asList(this.getPathElements(path)), hierarchy, ConfiguredObjectTypeRegistry.getCategory(clazz));
                    if (parent == null) {
                        return this.createFailureResponse(message, 404, "The 'object-path' " + path + " does not identify a valid parent", new Object[0]);
                    }
                    theParent = parent;
                }
                return this.doCreate(clazz, message, responseHeader, attributes, theParent);
            }
            if (this._configuredObjectFinder.getHierarchy(clazz).length == 1 && attributes.containsKey("name")) {
                return this.doCreate(clazz, message, responseHeader, attributes, this._managedObject);
            }
            return this.createFailureResponse(message, 400, "The 'object-path' must be supplied", new Object[0]);
        }
        return this.createFailureResponse(message, 400, "Message body must be a map", new Object[0]);
    }

    private InternalMessage doCreate(Class<? extends ConfiguredObject> clazz, InternalMessage message, MutableMessageHeader responseHeader, Map<String, Object> attributes, ConfiguredObject<?> parent) {
        try {
            ManagedObject annotation = clazz.getAnnotation(ManagedObject.class);
            if (!annotation.category() || !"".equals(annotation.defaultType()) || attributes.containsKey(QPID_TYPE) || this._model.getTypeRegistry().getTypeSpecialisations(clazz).size() == 1) {
                if (attributes.containsKey(QPID_TYPE)) {
                    attributes.put(TYPE_ATTRIBUTE, attributes.remove(QPID_TYPE));
                } else {
                    attributes.remove(TYPE_ATTRIBUTE);
                }
                ConfiguredObject object = parent.createChild(ConfiguredObjectTypeRegistry.getCategory(clazz), attributes);
                return InternalMessage.createMapMessage((MessageStore)this._addressSpace.getMessageStore(), (AMQMessageHeader)responseHeader, this._managementOutputConverter.convertToOutput(object, true));
            }
            return this.createFailureResponse(message, 400, "type: '" + this.getAmqpName(clazz) + "' requires the '" + QPID_TYPE + "' attribute", new Object[0]);
        }
        catch (AbstractConfiguredObject.DuplicateNameException e) {
            return this.createFailureResponse(message, 409, "Object already exists with the same path", new Object[0]);
        }
        catch (IllegalArgumentException | IllegalStateException | IllegalConfigurationException e) {
            return this.createFailureResponse(message, 400, e.getMessage(), new Object[0]);
        }
        catch (AccessControlException e) {
            return this.createFailureResponse(message, 403, "Forbidden", new Object[0]);
        }
    }

    private InternalMessage performConfiguredObjectOperation(ConfiguredObject<?> object, InternalMessage message, ConfiguredObjectOperation<ConfiguredObject<?>> method) {
        InternalMessageHeader requestHeader = message.getMessageHeader();
        Map headers = requestHeader.getHeaderMap();
        try {
            HashMap parameters = new HashMap(headers);
            parameters.remove(KEY_ATTRIBUTE);
            parameters.remove(IDENTITY_ATTRIBUTE);
            parameters.remove(TYPE_ATTRIBUTE);
            parameters.remove(INDEX_ATTRIBUTE);
            parameters.remove(OPERATION_HEADER);
            parameters.keySet().removeIf(paramName -> paramName.startsWith("JMS_QPID"));
            AmqpConnectionMetaData callerConnectionMetaData = this.getCallerConnectionMetaData();
            if (method.isSecure(object, parameters) && !callerConnectionMetaData.getTransport().isSecure() && !callerConnectionMetaData.getPort().isAllowConfidentialOperationsOnInsecureChannels()) {
                return this.createFailureResponse(message, 403, "Operation '" + method.getName() + "' can only be performed over a secure (AMQPS) connection", new Object[0]);
            }
            MutableMessageHeader responseHeader = new MutableMessageHeader();
            responseHeader.setCorrelationId(requestHeader.getCorrelationId() == null ? requestHeader.getMessageId() : requestHeader.getCorrelationId());
            responseHeader.setMessageId(UUID.randomUUID().toString());
            responseHeader.setHeader(STATUS_CODE_HEADER, 200);
            Object result = method.perform(object, parameters);
            return this.createManagedOperationResponse(method, responseHeader, result);
        }
        catch (IllegalArgumentException | IllegalStateException | IllegalConfigurationException e) {
            return this.createFailureResponse(message, 400, e.getMessage(), new Object[0]);
        }
        catch (AccessControlException e) {
            return this.createFailureResponse(message, 403, "Forbidden", new Object[0]);
        }
    }

    private InternalMessage createManagedOperationResponse(ConfiguredObjectOperation<ConfiguredObject<?>> method, MutableMessageHeader responseHeader, Object result) {
        Object convertedValue = this._managementOutputConverter.convertObjectToOutput(result);
        if (convertedValue instanceof byte[]) {
            return InternalMessage.createBytesMessage((MessageStore)this._addressSpace.getMessageStore(), (AMQMessageHeader)responseHeader, (byte[])((byte[])convertedValue), (boolean)false);
        }
        if (convertedValue instanceof Map) {
            return InternalMessage.createMapMessage((MessageStore)this._addressSpace.getMessageStore(), (AMQMessageHeader)responseHeader, (Map)((Map)convertedValue));
        }
        if (convertedValue instanceof Serializable) {
            return InternalMessage.createMessage((MessageStore)this._addressSpace.getMessageStore(), (AMQMessageHeader)responseHeader, (Serializable)((Serializable)convertedValue), (boolean)false, null);
        }
        return InternalMessage.createBytesMessage((MessageStore)this._addressSpace.getMessageStore(), (AMQMessageHeader)responseHeader, (byte[])new byte[0], (boolean)false);
    }

    String generatePath(ConfiguredObject<?> object) {
        return this._configuredObjectFinder.getPath(object);
    }

    private ConfiguredObject<?> findObject(Class<? extends ConfiguredObject> clazz, Map<String, Object> headers) {
        if (headers.containsKey(IDENTITY_ATTRIBUTE)) {
            UUID id;
            Object value = headers.get(IDENTITY_ATTRIBUTE);
            if (value instanceof UUID) {
                id = (UUID)value;
            } else if (value instanceof String) {
                id = UUID.fromString((String)value);
            } else {
                return null;
            }
            return this.findObjectById(id, clazz);
        }
        if (headers.containsKey(INDEX_ATTRIBUTE)) {
            Object index = headers.get(INDEX_ATTRIBUTE);
            if (OBJECT_PATH.equals(index)) {
                return this._configuredObjectFinder.findObjectFromPath(String.valueOf(headers.get(KEY_ATTRIBUTE)), clazz);
            }
            throw new IllegalArgumentException("Unknown index: '" + index + '\"');
        }
        throw new IllegalArgumentException("Either identity or index must be specified");
    }

    private ConfiguredObject<?> findObjectById(UUID id, Class<? extends ConfiguredObject> clazz) {
        Collection ancestorCategories = this._model.getAncestorCategories(clazz);
        if (ancestorCategories.contains(this._managedObject.getCategoryClass())) {
            return this.findDescendantById(clazz, id, this._managedObject.getCategoryClass(), Collections.singleton(this._managedObject));
        }
        for (Map.Entry<Class<ConfiguredObject>, ConfiguredObjectOperation<?>> entry : this._associatedChildrenOperations.entrySet()) {
            if (!ancestorCategories.contains(entry.getKey())) continue;
            ConfiguredObjectOperation<?> operation = entry.getValue();
            Collection associated = (Collection)operation.perform(this._managedObject, Collections.emptyMap());
            ConfiguredObject<?> object = this.findDescendantById(clazz, id, entry.getKey(), associated);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private ConfiguredObject<?> findDescendantById(Class<? extends ConfiguredObject> category, UUID id, Class<? extends ConfiguredObject> rootCategory, Collection<? extends ConfiguredObject> roots) {
        if (category == rootCategory) {
            for (ConfiguredObject configuredObject : roots) {
                if (!configuredObject.getId().equals(id)) continue;
                return configuredObject;
            }
        } else if (this._model.getChildTypes(rootCategory).contains(category)) {
            for (ConfiguredObject configuredObject : roots) {
                ConfiguredObject child = configuredObject.getChildById(category, id);
                if (child == null) continue;
                return child;
            }
        } else {
            Collection ancestorCategories = this._model.getAncestorCategories(category);
            for (Class childClass : this._model.getChildTypes(rootCategory)) {
                ConfiguredObject<?> child;
                if (!ancestorCategories.contains(childClass)) continue;
                ArrayList newRoots = new ArrayList();
                for (ConfiguredObject configuredObject : roots) {
                    newRoots.addAll(configuredObject.getChildren(childClass));
                }
                if (newRoots.isEmpty() || (child = this.findDescendantById(category, id, childClass, newRoots)) == null) continue;
                return child;
            }
        }
        return null;
    }

    private void sendResponse(InternalMessage message, InternalMessage response) {
        String replyTo = message.getMessageHeader().getReplyTo();
        response.setInitialRoutingAddress(replyTo);
        MessageDestination responseDestination = this.getResponseDestination(replyTo);
        RoutingResult result = responseDestination.route((ServerMessage)response, replyTo, InstanceProperties.EMPTY);
        result.send((ServerTransaction)new AutoCommitTransaction(this._addressSpace.getMessageStore()), null);
    }

    private MessageDestination getResponseDestination(String replyTo) {
        MessageDestination consumer = null;
        Subject currentSubject = Subject.getSubject(AccessController.getContext());
        Set<SessionPrincipal> sessionPrincipals = currentSubject.getPrincipals(SessionPrincipal.class);
        if (!sessionPrincipals.isEmpty()) {
            AMQPSession publishingSession = sessionPrincipals.iterator().next().getSession();
            for (ManagementNodeConsumer candidate : this._consumers) {
                if (!candidate.getTarget().getTargetAddress().equals(replyTo) || candidate.getSession().getConnectionReference() != publishingSession.getConnectionReference()) continue;
                consumer = candidate;
                break;
            }
        }
        return consumer == null ? this._addressSpace.getDefaultDestination() : consumer;
    }

    private InternalMessage createFailureResponse(InternalMessage requestMessage, int statusCode, String stateDescription, Object ... params) {
        InternalMessageHeader requestHeader = requestMessage.getMessageHeader();
        MutableMessageHeader responseHeader = new MutableMessageHeader();
        responseHeader.setCorrelationId(requestHeader.getCorrelationId() == null ? requestHeader.getMessageId() : requestHeader.getCorrelationId());
        responseHeader.setMessageId(UUID.randomUUID().toString());
        for (String header : requestHeader.getHeaderNames()) {
            responseHeader.setHeader(header, requestHeader.getHeader(header));
        }
        responseHeader.setHeader(STATUS_CODE_HEADER, statusCode);
        responseHeader.setHeader(STATUS_DESCRIPTION_HEADER, params.length == 0 ? stateDescription : MessageFormat.format(stateDescription, params));
        return InternalMessage.createBytesMessage((MessageStore)this._addressSpace.getMessageStore(), (AMQMessageHeader)responseHeader, (byte[])new byte[0]);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InternalMessage performManagementOperation(String operation, InternalMessage msg) {
        void var6_9;
        InternalMessageHeader requestHeader = msg.getMessageHeader();
        MutableMessageHeader responseHeader = new MutableMessageHeader();
        responseHeader.setCorrelationId(requestHeader.getCorrelationId() == null ? requestHeader.getMessageId() : requestHeader.getCorrelationId());
        responseHeader.setMessageId(UUID.randomUUID().toString());
        if (GET_TYPES.equals(operation)) {
            Map<String, List<String>> map = this.performGetTypes(requestHeader.getHeaderMap());
        } else if (GET_ATTRIBUTES.equals(operation)) {
            Map<String, List<String>> map = this.performGetAttributes(requestHeader.getHeaderMap());
        } else if (GET_OPERATIONS.equals(operation)) {
            Map<String, Map<String, List<String>>> map = this.performGetOperations(requestHeader.getHeaderMap());
        } else {
            if (!QUERY.equals(operation)) return this.createFailureResponse(msg, 501, "Unknown operation {}", operation);
            if (!(msg.getMessageBody() instanceof Map)) return this.createFailureResponse(msg, 400, "Body of a QUERY operation must be a map", new Object[0]);
            Map<?, ?> map = this.performQuery(requestHeader.getHeaderMap(), (Map)msg.getMessageBody());
        }
        responseHeader.setHeader(STATUS_CODE_HEADER, 200);
        return InternalMessage.createMapMessage((MessageStore)this._addressSpace.getMessageStore(), (AMQMessageHeader)responseHeader, (Map)var6_9);
    }

    private Map<?, ?> performQuery(Map<String, Object> headerMap, Map messageBody) {
        List<Object> attributeNames;
        List attributeNameObjects = this._managementInputConverter.convert(List.class, messageBody.get(ATTRIBUTE_NAMES));
        if (attributeNameObjects == null) {
            attributeNames = Collections.emptyList();
        } else {
            attributeNames = new ArrayList(attributeNameObjects.size());
            for (Object nameObject : attributeNameObjects) {
                if (nameObject == null) {
                    throw new IllegalArgumentException("All attribute names must be non-null");
                }
                attributeNames.add(nameObject.toString());
            }
        }
        String entityType = (String)headerMap.get(ENTITY_TYPE_HEADER);
        if (attributeNames.isEmpty()) {
            attributeNames = this.generateAttributeNames(entityType);
        }
        List<Object> objects = this.getObjects(entityType);
        objects.sort(OBJECT_COMPARATOR);
        if (headerMap.containsKey(OFFSET_HEADER)) {
            int offset = headerMap.get(OFFSET_HEADER) instanceof Number ? ((Number)headerMap.get(OFFSET_HEADER)).intValue() : Integer.parseInt(headerMap.get(OFFSET_HEADER).toString());
            if (offset >= 0) {
                objects = offset < objects.size() ? objects.subList(offset, objects.size()) : Collections.emptyList();
            } else if (objects.size() + offset > 0) {
                objects = objects.subList(objects.size() + offset, objects.size());
            }
        }
        if (headerMap.containsKey(COUNT_HEADER)) {
            int count = headerMap.get(COUNT_HEADER) instanceof Number ? ((Number)headerMap.get(COUNT_HEADER)).intValue() : Integer.parseInt(headerMap.get(OFFSET_HEADER).toString());
            if (count >= 0) {
                objects = count < objects.size() ? objects.subList(0, count) : Collections.emptyList();
            } else if (objects.size() + count > 0) {
                objects = objects.subList(0, objects.size() + count);
            }
        }
        ArrayList resultList = new ArrayList(objects.size());
        for (ConfiguredObject<?> configuredObject : objects) {
            ArrayList attributes = new ArrayList(attributeNames.size());
            Map<?, ?> convertedObject = this._managementOutputConverter.convertToOutput(configuredObject, true);
            for (String string : attributeNames) {
                attributes.add(convertedObject.get(string));
            }
            resultList.add(attributes);
        }
        LinkedHashMap<String, List<Object>> result = new LinkedHashMap<String, List<Object>>();
        result.put(ATTRIBUTE_NAMES, attributeNames);
        result.put(RESULTS, resultList);
        return result;
    }

    private Collection<ConfiguredObject<?>> getChildrenOfType(ConfiguredObject<?> object, Class<? extends ConfiguredObject> type) {
        HashSet children = new HashSet();
        Class categoryClass = ConfiguredObjectTypeRegistry.getCategory(type);
        for (Class childClass : this._model.getChildTypes(object.getCategoryClass())) {
            if (childClass == categoryClass) {
                for (ConfiguredObject child : object.getChildren(childClass)) {
                    if (categoryClass != type && child.getTypeClass() != type) continue;
                    children.add(child);
                }
                continue;
            }
            if (!this._model.getAncestorCategories(categoryClass).contains(childClass)) continue;
            for (ConfiguredObject child : object.getChildren(childClass)) {
                children.addAll(this.getChildrenOfType(child, type));
            }
        }
        return children;
    }

    private List<ConfiguredObject<?>> getObjects(String entityType) {
        Set<ConfiguredObject<?>> foundObjects;
        if (entityType == null) {
            foundObjects = this.findAllChildren();
        } else {
            Class<? extends ConfiguredObject> type = this._managedTypes.get(entityType);
            if (type != null) {
                foundObjects = new HashSet();
                Collection ancestorCategories = this._model.getAncestorCategories(ConfiguredObjectTypeRegistry.getCategory(type));
                if (ancestorCategories.contains(this._managedObject.getCategoryClass())) {
                    foundObjects.addAll(this.getChildrenOfType(this._managedObject, type));
                }
                for (Map.Entry<Class<ConfiguredObject>, ConfiguredObjectOperation<?>> entry : this._associatedChildrenOperations.entrySet()) {
                    if (!ancestorCategories.contains(entry.getKey())) continue;
                    Collection<ConfiguredObject<?>> parents = ManagementNode.getAssociatedChildren(entry.getValue(), this._managedObject);
                    for (ConfiguredObject<?> parent : parents) {
                        foundObjects.addAll(this.getChildrenOfType(parent, type));
                    }
                }
            } else {
                throw new IllegalArgumentException("Unknown entity type: '" + entityType + "'");
            }
        }
        return new ArrayList(foundObjects);
    }

    private Set<ConfiguredObject<?>> findAllChildren() {
        HashSet children;
        HashSet foundObjects = new HashSet();
        HashSet parents = new HashSet();
        parents.add(this._managedObject);
        for (ConfiguredObjectOperation<?> configuredObjectOperation : this._associatedChildrenOperations.values()) {
            Collection<ConfiguredObject<?>> associated = ManagementNode.getAssociatedChildren(configuredObjectOperation, this._managedObject);
            parents.addAll(associated);
        }
        foundObjects.addAll(parents);
        do {
            children = new HashSet();
            for (ConfiguredObject configuredObject : parents) {
                for (Class childClass : this._model.getChildTypes(configuredObject.getCategoryClass())) {
                    children.addAll(configuredObject.getChildren(childClass));
                }
            }
        } while (foundObjects.addAll(parents = children));
        return foundObjects;
    }

    private static <C extends ConfiguredObject<?>> Collection<ConfiguredObject<?>> getAssociatedChildren(ConfiguredObjectOperation<C> op, ConfiguredObject<?> managedObject) {
        Collection associated = (Collection)op.perform(managedObject, Collections.emptyMap());
        return associated;
    }

    private List<String> generateAttributeNames(String entityType) {
        ArrayList<Class<? extends ConfiguredObject>> classes;
        ConfiguredObjectTypeRegistry typeRegistry;
        ArrayList<String> attributeNames;
        HashSet<String> attrNameSet;
        block5: {
            block4: {
                attrNameSet = new HashSet<String>();
                attributeNames = new ArrayList<String>();
                for (String standardAttribute : Arrays.asList(IDENTITY_ATTRIBUTE, TYPE_ATTRIBUTE, QPID_TYPE, OBJECT_PATH)) {
                    attrNameSet.add(standardAttribute);
                    attributeNames.add(standardAttribute);
                }
                typeRegistry = this._model.getTypeRegistry();
                classes = new ArrayList<Class<? extends ConfiguredObject>>();
                if (entityType == null || entityType.trim().equals("")) break block4;
                Class<? extends ConfiguredObject> clazz = this._managedTypes.get(entityType);
                if (clazz == null) break block5;
                classes.add(clazz);
                if (ConfiguredObjectTypeRegistry.getCategory(clazz) != clazz) break block5;
                classes.addAll(this._model.getTypeRegistry().getTypeSpecialisations(clazz));
                break block5;
            }
            for (Class<Object> clazz : this._managedCategories) {
                classes.add(clazz);
                classes.addAll(this._model.getTypeRegistry().getTypeSpecialisations(clazz));
            }
        }
        for (Class<Object> clazz : classes) {
            Class parentType;
            for (String name : typeRegistry.getAttributeNames(clazz)) {
                if ("id".equals(name) || !attrNameSet.add(name)) continue;
                attributeNames.add(name);
            }
            Class category = ConfiguredObjectTypeRegistry.getCategory(clazz);
            if (category == this._managedObject.getCategoryClass() || this.isSyntheticChildClass(category) || (parentType = this._model.getParentType(category)) == this._managedObject.getCategoryClass()) continue;
            attributeNames.add(parentType.getSimpleName().toLowerCase());
        }
        return attributeNames;
    }

    private <T> Map<String, T> performManagementOperation(Map<String, Object> requestHeader, TypeOperation<T> operation, T selfValue) {
        LinkedHashMap<String, T> responseMap = new LinkedHashMap<String, T>();
        if (requestHeader.containsKey(ENTITY_TYPE_HEADER)) {
            String entityType = (String)requestHeader.get(ENTITY_TYPE_HEADER);
            Class<? extends ConfiguredObject> clazz = this._managedTypes.get(entityType);
            if (clazz != null) {
                responseMap.put(entityType, operation.evaluateType(clazz));
                if (ConfiguredObjectTypeRegistry.getCategory(clazz) == clazz) {
                    for (Class type : this._model.getTypeRegistry().getTypeSpecialisations(clazz)) {
                        if (!type.isAnnotationPresent(ManagedObject.class)) continue;
                        responseMap.put(this.getAmqpName(type), operation.evaluateType(type));
                    }
                }
            } else if (MANAGEMENT_TYPE.equals(entityType)) {
                responseMap.put(entityType, selfValue);
            }
        } else {
            for (Map.Entry<String, Class<? extends ConfiguredObject>> entry : this._managedTypes.entrySet()) {
                responseMap.put(entry.getKey(), operation.evaluateType(entry.getValue()));
            }
            responseMap.put(MANAGEMENT_TYPE, selfValue);
        }
        return responseMap;
    }

    private Map<String, List<String>> performGetTypes(Map<String, Object> header) {
        return this.performManagementOperation(header, clazz -> {
            Class category = ConfiguredObjectTypeRegistry.getCategory((Class)clazz);
            if (category == clazz) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.getAmqpName(category));
        }, Collections.emptyList());
    }

    private Map<String, List<String>> performGetAttributes(Map<String, Object> headers) {
        return this.performManagementOperation(headers, clazz -> new ArrayList(this._model.getTypeRegistry().getAttributeNames(clazz)), Collections.emptyList());
    }

    private Map<String, Map<String, List<String>>> performGetOperations(Map<String, Object> headers) {
        HashMap managementOperations = new HashMap();
        return this.performManagementOperation(headers, clazz -> {
            Map operations = this._model.getTypeRegistry().getOperations(clazz);
            HashMap result = new HashMap();
            for (Map.Entry operation : operations.entrySet()) {
                ArrayList<String> arguments = new ArrayList<String>();
                for (OperationParameter param : ((ConfiguredObjectOperation)operation.getValue()).getParameters()) {
                    arguments.add(param.getName());
                }
                result.put(operation.getKey(), arguments);
            }
            return result;
        }, managementOperations);
    }

    public synchronized <T extends ConsumerTarget<T>> ManagementNodeConsumer<T> addConsumer(T target, FilterManager filters, Class<? extends ServerMessage> messageClass, String consumerName, EnumSet<ConsumerOption> options, Integer priority) {
        ManagementNodeConsumer<T> managementNodeConsumer = new ManagementNodeConsumer<T>(consumerName, this, target);
        target.consumerAdded(managementNodeConsumer);
        this._consumers.add(managementNodeConsumer);
        return managementNodeConsumer;
    }

    public synchronized Collection<ManagementNodeConsumer> getConsumers() {
        return Collections.unmodifiableCollection(this._consumers);
    }

    public boolean verifySessionAccess(AMQPSession<?, ?> session) {
        return true;
    }

    public NamedAddressSpace getAddressSpace() {
        return this._addressSpace;
    }

    public void authorisePublish(SecurityToken token, Map<String, Object> arguments) throws AccessControlException {
    }

    public String getName() {
        return MANAGEMENT_NODE_NAME;
    }

    public UUID getId() {
        return this._id;
    }

    public MessageDurability getMessageDurability() {
        return MessageDurability.NEVER;
    }

    void unregisterConsumer(ManagementNodeConsumer managementNodeConsumer) {
        this._consumers.remove(managementNodeConsumer);
    }

    public MessageSource.MessageConversionExceptionHandlingPolicy getMessageConversionExceptionHandlingPolicy() {
        return MessageSource.MessageConversionExceptionHandlingPolicy.CLOSE;
    }

    private AmqpConnectionMetaData getCallerConnectionMetaData() {
        Subject currentSubject = Subject.getSubject(AccessController.getContext());
        Set<ConnectionPrincipal> connectionPrincipals = currentSubject.getPrincipals(ConnectionPrincipal.class);
        if (connectionPrincipals.isEmpty()) {
            throw new IllegalStateException("Cannot find connection principal on calling thread");
        }
        ConnectionPrincipal principal = connectionPrincipals.iterator().next();
        return principal.getConnectionMetaData();
    }

    private static interface TypeOperation<T> {
        public T evaluateType(Class<? extends ConfiguredObject> var1);
    }

    private static class MutableMessageHeader
    implements AMQMessageHeader {
        private final LinkedHashMap<String, Object> _headers = new LinkedHashMap();
        private String _correlationId;
        private String _messageId;

        private MutableMessageHeader() {
        }

        void setCorrelationId(String correlationId) {
            this._correlationId = correlationId;
        }

        void setMessageId(String messageId) {
            this._messageId = messageId;
        }

        public String getCorrelationId() {
            return this._correlationId;
        }

        public long getExpiration() {
            return 0L;
        }

        public String getUserId() {
            return null;
        }

        public String getAppId() {
            return null;
        }

        public String getGroupId() {
            return null;
        }

        public String getMessageId() {
            return this._messageId;
        }

        public String getMimeType() {
            return null;
        }

        public String getEncoding() {
            return null;
        }

        public byte getPriority() {
            return 4;
        }

        public long getTimestamp() {
            return 0L;
        }

        public long getNotValidBefore() {
            return 0L;
        }

        public String getType() {
            return null;
        }

        public String getReplyTo() {
            return null;
        }

        public Object getHeader(String name) {
            return this._headers.get(name);
        }

        public boolean containsHeaders(Set<String> names) {
            return this._headers.keySet().containsAll(names);
        }

        public boolean containsHeader(String name) {
            return this._headers.containsKey(name);
        }

        public Collection<String> getHeaderNames() {
            return Collections.unmodifiableCollection(this._headers.keySet());
        }

        void setHeader(String header, Object value) {
            this._headers.put(header, value);
        }
    }

    private class ConsumedMessageInstance
    implements MessageInstance {
        private final ServerMessage _message;

        ConsumedMessageInstance(ServerMessage message) {
            this._message = message;
        }

        public int getDeliveryCount() {
            return 0;
        }

        public void incrementDeliveryCount() {
        }

        public void decrementDeliveryCount() {
        }

        public void addStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.EntryState> listener) {
        }

        public boolean removeStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.EntryState> listener) {
            return false;
        }

        public boolean acquiredByConsumer() {
            return false;
        }

        public MessageInstanceConsumer getAcquiringConsumer() {
            return null;
        }

        public MessageEnqueueRecord getEnqueueRecord() {
            return null;
        }

        public boolean isAcquiredBy(MessageInstanceConsumer<?> consumer) {
            return false;
        }

        public boolean removeAcquisitionFromConsumer(MessageInstanceConsumer<?> consumer) {
            return false;
        }

        public void setRedelivered() {
        }

        public boolean isRedelivered() {
            return false;
        }

        public void reject(MessageInstanceConsumer<?> consumer) {
        }

        public boolean isRejectedBy(MessageInstanceConsumer<?> consumer) {
            return false;
        }

        public boolean getDeliveredToConsumer() {
            return true;
        }

        public boolean expired() {
            return false;
        }

        public boolean acquire(MessageInstanceConsumer<?> consumer) {
            return false;
        }

        public boolean makeAcquisitionUnstealable(MessageInstanceConsumer<?> consumer) {
            return false;
        }

        public boolean makeAcquisitionStealable() {
            return false;
        }

        public int getMaximumDeliveryCount() {
            return 0;
        }

        public int routeToAlternate(Action<? super MessageInstance> action, ServerTransaction txn) {
            return 0;
        }

        public Filterable asFilterable() {
            return null;
        }

        public boolean isAvailable() {
            return false;
        }

        public boolean acquire() {
            return false;
        }

        public boolean isAcquired() {
            return false;
        }

        public void release() {
        }

        public void release(MessageInstanceConsumer<?> consumer) {
        }

        public void delete() {
        }

        public boolean isDeleted() {
            return false;
        }

        public boolean isHeld() {
            return false;
        }

        public boolean isPersistent() {
            return false;
        }

        public ServerMessage getMessage() {
            return this._message;
        }

        public InstanceProperties getInstanceProperties() {
            return CONSUMED_INSTANCE_PROPERTIES;
        }

        public TransactionLogResource getOwningResource() {
            return ManagementNode.this;
        }
    }

    private static interface StandardOperation {
        public String getName();

        public InternalMessage performOperation(Class<? extends ConfiguredObject> var1, InternalMessage var2);
    }
}

