/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.amqp;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.qpid.server.management.amqp.ManagementNode;

class ManagementInputConverter {
    private final ManagementNode _managementNode;

    ManagementInputConverter(ManagementNode managementNode) {
        this._managementNode = managementNode;
    }

    <T> T convert(Class<T> clazz, Object input) {
        if (input == null) {
            return null;
        }
        if (clazz.isAssignableFrom(input.getClass())) {
            return (T)input;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if (input instanceof Number) {
                return this.convertToNumberClass(clazz, (Number)input);
            }
            if (input instanceof String) {
                return this.convertToNumberClass(clazz, (String)input);
            }
            throw new IllegalArgumentException("Do not know how to convert type " + input.getClass().getName() + " to a number");
        }
        if (String.class == clazz) {
            return (T)input.toString();
        }
        if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return (T)objectMapper.readValue(input.toString(), clazz);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot convert String '" + input.toString() + "' to a " + clazz.getSimpleName());
            }
        }
        throw new IllegalArgumentException("Do not know how to convert to type " + clazz.getSimpleName());
    }

    private <N> N convertToNumberClass(Class<N> clazz, Number number) {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return (N)new Byte(number.byteValue());
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return (N)new Short(number.shortValue());
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return (N)new Integer(number.intValue());
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return (N)new Long(number.longValue());
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return (N)new Float(number.floatValue());
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return (N)new Double(number.doubleValue());
        }
        throw new IllegalArgumentException("Do not know how to convert to type " + clazz.getSimpleName());
    }

    private <N> N convertToNumberClass(Class<N> clazz, String number) {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return (N)Byte.valueOf(number);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return (N)Short.valueOf(number);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return (N)Integer.valueOf(number);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return (N)Long.valueOf(number);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return (N)Float.valueOf(number);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return (N)Double.valueOf(number);
        }
        throw new IllegalArgumentException("Do not know how to convert to type " + clazz.getSimpleName());
    }
}

