/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.amqp;

import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.management.amqp.ManagementNodeConsumer;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.StateChangeListener;

class ManagementResponse
implements MessageInstance {
    private final ManagementNodeConsumer _consumer;
    private final MessageReference _messageReference;
    private int _deliveryCount;
    private boolean _isRedelivered;
    private boolean _isDelivered;
    private boolean _isDeleted;
    private InternalMessage _message;

    ManagementResponse(ManagementNodeConsumer consumer, InternalMessage message) {
        this._consumer = consumer;
        this._message = message;
        this._messageReference = this._message.newReference((TransactionLogResource)consumer);
    }

    public int getDeliveryCount() {
        return 0;
    }

    public void incrementDeliveryCount() {
        ++this._deliveryCount;
    }

    public void decrementDeliveryCount() {
        --this._deliveryCount;
    }

    public void addStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.EntryState> listener) {
    }

    public boolean removeStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.EntryState> listener) {
        return false;
    }

    public boolean acquiredByConsumer() {
        return !this.isDeleted();
    }

    public ManagementNodeConsumer getAcquiringConsumer() {
        return this._consumer;
    }

    public MessageEnqueueRecord getEnqueueRecord() {
        return null;
    }

    public boolean isAcquiredBy(MessageInstanceConsumer<?> consumer) {
        return consumer == this._consumer && !this.isDeleted();
    }

    public boolean removeAcquisitionFromConsumer(MessageInstanceConsumer<?> consumer) {
        return consumer == this._consumer;
    }

    public void setRedelivered() {
        this._isRedelivered = true;
    }

    public boolean isRedelivered() {
        return this._isRedelivered;
    }

    public void reject(MessageInstanceConsumer<?> consumer) {
        this.delete();
    }

    public boolean isRejectedBy(MessageInstanceConsumer<?> consumer) {
        return false;
    }

    public boolean getDeliveredToConsumer() {
        return this._isDelivered;
    }

    public boolean expired() {
        return false;
    }

    public boolean acquire(MessageInstanceConsumer<?> consumer) {
        return false;
    }

    public boolean makeAcquisitionUnstealable(MessageInstanceConsumer<?> consumer) {
        return false;
    }

    public boolean makeAcquisitionStealable() {
        return false;
    }

    public int getMaximumDeliveryCount() {
        return 0;
    }

    public int routeToAlternate(Action<? super MessageInstance> action, ServerTransaction txn) {
        return 0;
    }

    public Filterable asFilterable() {
        return null;
    }

    public boolean isAvailable() {
        return false;
    }

    public boolean acquire() {
        return false;
    }

    public boolean isAcquired() {
        return !this.isDeleted();
    }

    public void release() {
        this.delete();
    }

    public void release(MessageInstanceConsumer<?> consumer) {
        this.release();
    }

    public void delete() {
        this._messageReference.release();
        this._isDeleted = true;
    }

    public boolean isDeleted() {
        return this._isDeleted;
    }

    public boolean isHeld() {
        return false;
    }

    public boolean isPersistent() {
        return false;
    }

    public ServerMessage getMessage() {
        return this._message;
    }

    public InstanceProperties getInstanceProperties() {
        return InstanceProperties.EMPTY;
    }

    public TransactionLogResource getOwningResource() {
        return this._consumer.getManagementNode();
    }

    public MessageReference getMessageReference() {
        return this._messageReference;
    }
}

