/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.amqp;

import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.apache.qpid.server.connection.SessionPrincipal;
import org.apache.qpid.server.exchange.DestinationReferrer;
import org.apache.qpid.server.management.amqp.ManagementAddressSpacePrincipal;
import org.apache.qpid.server.management.amqp.ManagementNode;
import org.apache.qpid.server.management.amqp.ProxyMessageSource;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageSender;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.plugin.SystemAddressSpaceCreator;
import org.apache.qpid.server.protocol.LinkModel;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.store.MemoryMessageStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.txn.DtxNotSupportedException;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.virtualhost.ConnectionEstablishmentPolicy;
import org.apache.qpid.server.virtualhost.LinkRegistryFactory;
import org.apache.qpid.server.virtualhost.LinkRegistryModel;
import org.apache.qpid.server.virtualhost.VirtualHostPropertiesNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementAddressSpace
implements NamedAddressSpace {
    public static final String MANAGEMENT_ADDRESS_SPACE_NAME = "$management";
    private static final String MANAGEMENT_NODE_NAME = "$management";
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementAddressSpace.class);
    private final String _name;
    private final SystemAddressSpaceCreator.AddressSpaceRegistry _addressSpaceRegistry;
    private final ManagementNode _managementNode;
    private final VirtualHostPropertiesNode _propertiesNode;
    private final MessageStore _messageStore;
    private final MessageDestination _defaultDestination = new DefaultDestination();
    private final List<AMQPConnection<?>> _connections = new CopyOnWriteArrayList();
    private final Broker<?> _broker;
    private final Principal _principal;
    private final UUID _id;
    private final ConcurrentMap<Object, ConcurrentMap<String, ProxyMessageSource>> _connectionSpecificDestinations = new ConcurrentHashMap<Object, ConcurrentMap<String, ProxyMessageSource>>();
    private final LinkRegistryModel _linkRegistry;

    public ManagementAddressSpace(SystemAddressSpaceCreator.AddressSpaceRegistry addressSpaceRegistry) {
        this("$management", addressSpaceRegistry);
    }

    public ManagementAddressSpace(String name, SystemAddressSpaceCreator.AddressSpaceRegistry addressSpaceRegistry) {
        this._name = name;
        this._addressSpaceRegistry = addressSpaceRegistry;
        this._broker = addressSpaceRegistry.getBroker();
        this._managementNode = new ManagementNode(this, (ConfiguredObject<?>)addressSpaceRegistry.getBroker());
        this._propertiesNode = new VirtualHostPropertiesNode((NamedAddressSpace)this);
        this._messageStore = new MemoryMessageStore();
        this._principal = new ManagementAddressSpacePrincipal(this);
        this._id = UUID.nameUUIDFromBytes((this._broker.getId().toString() + "/" + name).getBytes(StandardCharsets.UTF_8));
        Iterator linkRegistryFactories = new QpidServiceLoader().instancesOf(LinkRegistryFactory.class).iterator();
        if (linkRegistryFactories.hasNext()) {
            LinkRegistryFactory linkRegistryFactory = (LinkRegistryFactory)linkRegistryFactories.next();
            if (linkRegistryFactories.hasNext()) {
                throw new RuntimeException("Found multiple implementations of LinkRegistry");
            }
            this._linkRegistry = linkRegistryFactory.create((NamedAddressSpace)this);
            this._linkRegistry.open();
        } else {
            this._linkRegistry = null;
        }
    }

    public UUID getId() {
        return this._id;
    }

    public MessageSource getAttainedMessageSource(String name) {
        if (this._managementNode.getName().equals(name)) {
            return this._managementNode;
        }
        if (this._propertiesNode.getName().equals(name)) {
            return this._propertiesNode;
        }
        return this.getProxyNode(name);
    }

    public MessageDestination getAttainedMessageDestination(String name) {
        if (this._managementNode.getName().equals(name)) {
            return this._managementNode;
        }
        ProxyMessageSource connectionSpecificDestinations = this.getProxyNode(name);
        if (connectionSpecificDestinations != null) {
            return connectionSpecificDestinations;
        }
        return null;
    }

    public MessageDestination getAttainedMessageDestination(String name, boolean mayCreate) {
        return this.getAttainedMessageDestination(name);
    }

    ProxyMessageSource getProxyNode(String name) {
        Object connectionReference;
        Map connectionSpecificDestinations;
        LOGGER.debug("RG: looking for proxy source {}", (Object)name);
        Subject currentSubject = Subject.getSubject(AccessController.getContext());
        Set<SessionPrincipal> sessionPrincipals = currentSubject.getPrincipals(SessionPrincipal.class);
        if (!sessionPrincipals.isEmpty() && (connectionSpecificDestinations = (Map)this._connectionSpecificDestinations.get(connectionReference = sessionPrincipals.iterator().next().getSession().getConnectionReference())) != null) {
            LOGGER.debug("RG: ", (Object)connectionSpecificDestinations);
            return (ProxyMessageSource)connectionSpecificDestinations.get(name);
        }
        return null;
    }

    ManagementNode getManagementNode() {
        return this._managementNode;
    }

    public boolean registerConnection(AMQPConnection<?> connection, ConnectionEstablishmentPolicy connectionEstablishmentPolicy) {
        this._connections.add(connection);
        return true;
    }

    public void deregisterConnection(AMQPConnection<?> connection) {
        this._connections.remove(connection);
    }

    public String getRedirectHost(AmqpPort<?> port) {
        return null;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public boolean isActive() {
        return true;
    }

    public MessageDestination getDefaultDestination() {
        return this._defaultDestination;
    }

    public <T extends LinkModel> T getSendingLink(String remoteContainerId, String linkName) {
        return (T)this._linkRegistry.getSendingLink(remoteContainerId, linkName);
    }

    public <T extends LinkModel> T getReceivingLink(String remoteContainerId, String linkName) {
        return (T)this._linkRegistry.getReceivingLink(remoteContainerId, linkName);
    }

    public <T extends LinkModel> Collection<T> findSendingLinks(Pattern containerIdPattern, Pattern linkNamePattern) {
        return this._linkRegistry.findSendingLinks(containerIdPattern, linkNamePattern);
    }

    public <T extends LinkModel> void visitSendingLinks(LinkRegistryModel.LinkVisitor<T> visitor) {
        this._linkRegistry.visitSendingLinks(visitor);
    }

    public boolean authoriseCreateConnection(AMQPConnection<?> connection) {
        this._broker.authorise(Operation.PERFORM_ACTION((String)"manage"));
        return true;
    }

    public DtxRegistry getDtxRegistry() {
        throw new DtxNotSupportedException("Distributed Transactions are not supported within this address space");
    }

    public MessageStore getMessageStore() {
        return this._messageStore;
    }

    public <T extends MessageSource> T createMessageSource(Class<T> clazz, Map<String, Object> attributes) {
        if (clazz == MessageSource.class) {
            return (T)this.createProxyNode(attributes);
        }
        return null;
    }

    private ProxyMessageSource createProxyNode(Map<String, Object> attributes) {
        Subject currentSubject = Subject.getSubject(AccessController.getContext());
        Set<SessionPrincipal> sessionPrincipals = currentSubject.getPrincipals(SessionPrincipal.class);
        if (!sessionPrincipals.isEmpty()) {
            ProxyMessageSource proxyMessageSource = new ProxyMessageSource(this, attributes);
            AMQPSession session = sessionPrincipals.iterator().next().getSession();
            final Object connectionReference = session.getConnectionReference();
            ConcurrentHashMap<String, ProxyMessageSource> connectionSpecificDestinations = (ConcurrentHashMap<String, ProxyMessageSource>)this._connectionSpecificDestinations.get(connectionReference);
            if (connectionSpecificDestinations == null && this._connectionSpecificDestinations.putIfAbsent(connectionReference, connectionSpecificDestinations = new ConcurrentHashMap<String, ProxyMessageSource>()) == null) {
                session.getAMQPConnection().addDeleteTask(new Action(){

                    public void performAction(Object object) {
                        ManagementAddressSpace.this._connectionSpecificDestinations.remove(connectionReference);
                    }
                });
            }
            connectionSpecificDestinations.put(proxyMessageSource.getName(), proxyMessageSource);
            return proxyMessageSource;
        }
        return null;
    }

    void removeProxyMessageSource(Object connectionReference, String name) {
        ConcurrentMap connectionSpecificDestinations = (ConcurrentMap)this._connectionSpecificDestinations.get(connectionReference);
        if (connectionSpecificDestinations != null) {
            connectionSpecificDestinations.remove(name);
        }
    }

    public <T extends MessageDestination> T createMessageDestination(Class<T> clazz, Map<String, Object> attributes) {
        if (clazz == MessageDestination.class) {
            return (T)this.createProxyNode(attributes);
        }
        return null;
    }

    public boolean hasMessageSources() {
        return true;
    }

    public Collection<? extends Connection<?>> getConnections() {
        return Collections.unmodifiableList(this._connections);
    }

    public String getName() {
        return this._name;
    }

    public List<String> getGlobalAddressDomains() {
        return Collections.emptyList();
    }

    public String getLocalAddress(String routingAddress) {
        return routingAddress;
    }

    private class DefaultDestination
    implements MessageDestination {
        private DefaultDestination() {
        }

        public NamedAddressSpace getAddressSpace() {
            return ManagementAddressSpace.this;
        }

        public void authorisePublish(SecurityToken token, Map<String, Object> arguments) throws AccessControlException {
        }

        public String getName() {
            return "";
        }

        public <M extends ServerMessage<? extends StorableMessageMetaData>> RoutingResult<M> route(M message, String routingAddress, InstanceProperties instanceProperties) {
            MessageDestination destination = ManagementAddressSpace.this.getAttainedMessageDestination(routingAddress);
            if (destination == null || destination == this) {
                return new RoutingResult(message);
            }
            return destination.route(message, routingAddress, instanceProperties);
        }

        public boolean isDurable() {
            return true;
        }

        public void linkAdded(MessageSender sender, PublishingLink link) {
        }

        public void linkRemoved(MessageSender sender, PublishingLink link) {
        }

        public MessageDestination getAlternateBindingDestination() {
            return null;
        }

        public void removeReference(DestinationReferrer destinationReferrer) {
        }

        public void addReference(DestinationReferrer destinationReferrer) {
        }
    }
}

