/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin;

import java.lang.reflect.Type;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.ManagementConsoleMessages;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.filter.ForbiddingAuthorisationFilter;
import org.apache.qpid.server.management.plugin.filter.RedirectingAuthorisationFilter;
import org.apache.qpid.server.management.plugin.servlet.DefinedFileServlet;
import org.apache.qpid.server.management.plugin.servlet.FileServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.HelperServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.LogRecordsServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.LogoutServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.MessageContentServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.MessageServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.RestServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.SaslServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.StructureServlet;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.Plugin;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.adapter.AbstractPluginAdapter;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.util.MapValueConverter;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpManagement
extends AbstractPluginAdapter
implements HttpManagementConfiguration {
    private final Logger _logger = Logger.getLogger(HttpManagement.class);
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 600;
    public static final boolean DEFAULT_HTTP_BASIC_AUTHENTICATION_ENABLED = false;
    public static final boolean DEFAULT_HTTPS_BASIC_AUTHENTICATION_ENABLED = true;
    public static final boolean DEFAULT_HTTP_SASL_AUTHENTICATION_ENABLED = true;
    public static final boolean DEFAULT_HTTPS_SASL_AUTHENTICATION_ENABLED = true;
    public static final String DEFAULT_NAME = "httpManagement";
    public static final String TIME_OUT = "sessionTimeout";
    public static final String HTTP_BASIC_AUTHENTICATION_ENABLED = "httpBasicAuthenticationEnabled";
    public static final String HTTPS_BASIC_AUTHENTICATION_ENABLED = "httpsBasicAuthenticationEnabled";
    public static final String HTTP_SASL_AUTHENTICATION_ENABLED = "httpSaslAuthenticationEnabled";
    public static final String HTTPS_SASL_AUTHENTICATION_ENABLED = "httpsSaslAuthenticationEnabled";
    public static final String PLUGIN_TYPE = "MANAGEMENT-HTTP";
    private static final Collection<String> AVAILABLE_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Plugin.AVAILABLE_ATTRIBUTES){
        {
            this.add(HttpManagement.HTTP_BASIC_AUTHENTICATION_ENABLED);
            this.add(HttpManagement.HTTPS_BASIC_AUTHENTICATION_ENABLED);
            this.add(HttpManagement.HTTP_SASL_AUTHENTICATION_ENABLED);
            this.add(HttpManagement.HTTPS_SASL_AUTHENTICATION_ENABLED);
            this.add(HttpManagement.TIME_OUT);
            this.add("pluginType");
        }
    });
    private static final String OPERATIONAL_LOGGING_NAME = "Web";
    public static final Map<String, Object> DEFAULTS = Collections.unmodifiableMap(new HashMap<String, Object>(){
        {
            this.put(HttpManagement.HTTP_BASIC_AUTHENTICATION_ENABLED, false);
            this.put(HttpManagement.HTTPS_BASIC_AUTHENTICATION_ENABLED, true);
            this.put(HttpManagement.HTTP_SASL_AUTHENTICATION_ENABLED, true);
            this.put(HttpManagement.HTTPS_SASL_AUTHENTICATION_ENABLED, true);
            this.put(HttpManagement.TIME_OUT, 600);
            this.put("name", HttpManagement.DEFAULT_NAME);
        }
    });
    private static final Map<String, Type> ATTRIBUTE_TYPES = Collections.unmodifiableMap(new HashMap<String, Type>(){
        {
            this.put(HttpManagement.HTTP_BASIC_AUTHENTICATION_ENABLED, Boolean.class);
            this.put(HttpManagement.HTTPS_BASIC_AUTHENTICATION_ENABLED, Boolean.class);
            this.put(HttpManagement.HTTP_SASL_AUTHENTICATION_ENABLED, Boolean.class);
            this.put(HttpManagement.HTTPS_SASL_AUTHENTICATION_ENABLED, Boolean.class);
            this.put("name", String.class);
            this.put(HttpManagement.TIME_OUT, Integer.class);
            this.put("pluginType", String.class);
        }
    });
    private static final String JSESSIONID_COOKIE_PREFIX = "JSESSIONID_";
    private Server _server;

    public HttpManagement(UUID id, Broker broker, Map<String, Object> attributes) {
        super(id, DEFAULTS, MapValueConverter.convert(attributes, ATTRIBUTE_TYPES), broker);
    }

    protected boolean setState(State currentState, State desiredState) {
        if (desiredState == State.ACTIVE) {
            this.start();
            return true;
        }
        if (desiredState == State.STOPPED) {
            this.stop();
            return true;
        }
        return false;
    }

    private void start() {
        CurrentActor.get().message(ManagementConsoleMessages.STARTUP((String)OPERATIONAL_LOGGING_NAME));
        Collection<Port> httpPorts = this.getHttpPorts(this.getBroker().getPorts());
        this._server = this.createServer(httpPorts);
        try {
            this._server.start();
            this.logOperationalListenMessages(this._server);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start http management on ports " + httpPorts);
        }
        CurrentActor.get().message(ManagementConsoleMessages.READY((String)OPERATIONAL_LOGGING_NAME));
    }

    private void stop() {
        if (this._server != null) {
            try {
                this._server.stop();
                this.logOperationalShutdownMessage(this._server);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to stop http management on port " + this.getHttpPorts(this.getBroker().getPorts()));
            }
        }
        CurrentActor.get().message(ManagementConsoleMessages.STOPPED((String)OPERATIONAL_LOGGING_NAME));
    }

    int getSessionTimeout() {
        return (Integer)this.getAttribute(TIME_OUT);
    }

    private Server createServer(Collection<Port> ports) {
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("Starting up web server on " + ports));
        }
        Server server = new Server();
        int lastPort = -1;
        for (Port port : ports) {
            if (State.QUIESCED.equals((Object)port.getActualState())) continue;
            SelectChannelConnector connector = null;
            Collection transports = port.getTransports();
            if (!transports.contains(Transport.SSL)) {
                connector = new SelectChannelConnector();
            } else if (transports.contains(Transport.SSL)) {
                KeyStore keyStore = port.getKeyStore();
                if (keyStore == null) {
                    throw new IllegalConfigurationException("Key store is not configured. Cannot start management on HTTPS port without keystore");
                }
                String keyStorePath = (String)keyStore.getAttribute("path");
                String keyStorePassword = keyStore.getPassword();
                SslContextFactory factory = new SslContextFactory();
                factory.setKeyStorePath(keyStorePath);
                factory.setKeyStorePassword(keyStorePassword);
                connector = new SslSocketConnector(factory);
            } else {
                throw new IllegalArgumentException("Unexpected transport on port " + port.getName() + ":" + transports);
            }
            lastPort = port.getPort();
            connector.setPort(port.getPort());
            server.addConnector((Connector)connector);
        }
        ServletContextHandler root = new ServletContextHandler(1);
        root.setContextPath("/");
        server.setHandler((Handler)root);
        root.getServletContext().setAttribute("Qpid.broker", (Object)this.getBroker());
        root.getServletContext().setAttribute("Qpid.managementConfiguration", (Object)this);
        FilterHolder restAuthorizationFilter = new FilterHolder((Filter)new ForbiddingAuthorisationFilter());
        restAuthorizationFilter.setInitParameter(ForbiddingAuthorisationFilter.INIT_PARAM_ALLOWED, "/rest/sasl");
        root.addFilter(restAuthorizationFilter, "/rest/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(new FilterHolder((Filter)new RedirectingAuthorisationFilter()), "/management", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(new FilterHolder((Filter)new RedirectingAuthorisationFilter()), "/index.html", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(new FilterHolder((Filter)new RedirectingAuthorisationFilter()), "/", EnumSet.of(DispatcherType.REQUEST));
        this.addRestServlet(root, "broker", new Class[0]);
        this.addRestServlet(root, "virtualhost", VirtualHost.class);
        this.addRestServlet(root, "authenticationprovider", AuthenticationProvider.class);
        this.addRestServlet(root, "accesscontrolprovider", AccessControlProvider.class);
        this.addRestServlet(root, "user", AuthenticationProvider.class, User.class);
        this.addRestServlet(root, "groupprovider", GroupProvider.class);
        this.addRestServlet(root, "group", GroupProvider.class, Group.class);
        this.addRestServlet(root, "groupmember", GroupProvider.class, Group.class, GroupMember.class);
        this.addRestServlet(root, "exchange", VirtualHost.class, Exchange.class);
        this.addRestServlet(root, "queue", VirtualHost.class, Queue.class);
        this.addRestServlet(root, "connection", VirtualHost.class, Connection.class);
        this.addRestServlet(root, "binding", VirtualHost.class, Exchange.class, Queue.class, Binding.class);
        this.addRestServlet(root, "port", Port.class);
        this.addRestServlet(root, "session", VirtualHost.class, Connection.class, Session.class);
        this.addRestServlet(root, "keystore", KeyStore.class);
        this.addRestServlet(root, "truststore", TrustStore.class);
        this.addRestServlet(root, "plugin", Plugin.class);
        root.addServlet(new ServletHolder((Servlet)new StructureServlet()), "/rest/structure");
        root.addServlet(new ServletHolder((Servlet)new MessageServlet()), "/rest/message/*");
        root.addServlet(new ServletHolder((Servlet)new MessageContentServlet()), "/rest/message-content/*");
        root.addServlet(new ServletHolder((Servlet)new LogRecordsServlet()), "/rest/logrecords");
        root.addServlet(new ServletHolder((Servlet)new SaslServlet()), "/rest/sasl");
        root.addServlet(new ServletHolder((Servlet)new DefinedFileServlet("index.html")), "/management");
        root.addServlet(new ServletHolder((Servlet)new DefinedFileServlet("index.html")), "/");
        root.addServlet(new ServletHolder((Servlet)new LogoutServlet()), "/logout");
        root.addServlet(new ServletHolder((Servlet)FileServlet.INSTANCE), "*.js");
        root.addServlet(new ServletHolder((Servlet)FileServlet.INSTANCE), "*.css");
        root.addServlet(new ServletHolder((Servlet)FileServlet.INSTANCE), "*.html");
        root.addServlet(new ServletHolder((Servlet)FileServlet.INSTANCE), "*.png");
        root.addServlet(new ServletHolder((Servlet)FileServlet.INSTANCE), "*.gif");
        root.addServlet(new ServletHolder((Servlet)FileServlet.INSTANCE), "*.jpg");
        root.addServlet(new ServletHolder((Servlet)FileServlet.INSTANCE), "*.jpeg");
        root.addServlet(new ServletHolder((Servlet)FileServlet.INSTANCE), "*.json");
        root.addServlet(new ServletHolder((Servlet)FileServlet.INSTANCE), "*.txt");
        root.addServlet(new ServletHolder((Servlet)FileServlet.INSTANCE), "*.xsl");
        root.addServlet(new ServletHolder((Servlet)new HelperServlet()), "/rest/helper");
        SessionManager sessionManager = root.getSessionHandler().getSessionManager();
        sessionManager.setSessionCookie(JSESSIONID_COOKIE_PREFIX + lastPort);
        sessionManager.setMaxInactiveInterval(((Integer)this.getAttribute(TIME_OUT)).intValue());
        return server;
    }

    private void addRestServlet(ServletContextHandler root, String name, Class<? extends ConfiguredObject> ... hierarchy) {
        root.addServlet(new ServletHolder((Servlet)new RestServlet(hierarchy)), "/rest/" + name + "/*");
    }

    private void logOperationalListenMessages(Server server) {
        Connector[] connectors;
        for (Connector connector : connectors = server.getConnectors()) {
            SslContextFactory sslContextFactory;
            CurrentActor.get().message(ManagementConsoleMessages.LISTENING((String)this.stringifyConnectorScheme(connector), (Number)connector.getPort()));
            if (!(connector instanceof SslSocketConnector) || (sslContextFactory = ((SslSocketConnector)connector).getSslContextFactory()) == null || sslContextFactory.getKeyStorePath() == null) continue;
            CurrentActor.get().message(ManagementConsoleMessages.SSL_KEYSTORE((String)sslContextFactory.getKeyStorePath()));
        }
    }

    private void logOperationalShutdownMessage(Server server) {
        Connector[] connectors;
        for (Connector connector : connectors = server.getConnectors()) {
            CurrentActor.get().message(ManagementConsoleMessages.SHUTTING_DOWN((String)this.stringifyConnectorScheme(connector), (Number)connector.getPort()));
        }
    }

    private String stringifyConnectorScheme(Connector connector) {
        return connector instanceof SslSocketConnector ? "HTTPS" : "HTTP";
    }

    private Collection<Port> getHttpPorts(Collection<Port> ports) {
        HashSet<Port> httpPorts = new HashSet<Port>();
        for (Port port : ports) {
            if (!port.getProtocols().contains(Protocol.HTTP)) continue;
            httpPorts.add(port);
        }
        return httpPorts;
    }

    public String getName() {
        return (String)this.getAttribute("name");
    }

    public Collection<String> getAttributeNames() {
        return Collections.unmodifiableCollection(AVAILABLE_ATTRIBUTES);
    }

    @Override
    public boolean isHttpsSaslAuthenticationEnabled() {
        return (Boolean)this.getAttribute(HTTPS_SASL_AUTHENTICATION_ENABLED);
    }

    @Override
    public boolean isHttpSaslAuthenticationEnabled() {
        return (Boolean)this.getAttribute(HTTP_SASL_AUTHENTICATION_ENABLED);
    }

    @Override
    public boolean isHttpsBasicAuthenticationEnabled() {
        return (Boolean)this.getAttribute(HTTPS_BASIC_AUTHENTICATION_ENABLED);
    }

    @Override
    public boolean isHttpBasicAuthenticationEnabled() {
        return (Boolean)this.getAttribute(HTTP_BASIC_AUTHENTICATION_ENABLED);
    }

    @Override
    public SubjectCreator getSubjectCreator(SocketAddress localAddress) {
        return this.getBroker().getSubjectCreator(localAddress);
    }

    protected void changeAttributes(Map<String, Object> attributes) {
        Map convertedAttributes = MapValueConverter.convert(attributes, ATTRIBUTE_TYPES);
        this.validateAttributes(convertedAttributes);
        super.changeAttributes(convertedAttributes);
    }

    private void validateAttributes(Map<String, Object> convertedAttributes) {
        Number value;
        if (convertedAttributes.containsKey("name")) {
            String newName = (String)convertedAttributes.get("name");
            if (!this.getName().equals(newName)) {
                throw new IllegalConfigurationException("Changing the name of http management plugin is not allowed");
            }
        }
        if (convertedAttributes.containsKey(TIME_OUT) && ((value = (Number)convertedAttributes.get(TIME_OUT)) == null || value.longValue() < 0L)) {
            throw new IllegalConfigurationException("Only positive integer value can be specified for the session time out attribute");
        }
    }
}

