/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessControlException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.HttpManagementActor;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.session.LoginLogoutReporter;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;

public class HttpManagementUtil {
    public static final String ATTR_BROKER = "Qpid.broker";
    public static final String ATTR_MANAGEMENT_CONFIGURATION = "Qpid.managementConfiguration";
    public static final String ENTRY_POINT_PATH = "/management";
    private static final String ATTR_LOGIN_LOGOUT_REPORTER = "Qpid.loginLogoutReporter";
    private static final String ATTR_SUBJECT = "Qpid.subject";
    private static final String ATTR_LOG_ACTOR = "Qpid.logActor";

    public static Broker getBroker(ServletContext servletContext) {
        return (Broker)servletContext.getAttribute(ATTR_BROKER);
    }

    public static HttpManagementConfiguration getManagementConfiguration(ServletContext servletContext) {
        return (HttpManagementConfiguration)servletContext.getAttribute(ATTR_MANAGEMENT_CONFIGURATION);
    }

    public static SocketAddress getSocketAddress(HttpServletRequest request) {
        return InetSocketAddress.createUnresolved(request.getServerName(), request.getServerPort());
    }

    public static Subject getAuthorisedSubject(HttpSession session) {
        return (Subject)session.getAttribute(ATTR_SUBJECT);
    }

    public static void checkRequestAuthenticatedAndAccessAuthorized(HttpServletRequest request, Broker broker, HttpManagementConfiguration managementConfig) {
        HttpSession session = request.getSession();
        Subject subject = HttpManagementUtil.getAuthorisedSubject(session);
        if (subject == null) {
            subject = HttpManagementUtil.tryToAuthenticate(request, managementConfig);
            if (subject == null) {
                throw new SecurityException("Only authenticated users can access the management interface");
            }
            HttpManagementActor actor = HttpManagementUtil.createHttpManagementActor(broker, request);
            if (HttpManagementUtil.hasAccessToManagement(broker.getSecurityManager(), subject, (LogActor)actor)) {
                HttpManagementUtil.saveAuthorisedSubject(session, subject, (LogActor)actor);
            } else {
                throw new AccessControlException("Access to the management interface denied");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAccessToManagement(final SecurityManager securityManager, Subject subject, LogActor actor) {
        SecurityManager.setThreadSubject((Subject)subject);
        CurrentActor.set((LogActor)actor);
        try {
            boolean bl = Subject.doAs(subject, new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return securityManager.accessManagement();
                }
            });
            return bl;
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException("Unable to perform access check", e);
        }
        finally {
            try {
                CurrentActor.remove();
            }
            finally {
                SecurityManager.setThreadSubject(null);
            }
        }
    }

    public static HttpManagementActor getOrCreateAndCacheLogActor(HttpServletRequest request, Broker broker) {
        HttpSession session = request.getSession();
        HttpManagementActor actor = (HttpManagementActor)session.getAttribute(ATTR_LOG_ACTOR);
        if (actor == null) {
            actor = HttpManagementUtil.createHttpManagementActor(broker, request);
            session.setAttribute(ATTR_LOG_ACTOR, (Object)actor);
        }
        return actor;
    }

    public static void saveAuthorisedSubject(HttpSession session, Subject subject, LogActor logActor) {
        session.setAttribute(ATTR_SUBJECT, (Object)subject);
        session.setAttribute(ATTR_LOGIN_LOGOUT_REPORTER, (Object)new LoginLogoutReporter(logActor, subject));
    }

    private static Subject tryToAuthenticate(HttpServletRequest request, HttpManagementConfiguration managementConfig) {
        Subject subject = null;
        SocketAddress localAddress = HttpManagementUtil.getSocketAddress(request);
        SubjectCreator subjectCreator = managementConfig.getSubjectCreator(localAddress);
        String remoteUser = request.getRemoteUser();
        if (remoteUser != null || subjectCreator.isAnonymousAuthenticationAllowed()) {
            subject = HttpManagementUtil.authenticateUser(subjectCreator, remoteUser, null);
        } else {
            String[] tokens;
            String header = request.getHeader("Authorization");
            if (header != null && (tokens = header.split("\\s")).length >= 2 && "BASIC".equalsIgnoreCase(tokens[0])) {
                String base64UsernameAndPassword;
                String[] credentials;
                boolean isBasicAuthSupported = false;
                isBasicAuthSupported = request.isSecure() ? managementConfig.isHttpsBasicAuthenticationEnabled() : managementConfig.isHttpBasicAuthenticationEnabled();
                if (isBasicAuthSupported && (credentials = new String(Base64.decodeBase64((byte[])(base64UsernameAndPassword = tokens[1]).getBytes())).split(":", 2)).length == 2) {
                    subject = HttpManagementUtil.authenticateUser(subjectCreator, credentials[0], credentials[1]);
                }
            }
        }
        return subject;
    }

    private static Subject authenticateUser(SubjectCreator subjectCreator, String username, String password) {
        SubjectAuthenticationResult authResult = subjectCreator.authenticate(username, password);
        if (authResult.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
            return authResult.getSubject();
        }
        return null;
    }

    private static HttpManagementActor createHttpManagementActor(Broker broker, HttpServletRequest request) {
        return new HttpManagementActor(broker.getRootMessageLogger(), request.getRemoteAddr(), request.getRemotePort());
    }
}

