/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.filter;

import java.io.IOException;
import java.security.AccessControlException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.model.Broker;

public class ForbiddingAuthorisationFilter
implements Filter {
    public static String INIT_PARAM_ALLOWED = "allowed";
    private String _allowed = null;
    private Broker _broker;
    private HttpManagementConfiguration _managementConfiguration;

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        String allowed = config.getInitParameter(INIT_PARAM_ALLOWED);
        if (allowed != null) {
            this._allowed = allowed;
        }
        ServletContext servletContext = config.getServletContext();
        this._broker = HttpManagementUtil.getBroker(servletContext);
        this._managementConfiguration = HttpManagementUtil.getManagementConfiguration(servletContext);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String servletPath = httpRequest.getServletPath();
        if (this._allowed == null || "".equals(this._allowed) || servletPath.indexOf(this._allowed) == -1) {
            try {
                HttpManagementUtil.checkRequestAuthenticatedAndAccessAuthorized(httpRequest, this._broker, this._managementConfiguration);
            }
            catch (AccessControlException e) {
                httpResponse.sendError(403);
                return;
            }
            catch (SecurityException e) {
                httpResponse.sendError(401);
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

