/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.model.Broker;

public class RedirectingAuthorisationFilter
implements Filter {
    public static String DEFAULT_LOGIN_URL = "login.html";
    public static String INIT_PARAM_LOGIN_URL = "login-url";
    private String _loginUrl = DEFAULT_LOGIN_URL;
    private Broker _broker;
    private HttpManagementConfiguration _managementConfiguration;

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        String loginlUrl = config.getInitParameter(INIT_PARAM_LOGIN_URL);
        if (loginlUrl != null) {
            this._loginUrl = loginlUrl;
        }
        ServletContext servletContext = config.getServletContext();
        this._broker = HttpManagementUtil.getBroker(servletContext);
        this._managementConfiguration = HttpManagementUtil.getManagementConfiguration(servletContext);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            HttpManagementUtil.checkRequestAuthenticatedAndAccessAuthorized(httpRequest, this._broker, this._managementConfiguration);
            chain.doFilter(request, response);
        }
        catch (SecurityException e) {
            httpResponse.sendRedirect(this._loginUrl);
        }
    }
}

