/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.HttpManagementActor;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.security.SecurityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(AbstractServlet.class);
    private Broker _broker;
    private HttpManagementConfiguration _managementConfiguration;

    protected AbstractServlet() {
    }

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        this._broker = HttpManagementUtil.getBroker(servletContext);
        this._managementConfiguration = HttpManagementUtil.getManagementConfiguration(servletContext);
        super.init();
    }

    protected final void doGet(final HttpServletRequest request, final HttpServletResponse resp) {
        this.doWithSubjectAndActor(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractServlet.this.doGetWithSubjectAndActor(request, resp);
                return null;
            }
        }, request, resp);
    }

    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        throw new UnsupportedOperationException("GET not supported by this servlet");
    }

    protected final void doPost(final HttpServletRequest request, final HttpServletResponse resp) {
        this.doWithSubjectAndActor(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractServlet.this.doPostWithSubjectAndActor(request, resp);
                return null;
            }
        }, request, resp);
    }

    protected void doPostWithSubjectAndActor(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new UnsupportedOperationException("POST not supported by this servlet");
    }

    protected final void doPut(final HttpServletRequest request, final HttpServletResponse resp) {
        this.doWithSubjectAndActor(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractServlet.this.doPutWithSubjectAndActor(request, resp);
                return null;
            }
        }, request, resp);
    }

    protected void doPutWithSubjectAndActor(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new UnsupportedOperationException("PUT not supported by this servlet");
    }

    protected final void doDelete(final HttpServletRequest request, final HttpServletResponse resp) throws ServletException, IOException {
        this.doWithSubjectAndActor(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractServlet.this.doDeleteWithSubjectAndActor(request, resp);
                return null;
            }
        }, request, resp);
    }

    protected void doDeleteWithSubjectAndActor(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new UnsupportedOperationException("DELETE not supported by this servlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithSubjectAndActor(PrivilegedExceptionAction<Void> privilegedExceptionAction, HttpServletRequest request, HttpServletResponse resp) {
        Subject subject;
        try {
            subject = this.getAuthorisedSubject(request);
        }
        catch (SecurityException e) {
            this.sendError(resp, 401);
            return;
        }
        SecurityManager.setThreadSubject((Subject)subject);
        try {
            HttpManagementActor logActor = HttpManagementUtil.getOrCreateAndCacheLogActor(request, this._broker);
            CurrentActor.set((LogActor)logActor);
            try {
                Subject.doAs(subject, privilegedExceptionAction);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)"Unable to perform action", (Throwable)e);
                throw e;
            }
            catch (PrivilegedActionException e) {
                LOGGER.error((Object)"Unable to perform action", (Throwable)e);
                throw new RuntimeException(e.getCause());
            }
            finally {
                CurrentActor.remove();
            }
        }
        finally {
            try {
                SecurityManager.setThreadSubject(null);
            }
            finally {
                AMQShortString.clearLocalCache();
            }
        }
    }

    protected Subject getAuthorisedSubject(HttpServletRequest request) {
        Subject subject = HttpManagementUtil.getAuthorisedSubject(request.getSession());
        if (subject == null) {
            throw new SecurityException("Access to management rest interfaces is denied for un-authorised user");
        }
        return subject;
    }

    protected Broker getBroker() {
        return this._broker;
    }

    protected HttpManagementConfiguration getManagementConfiguration() {
        return this._managementConfiguration;
    }

    protected void sendError(HttpServletResponse resp, int errorCode) {
        try {
            resp.sendError(errorCode);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send error response code " + errorCode, e);
        }
    }
}

