/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.Statistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguredObjectToMapConverter {
    public static final String STATISTICS_MAP_KEY = "statistics";
    private Model _model = Model.getInstance();

    public Map<String, Object> convertObjectToMap(ConfiguredObject confObject, Class<? extends ConfiguredObject> clazz, int depth) {
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        this.incorporateAttributesIntoMap(confObject, object);
        this.incorporateStatisticsIntoMap(confObject, object);
        if (depth > 0) {
            this.incorporateChildrenIntoMap(confObject, clazz, depth, object);
        }
        return object;
    }

    void setModel(Model model) {
        this._model = model;
    }

    private void incorporateAttributesIntoMap(ConfiguredObject confObject, Map<String, Object> object) {
        for (String name : confObject.getAttributeNames()) {
            Object value = confObject.getAttribute(name);
            if (value instanceof ConfiguredObject) {
                object.put(name, ((ConfiguredObject)value).getName());
                continue;
            }
            if (value == null) continue;
            object.put(name, value);
        }
    }

    private void incorporateStatisticsIntoMap(ConfiguredObject confObject, Map<String, Object> object) {
        Statistics statistics = confObject.getStatistics();
        HashMap<String, Object> statMap = new HashMap<String, Object>();
        if (statistics != null) {
            for (String name : statistics.getStatisticNames()) {
                Object value = statistics.getStatistic(name);
                if (value == null) continue;
                statMap.put(name, value);
            }
            if (!statMap.isEmpty()) {
                object.put(STATISTICS_MAP_KEY, statMap);
            }
        }
    }

    private void incorporateChildrenIntoMap(ConfiguredObject confObject, Class<? extends ConfiguredObject> clazz, int depth, Map<String, Object> object) {
        for (Class childClass : this._model.getChildTypes(clazz)) {
            Collection children = confObject.getChildren(childClass);
            if (children == null) continue;
            ArrayList<Map<String, Object>> childObjects = new ArrayList<Map<String, Object>>();
            for (ConfiguredObject child : children) {
                childObjects.add(this.convertObjectToMap(child, childClass, depth - 1));
            }
            if (childObjects.isEmpty()) continue;
            object.put(childClass.getSimpleName().toLowerCase() + "s", childObjects);
        }
    }
}

