/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.Action;
import org.apache.qpid.server.management.plugin.servlet.rest.PluginClassProviderAction;
import org.apache.qpid.server.management.plugin.servlet.rest.action.ListAccessControlProviderAttributes;
import org.apache.qpid.server.management.plugin.servlet.rest.action.ListAuthenticationProviderAttributes;
import org.apache.qpid.server.management.plugin.servlet.rest.action.ListBrokerAttribute;
import org.apache.qpid.server.management.plugin.servlet.rest.action.ListGroupProviderAttributes;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class HelperServlet
extends AbstractServlet {
    private static final String PARAM_ACTION = "action";
    private Map<String, Action> _actions;
    private ObjectMapper _mapper = new ObjectMapper();

    public HelperServlet() {
        this._mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        Action[] supportedActions = new Action[]{new ListAuthenticationProviderAttributes(), new ListBrokerAttribute("supportedVirtualHostStoreTypes", "ListMessageStoreTypes"), new ListBrokerAttribute("supportedVirtualHostTypes", "ListVirtualHostTypes"), new ListGroupProviderAttributes(), new ListAccessControlProviderAttributes(), new PluginClassProviderAction()};
        this._actions = new HashMap<String, Action>();
        for (Action action : supportedActions) {
            this._actions.put(action.getName(), action);
        }
    }

    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.perform(request, response);
    }

    protected void doPostWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.perform(request, response);
    }

    private void perform(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String actionName = request.getParameter(PARAM_ACTION);
        Action action = this._actions.get(actionName);
        if (action == null) {
            response.setStatus(404);
            return;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            if (values.length == 1) {
                parameters.put(name, values[0]);
                continue;
            }
            parameters.put(name, values);
        }
        Object output = action.perform(parameters, this.getBroker());
        if (output == null) {
            response.setStatus(404);
            return;
        }
        response.setContentType("application/json");
        BufferedWriter writer = new BufferedWriter(response.getWriter());
        this._mapper.writeValue((Writer)writer, output);
        response.setStatus(200);
    }
}

