/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.logging.LogRecorder;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogRecordsServlet
extends AbstractServlet {
    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json");
        response.setStatus(200);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        ArrayList<Map<String, Object>> logRecords = new ArrayList<Map<String, Object>>();
        LogRecorder logRecorder = this.getBroker().getLogRecorder();
        for (LogRecorder.Record record : logRecorder) {
            logRecords.add(this.logRecordToObject(record));
        }
        PrintWriter writer = response.getWriter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        mapper.writeValue((Writer)writer, logRecords);
        response.setStatus(200);
    }

    private Map<String, Object> logRecordToObject(LogRecorder.Record record) {
        LinkedHashMap<String, Object> recordMap = new LinkedHashMap<String, Object>();
        recordMap.put("id", record.getId());
        recordMap.put("timestamp", record.getTimestamp());
        recordMap.put("level", record.getLevel());
        recordMap.put("thread", record.getThreadName());
        recordMap.put("logger", record.getLogger());
        recordMap.put("message", record.getMessage());
        return recordMap;
    }
}

