/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryVisitor;

public class MessageContentServlet
extends AbstractServlet {
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getPathInfo() != null && request.getPathInfo().length() > 0 && request.getPathInfo().substring(1).split("/").length > 2) {
            this.getMessageContent(request, response);
        }
    }

    private void getMessageContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Queue queue = this.getQueueFromRequest(request);
        String[] path = request.getPathInfo().substring(1).split("/");
        MessageFinder finder = new MessageFinder(Long.parseLong(path[2]));
        queue.visit((QueueEntryVisitor)finder);
        if (finder.isFound()) {
            response.setContentType(finder.getMimeType());
            response.setContentLength((int)finder.getSize());
            response.getOutputStream().write(finder.getContent());
        }
    }

    private Queue getQueueFromRequest(HttpServletRequest request) {
        ArrayList<String> names = new ArrayList<String>();
        if (request.getPathInfo() != null && request.getPathInfo().length() > 0) {
            String path = request.getPathInfo().substring(1);
            names.addAll(Arrays.asList(path.split("/")));
        }
        String vhostName = (String)names.get(0);
        String queueName = (String)names.get(1);
        VirtualHost vhost = null;
        for (VirtualHost vh : this.getBroker().getVirtualHosts()) {
            if (!vh.getName().equals(vhostName)) continue;
            vhost = vh;
            break;
        }
        return this.getQueueFromVirtualHost(queueName, vhost);
    }

    private Queue getQueueFromVirtualHost(String queueName, VirtualHost vhost) {
        Queue queue = null;
        for (Queue q : vhost.getQueues()) {
            if (!q.getName().equals(queueName)) continue;
            queue = q;
            break;
        }
        return queue;
    }

    private class MessageFinder
    implements QueueEntryVisitor {
        private final long _messageNumber;
        private String _mimeType;
        private long _size;
        private byte[] _content;
        private boolean _found;

        private MessageFinder(long messageNumber) {
            this._messageNumber = messageNumber;
        }

        public boolean visit(QueueEntry entry) {
            ServerMessage message = entry.getMessage();
            if (message != null && this._messageNumber == message.getMessageNumber()) {
                MessageReference reference = message.newReference();
                this._mimeType = message.getMessageHeader().getMimeType();
                this._size = message.getSize();
                this._content = new byte[(int)this._size];
                this._found = true;
                message.getContent(ByteBuffer.wrap(this._content), 0);
                reference.release();
                return true;
            }
            return false;
        }

        public String getMimeType() {
            return this._mimeType;
        }

        public long getSize() {
            return this._size;
        }

        public byte[] getContent() {
            return this._content;
        }

        public boolean isFound() {
            return this._found;
        }
    }
}

