/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.subscription.Subscription;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageServlet
extends AbstractServlet {
    private static final Logger LOGGER = Logger.getLogger(MessageServlet.class);

    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getPathInfo() != null && request.getPathInfo().length() > 0 && request.getPathInfo().substring(1).split("/").length > 2) {
            this.getMessageContent(request, response);
        } else {
            this.getMessageList(request, response);
        }
    }

    private void getMessageContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Queue queue = this.getQueueFromRequest(request);
        String[] path = request.getPathInfo().substring(1).split("/");
        MessageFinder messageFinder = new MessageFinder(Long.parseLong(path[2]));
        queue.visit((QueueEntryVisitor)messageFinder);
        response.setStatus(200);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        mapper.writeValue((Writer)writer, messageFinder.getMessageObject());
    }

    private void getMessageList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Queue queue = this.getQueueFromRequest(request);
        int first = -1;
        int last = -1;
        String range = request.getHeader("Range");
        if (range != null) {
            String[] boundaries = range.split("=")[1].split("-");
            first = Integer.parseInt(boundaries[0]);
            last = Integer.parseInt(boundaries[1]);
        }
        MessageCollector messageCollector = new MessageCollector(first, last);
        queue.visit((QueueEntryVisitor)messageCollector);
        response.setContentType("application/json");
        List<Map<String, Object>> messages = messageCollector.getMessages();
        int queueSize = ((Number)queue.getStatistics().getStatistic("queueDepthMessages")).intValue();
        String min = messages.isEmpty() ? "0" : messages.get(0).get("position").toString();
        String max = messages.isEmpty() ? "0" : messages.get(messages.size() - 1).get("position").toString();
        response.setHeader("Content-Range", min + "-" + max + "/" + queueSize);
        response.setStatus(200);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        PrintWriter writer = response.getWriter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        mapper.writeValue((Writer)writer, messages);
    }

    private Queue getQueueFromRequest(HttpServletRequest request) {
        ArrayList<String> names = new ArrayList<String>();
        if (request.getPathInfo() != null && request.getPathInfo().length() > 0) {
            String path = request.getPathInfo().substring(1);
            names.addAll(Arrays.asList(path.split("/")));
        }
        String vhostName = (String)names.get(0);
        String queueName = (String)names.get(1);
        VirtualHost vhost = null;
        for (VirtualHost vh : this.getBroker().getVirtualHosts()) {
            if (!vh.getName().equals(vhostName)) continue;
            vhost = vh;
            break;
        }
        return this.getQueueFromVirtualHost(queueName, vhost);
    }

    private Queue getQueueFromVirtualHost(String queueName, VirtualHost vhost) {
        Queue queue = null;
        for (Queue q : vhost.getQueues()) {
            if (!q.getName().equals(queueName)) continue;
            queue = q;
            break;
        }
        return queue;
    }

    private Map<String, Object> convertToObject(QueueEntry entry, boolean includeContent) {
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        object.put("size", entry.getSize());
        object.put("deliveryCount", entry.getDeliveryCount());
        object.put("state", entry.isAvailable() ? "Available" : (entry.isAcquired() ? "Acquired" : ""));
        Subscription deliveredSubscription = entry.getDeliveredSubscription();
        object.put("deliveredTo", deliveredSubscription == null ? null : Long.valueOf(deliveredSubscription.getSubscriptionID()));
        ServerMessage message = entry.getMessage();
        if (message != null) {
            this.convertMessageProperties(object, message);
            if (includeContent) {
                this.convertMessageHeaders(object, message);
            }
        }
        return object;
    }

    private void convertMessageProperties(Map<String, Object> object, ServerMessage message) {
        object.put("id", message.getMessageNumber());
        object.put("arrivalTime", message.getArrivalTime());
        object.put("persistent", message.isPersistent());
        AMQMessageHeader messageHeader = message.getMessageHeader();
        if (messageHeader != null) {
            this.addIfPresent(object, "messageId", messageHeader.getMessageId());
            this.addIfPresentAndNotZero(object, "expirationTime", messageHeader.getExpiration());
            this.addIfPresent(object, "applicationId", messageHeader.getAppId());
            this.addIfPresent(object, "correlationId", messageHeader.getCorrelationId());
            this.addIfPresent(object, "encoding", messageHeader.getEncoding());
            this.addIfPresent(object, "mimeType", messageHeader.getMimeType());
            this.addIfPresent(object, "priority", messageHeader.getPriority());
            this.addIfPresent(object, "replyTo", messageHeader.getReplyTo());
            this.addIfPresentAndNotZero(object, "timestamp", messageHeader.getTimestamp());
            this.addIfPresent(object, "type", messageHeader.getType());
            this.addIfPresent(object, "userId", messageHeader.getUserId());
        }
    }

    private void addIfPresentAndNotZero(Map<String, Object> object, String name, Object property) {
        Number value;
        if (property instanceof Number && (value = (Number)property).longValue() != 0L) {
            object.put(name, property);
        }
    }

    private void addIfPresent(Map<String, Object> object, String name, Object property) {
        if (property != null) {
            object.put(name, property);
        }
    }

    private void convertMessageHeaders(Map<String, Object> object, ServerMessage message) {
        AMQMessageHeader messageHeader = message.getMessageHeader();
        if (messageHeader != null) {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            for (String headerName : messageHeader.getHeaderNames()) {
                headers.put(headerName, messageHeader.getHeader(headerName));
            }
            object.put("headers", headers);
        }
    }

    @Override
    protected void doPostWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String methodName;
            Queue sourceQueue = this.getQueueFromRequest(request);
            ObjectMapper mapper = new ObjectMapper();
            Map providedObject = (Map)mapper.readValue((InputStream)request.getInputStream(), LinkedHashMap.class);
            String destQueueName = (String)providedObject.get("destinationQueue");
            Boolean move = (Boolean)providedObject.get("move");
            VirtualHost vhost = (VirtualHost)sourceQueue.getParent(VirtualHost.class);
            boolean isMoveTransaction = move != null && Boolean.valueOf(move) != false;
            String string = methodName = isMoveTransaction ? "moveMessages" : "copyMessages";
            if (this.isQueueUpdateMethodAuthorized(methodName, vhost)) {
                Queue destinationQueue = this.getQueueFromVirtualHost(destQueueName, vhost);
                ArrayList<Long> messageIds = new ArrayList<Long>((List)providedObject.get("messages"));
                QueueEntryTransaction txn = isMoveTransaction ? new MoveTransaction(sourceQueue, messageIds, destinationQueue) : new CopyTransaction(sourceQueue, messageIds, destinationQueue);
                vhost.executeTransaction((VirtualHost.TransactionalOperation)txn);
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"Failure to perform message opertion", (Throwable)e);
            response.setStatus(500);
        }
    }

    @Override
    protected void doDeleteWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) {
        Queue sourceQueue = this.getQueueFromRequest(request);
        VirtualHost vhost = (VirtualHost)sourceQueue.getParent(VirtualHost.class);
        ArrayList<Long> messageIds = new ArrayList<Long>();
        for (String idStr : request.getParameterValues("id")) {
            messageIds.add(Long.valueOf(idStr));
        }
        if (this.isQueueUpdateMethodAuthorized("deleteMessages", vhost)) {
            vhost.executeTransaction((VirtualHost.TransactionalOperation)new DeleteTransaction(sourceQueue, messageIds));
            response.setStatus(200);
        } else {
            response.setStatus(403);
        }
    }

    private boolean isQueueUpdateMethodAuthorized(String methodName, VirtualHost host) {
        SecurityManager securityManager = host.getSecurityManager();
        return securityManager.authoriseMethod(Operation.UPDATE, "VirtualHost.Queue", methodName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageFinder
    implements QueueEntryVisitor {
        private final long _messageNumber;
        private Map<String, Object> _messageObject;

        private MessageFinder(long messageNumber) {
            this._messageNumber = messageNumber;
        }

        public boolean visit(QueueEntry entry) {
            ServerMessage message = entry.getMessage();
            if (message != null && this._messageNumber == message.getMessageNumber()) {
                MessageReference reference = message.newReference();
                this._messageObject = MessageServlet.this.convertToObject(entry, true);
                reference.release();
                return true;
            }
            return false;
        }

        public Map<String, Object> getMessageObject() {
            return this._messageObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageCollector
    implements QueueEntryVisitor {
        private final int _first;
        private final int _last;
        private int _position = -1;
        private final List<Map<String, Object>> _messages = new ArrayList<Map<String, Object>>();

        private MessageCollector(int first, int last) {
            this._first = first;
            this._last = last;
        }

        public boolean visit(QueueEntry entry) {
            ++this._position;
            if (!(this._first != -1 && this._position < this._first || this._last != -1 && this._position > this._last)) {
                Map messageObject = MessageServlet.this.convertToObject(entry, false);
                messageObject.put("position", this._position);
                this._messages.add(messageObject);
            }
            return this._last != -1 && this._position > this._last;
        }

        public List<Map<String, Object>> getMessages() {
            return this._messages;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeleteTransaction
    extends QueueEntryTransaction {
        public DeleteTransaction(Queue sourceQueue, List<Long> messageIds) {
            super(sourceQueue, messageIds);
        }

        @Override
        protected void updateEntry(QueueEntry entry, VirtualHost.Transaction txn) {
            txn.dequeue(entry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopyTransaction
    extends QueueEntryTransaction {
        private final Queue _destinationQueue;

        public CopyTransaction(Queue sourceQueue, List<Long> messageIds, Queue destinationQueue) {
            super(sourceQueue, messageIds);
            this._destinationQueue = destinationQueue;
        }

        @Override
        protected void updateEntry(QueueEntry entry, VirtualHost.Transaction txn) {
            txn.copy(entry, this._destinationQueue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoveTransaction
    extends QueueEntryTransaction {
        private final Queue _destinationQueue;

        public MoveTransaction(Queue sourceQueue, List<Long> messageIds, Queue destinationQueue) {
            super(sourceQueue, messageIds);
            this._destinationQueue = destinationQueue;
        }

        @Override
        protected void updateEntry(QueueEntry entry, VirtualHost.Transaction txn) {
            txn.move(entry, this._destinationQueue);
        }
    }

    private static abstract class QueueEntryTransaction
    implements VirtualHost.TransactionalOperation {
        private final Queue _sourceQueue;
        private final List _messageIds;

        protected QueueEntryTransaction(Queue sourceQueue, List messageIds) {
            this._sourceQueue = sourceQueue;
            this._messageIds = messageIds;
        }

        public void withinTransaction(final VirtualHost.Transaction txn) {
            this._sourceQueue.visit(new QueueEntryVisitor(){

                public boolean visit(QueueEntry entry) {
                    ServerMessage message = entry.getMessage();
                    if (message != null) {
                        long messageId = message.getMessageNumber();
                        if (QueueEntryTransaction.this._messageIds.remove(messageId) || messageId <= Integer.MAX_VALUE && QueueEntryTransaction.this._messageIds.remove((Object)((int)messageId))) {
                            QueueEntryTransaction.this.updateEntry(entry, txn);
                        }
                    }
                    return QueueEntryTransaction.this._messageIds.isEmpty();
                }
            });
        }

        protected abstract void updateEntry(QueueEntry var1, VirtualHost.Transaction var2);
    }
}

