/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.ConfiguredObjectToMapConverter;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.State;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestServlet
extends AbstractServlet {
    private static final Logger LOGGER = Logger.getLogger(RestServlet.class);
    private static final String HIERARCHY_INIT_PARAMETER = "hierarchy";
    public static final String DEPTH_PARAM = "depth";
    public static final String SORT_PARAM = "sort";
    public static final Set<String> RESERVED_PARAMS = new HashSet<String>(Arrays.asList("depth", "sort"));
    private Class<? extends ConfiguredObject>[] _hierarchy;
    private final ConfiguredObjectToMapConverter _objectConverter = new ConfiguredObjectToMapConverter();
    private final boolean _hierarchyInitializationRequired;

    public RestServlet() {
        this._hierarchyInitializationRequired = true;
    }

    public RestServlet(Class<? extends ConfiguredObject> ... hierarchy) {
        this._hierarchy = hierarchy;
        this._hierarchyInitializationRequired = false;
    }

    @Override
    public void init() throws ServletException {
        super.init();
        if (this._hierarchyInitializationRequired) {
            this.doInitialization();
        }
    }

    private void doInitialization() throws ServletException {
        ServletConfig config = this.getServletConfig();
        String hierarchy = config.getInitParameter(HIERARCHY_INIT_PARAMETER);
        if (hierarchy != null && !"".equals(hierarchy)) {
            String[] hierarchyItems;
            ArrayList classes = new ArrayList();
            for (String item : hierarchyItems = hierarchy.split(",")) {
                Class<?> itemClass = null;
                try {
                    itemClass = Class.forName(item);
                }
                catch (ClassNotFoundException e) {
                    try {
                        itemClass = Class.forName("org.apache.qpid.server.model." + item);
                    }
                    catch (ClassNotFoundException e1) {
                        throw new ServletException("Unknown configured object class '" + item + "' is specified in hierarchy for " + config.getServletName());
                    }
                }
                Class<?> clazz = itemClass;
                classes.add(clazz);
            }
            Class[] hierachyClasses = new Class[classes.size()];
            this._hierarchy = classes.toArray(hierachyClasses);
        } else {
            this._hierarchy = new Class[0];
        }
    }

    protected Collection<ConfiguredObject> getObjects(HttpServletRequest request) {
        ArrayList<String> names = new ArrayList<String>();
        if (request.getPathInfo() != null && request.getPathInfo().length() > 0) {
            String path = request.getPathInfo().substring(1);
            names.addAll(Arrays.asList(path.split("/")));
            if (names.size() > this._hierarchy.length) {
                throw new IllegalArgumentException("Too many entries in path");
            }
        }
        Collection<Object> parents = Collections.singleton(this.getBroker());
        Collection<Object> children = new ArrayList();
        HashMap filters = new HashMap();
        for (int i = 0; i < this._hierarchy.length; ++i) {
            if (i == 0 || Model.getInstance().getChildTypes(this._hierarchy[i - 1]).contains(this._hierarchy[i])) {
                for (ConfiguredObject configuredObject : parents) {
                    if (names.size() > i && names.get(i) != null && !((String)names.get(i)).equals("*") && ((String)names.get(i)).trim().length() != 0) {
                        for (ConfiguredObject child : configuredObject.getChildren(this._hierarchy[i])) {
                            if (!child.getName().equals(names.get(i))) continue;
                            children.add(child);
                        }
                        continue;
                    }
                    children.addAll(configuredObject.getChildren(this._hierarchy[i]));
                }
            } else {
                children = parents;
                if (names.size() > i && names.get(i) != null && !((String)names.get(i)).equals("*") && ((String)names.get(i)).trim().length() != 0) {
                    filters.put(this._hierarchy[i], names.get(i));
                }
            }
            parents = children;
            children = new ArrayList();
        }
        if (!filters.isEmpty()) {
            Set<Broker> potentials = parents;
            parents = new ArrayList();
            for (ConfiguredObject configuredObject : potentials) {
                boolean match = true;
                for (Map.Entry entry : filters.entrySet()) {
                    Collection<? extends ConfiguredObject> ancestors = this.getAncestors(this.getConfiguredClass(), (Class)entry.getKey(), configuredObject);
                    match = false;
                    for (ConfiguredObject configuredObject2 : ancestors) {
                        if (!configuredObject2.getName().equals(entry.getValue())) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    break;
                }
                if (!match) continue;
                parents.add((Broker)configuredObject);
            }
        }
        return this.filter(parents, request);
    }

    private Collection<ConfiguredObject> filter(Collection<ConfiguredObject> objects, HttpServletRequest request) {
        HashMap<String, List<String>> filters = new HashMap<String, List<String>>();
        for (String param : Collections.list(request.getParameterNames())) {
            if (RESERVED_PARAMS.contains(param)) continue;
            filters.put(param, Arrays.asList(request.getParameterValues(param)));
        }
        if (filters.isEmpty()) {
            return objects;
        }
        ArrayList<ConfiguredObject> filteredObj = new ArrayList<ConfiguredObject>(objects);
        Iterator iter = filteredObj.iterator();
        while (iter.hasNext()) {
            ConfiguredObject obj = (ConfiguredObject)iter.next();
            for (Map.Entry entry : filters.entrySet()) {
                Object value = obj.getAttribute((String)entry.getKey());
                if (((Collection)entry.getValue()).contains(String.valueOf(value))) continue;
                iter.remove();
            }
        }
        return filteredObj;
    }

    private Collection<? extends ConfiguredObject> getAncestors(Class<? extends ConfiguredObject> childType, Class<? extends ConfiguredObject> ancestorType, ConfiguredObject child) {
        HashSet<Object> ancestors = new HashSet<Object>();
        Collection parentTypes = Model.getInstance().getParentTypes(childType);
        for (Class parentClazz : parentTypes) {
            ConfiguredObject parent;
            if (parentClazz == ancestorType) {
                parent = child.getParent(parentClazz);
                if (parent == null) continue;
                ancestors.add(parent);
                continue;
            }
            parent = child.getParent(parentClazz);
            if (parent == null) continue;
            ancestors.addAll(this.getAncestors(parentClazz, ancestorType, parent));
        }
        return ancestors;
    }

    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setStatus(200);
        this.setCachingHeadersOnResponse(response);
        Collection<ConfiguredObject> allObjects = this.getObjects(request);
        int depth = this.getDepthParameterFromRequest(request);
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>();
        for (ConfiguredObject configuredObject : allObjects) {
            output.add(this._objectConverter.convertObjectToMap(configuredObject, this.getConfiguredClass(), depth));
        }
        BufferedWriter writer = new BufferedWriter(response.getWriter());
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        mapper.writeValue((Writer)writer, output);
        response.setContentType("application/json");
        response.setStatus(200);
    }

    private Class<? extends ConfiguredObject> getConfiguredClass() {
        return this._hierarchy.length == 0 ? Broker.class : this._hierarchy[this._hierarchy.length - 1];
    }

    @Override
    protected void doPutWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        ObjectMapper mapper = new ObjectMapper();
        Map providedObject = (Map)mapper.readValue((InputStream)request.getInputStream(), LinkedHashMap.class);
        ArrayList<String> names = new ArrayList<String>();
        if (request.getPathInfo() != null && request.getPathInfo().length() > 0) {
            String path = request.getPathInfo().substring(1);
            names.addAll(Arrays.asList(path.split("/")));
            if (names.size() != this._hierarchy.length) {
                throw new IllegalArgumentException("Path to object to create must be fully specified. Found " + names.size() + " expecting " + this._hierarchy.length);
            }
        }
        if (names.isEmpty()) {
            if (this._hierarchy.length == 0) {
                try {
                    this.doUpdate((ConfiguredObject)this.getBroker(), providedObject);
                    response.setStatus(200);
                }
                catch (RuntimeException e) {
                    this.setResponseStatus(response, e);
                }
                return;
            }
            throw new ServletException("Cannot identify request target object");
        }
        providedObject.put("name", names.get(names.size() - 1));
        Collection[] objects = new Collection[this._hierarchy.length];
        if (this._hierarchy.length == 1) {
            this.createOrUpdate(providedObject, this._hierarchy[0], (ConfiguredObject)this.getBroker(), null, response);
        } else {
            block2: for (int i = 0; i < this._hierarchy.length - 1; ++i) {
                objects[i] = new HashSet();
                if (i == 0) {
                    for (ConfiguredObject object : this.getBroker().getChildren(this._hierarchy[0])) {
                        if (!object.getName().equals(names.get(0))) continue;
                        objects[0].add(object);
                        continue block2;
                    }
                    continue;
                }
                for (int j = i - 1; j >= 0; --j) {
                    if (!Model.getInstance().getChildTypes(this._hierarchy[j]).contains(this._hierarchy[i])) continue;
                    for (ConfiguredObject parent : objects[j]) {
                        for (ConfiguredObject object : parent.getChildren(this._hierarchy[i])) {
                            if (!object.getName().equals(names.get(i))) continue;
                            objects[i].add(object);
                        }
                    }
                    continue block2;
                }
            }
            ArrayList parents = new ArrayList();
            Class<? extends ConfiguredObject> objClass = this.getConfiguredClass();
            Collection parentClasses = Model.getInstance().getParentTypes(objClass);
            for (int i = this._hierarchy.length - 2; i >= 0; --i) {
                if (!parentClasses.contains(this._hierarchy[i])) continue;
                if (objects[i].size() == 1) {
                    parents.add(objects[i].iterator().next());
                    continue;
                }
                throw new IllegalArgumentException("Cannot deduce parent of class " + this._hierarchy[i].getSimpleName());
            }
            ConfiguredObject theParent = (ConfiguredObject)parents.remove(0);
            ConfiguredObject[] otherParents = parents.toArray(new ConfiguredObject[parents.size()]);
            this.createOrUpdate(providedObject, objClass, theParent, otherParents, response);
        }
    }

    private void createOrUpdate(Map<String, Object> providedObject, Class<? extends ConfiguredObject> objClass, ConfiguredObject theParent, ConfiguredObject[] otherParents, HttpServletResponse response) throws IOException {
        try {
            Collection existingChildren = theParent.getChildren(objClass);
            for (ConfiguredObject obj : existingChildren) {
                if ((!providedObject.containsKey("id") || !String.valueOf(providedObject.get("id")).equals(obj.getId().toString())) && (!obj.getName().equals(providedObject.get("name")) || !this.equalParents(obj, otherParents, objClass))) continue;
                this.doUpdate(obj, providedObject);
                response.setStatus(200);
                return;
            }
            theParent.createChild(objClass, providedObject, otherParents);
            response.setStatus(201);
        }
        catch (RuntimeException e) {
            this.setResponseStatus(response, e);
        }
    }

    private void doUpdate(ConfiguredObject obj, Map<String, Object> providedObject) {
        obj.setAttributes(providedObject);
    }

    private boolean equalParents(ConfiguredObject obj, ConfiguredObject[] otherParents, Class<? extends ConfiguredObject> objClass) {
        if (otherParents == null || otherParents.length == 0) {
            return true;
        }
        Collection parentClasses = Model.getInstance().getParentTypes(objClass);
        for (ConfiguredObject parent : otherParents) {
            boolean found = false;
            for (Class parentClass : parentClasses) {
                if (parent != obj.getParent(parentClass)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void setResponseStatus(HttpServletResponse response, RuntimeException e) throws IOException {
        if (e instanceof AccessControlException || e.getCause() instanceof AMQSecurityException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Caught security exception, sending 403", (Throwable)e);
            }
            response.setStatus(403);
        } else {
            LOGGER.warn((Object)"Caught exception", (Throwable)e);
            response.setStatus(409);
        }
    }

    @Override
    protected void doDeleteWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setStatus(200);
        this.setCachingHeadersOnResponse(response);
        try {
            Collection<ConfiguredObject> allObjects = this.getObjects(request);
            for (ConfiguredObject o : allObjects) {
                o.setDesiredState(o.getActualState(), State.DELETED);
            }
            response.setStatus(200);
        }
        catch (RuntimeException e) {
            this.setResponseStatus(response, e);
        }
    }

    private void setCachingHeadersOnResponse(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    private int getDepthParameterFromRequest(HttpServletRequest request) {
        int depth = 1;
        String depthString = request.getParameter(DEPTH_PARAM);
        if (depthString != null) {
            try {
                depth = Integer.parseInt(depthString);
            }
            catch (NumberFormatException e) {
                LOGGER.warn((Object)("Could not parse " + depthString + " as integer"));
            }
        }
        return depth;
    }
}

