/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.SocketAddress;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.Random;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.actors.HttpManagementActor;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class SaslServlet
extends AbstractServlet {
    private static final Logger LOGGER = Logger.getLogger(SaslServlet.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final String ATTR_RANDOM = "SaslServlet.Random";
    private static final String ATTR_ID = "SaslServlet.ID";
    private static final String ATTR_SASL_SERVER = "SaslServlet.SaslServer";
    private static final String ATTR_EXPIRY = "SaslServlet.Expiry";
    private static final long SASL_EXCHANGE_EXPIRY = 1000L;

    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setStatus(200);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        HttpSession session = request.getSession();
        this.getRandom(session);
        SubjectCreator subjectCreator = this.getSubjectCreator(request);
        String[] mechanisms = subjectCreator.getMechanisms().split(" ");
        LinkedHashMap<String, Object> outputObject = new LinkedHashMap<String, Object>();
        Subject subject = this.getAuthorisedSubject(request);
        if (subject != null) {
            AuthenticatedPrincipal principal = AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject((Subject)subject);
            outputObject.put("user", principal.getName());
        } else if (request.getRemoteUser() != null) {
            outputObject.put("user", request.getRemoteUser());
        }
        outputObject.put("mechanisms", mechanisms);
        PrintWriter writer = response.getWriter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        mapper.writeValue((Writer)writer, outputObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Random getRandom(HttpSession session) {
        Random rand = (Random)session.getAttribute(ATTR_RANDOM);
        if (rand == null) {
            SecureRandom secureRandom = SECURE_RANDOM;
            synchronized (secureRandom) {
                rand = new Random(SECURE_RANDOM.nextLong());
            }
            session.setAttribute(ATTR_RANDOM, (Object)rand);
        }
        return rand;
    }

    protected void doPostWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.checkSaslAuthEnabled(request);
        try {
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            HttpSession session = request.getSession();
            String mechanism = request.getParameter("mechanism");
            String id = request.getParameter("id");
            String saslResponse = request.getParameter("response");
            SubjectCreator subjectCreator = this.getSubjectCreator(request);
            if (mechanism != null) {
                if (id == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Creating SaslServer for mechanism: " + mechanism));
                    }
                    SaslServer saslServer = subjectCreator.createSaslServer(mechanism, request.getServerName(), null);
                    this.evaluateSaslResponse(request, response, session, saslResponse, saslServer, subjectCreator);
                } else {
                    response.setStatus(417);
                    session.removeAttribute(ATTR_ID);
                    session.removeAttribute(ATTR_SASL_SERVER);
                    session.removeAttribute(ATTR_EXPIRY);
                }
            } else if (id != null) {
                if (id.equals(session.getAttribute(ATTR_ID)) && System.currentTimeMillis() < (Long)session.getAttribute(ATTR_EXPIRY)) {
                    SaslServer saslServer = (SaslServer)session.getAttribute(ATTR_SASL_SERVER);
                    this.evaluateSaslResponse(request, response, session, saslResponse, saslServer, subjectCreator);
                } else {
                    response.setStatus(417);
                    session.removeAttribute(ATTR_ID);
                    session.removeAttribute(ATTR_SASL_SERVER);
                    session.removeAttribute(ATTR_EXPIRY);
                }
            } else {
                response.setStatus(417);
                session.removeAttribute(ATTR_ID);
                session.removeAttribute(ATTR_SASL_SERVER);
                session.removeAttribute(ATTR_EXPIRY);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error processing SASL request", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"Error processing SASL request", (Throwable)e);
            throw e;
        }
    }

    private void checkSaslAuthEnabled(HttpServletRequest request) {
        boolean saslAuthEnabled = false;
        HttpManagementConfiguration management = this.getManagementConfiguration();
        saslAuthEnabled = request.isSecure() ? management.isHttpsSaslAuthenticationEnabled() : management.isHttpSaslAuthenticationEnabled();
        if (!saslAuthEnabled) {
            throw new RuntimeException("Sasl authentication disabled.");
        }
    }

    private void evaluateSaslResponse(HttpServletRequest request, HttpServletResponse response, HttpSession session, String saslResponse, SaslServer saslServer, SubjectCreator subjectCreator) throws IOException {
        byte[] challenge;
        try {
            challenge = saslServer.evaluateResponse(saslResponse == null ? new byte[]{} : Base64.decodeBase64((byte[])saslResponse.getBytes()));
        }
        catch (SaslException e) {
            session.removeAttribute(ATTR_ID);
            session.removeAttribute(ATTR_SASL_SERVER);
            session.removeAttribute(ATTR_EXPIRY);
            response.setStatus(401);
            return;
        }
        if (saslServer.isComplete()) {
            Subject subject = subjectCreator.createSubjectWithGroups(saslServer.getAuthorizationID());
            Broker broker = this.getBroker();
            HttpManagementActor actor = HttpManagementUtil.getOrCreateAndCacheLogActor(request, broker);
            if (!HttpManagementUtil.hasAccessToManagement(broker.getSecurityManager(), subject, (LogActor)actor)) {
                this.sendError(response, 403);
                return;
            }
            HttpManagementUtil.saveAuthorisedSubject(request.getSession(), subject, (LogActor)actor);
            session.removeAttribute(ATTR_ID);
            session.removeAttribute(ATTR_SASL_SERVER);
            session.removeAttribute(ATTR_EXPIRY);
            response.setStatus(200);
        } else {
            Random rand = this.getRandom(session);
            String id = String.valueOf(rand.nextLong());
            session.setAttribute(ATTR_ID, (Object)id);
            session.setAttribute(ATTR_SASL_SERVER, (Object)saslServer);
            session.setAttribute(ATTR_EXPIRY, (Object)(System.currentTimeMillis() + 1000L));
            response.setStatus(200);
            LinkedHashMap<String, String> outputObject = new LinkedHashMap<String, String>();
            outputObject.put("id", id);
            outputObject.put("challenge", new String(Base64.encodeBase64((byte[])challenge)));
            PrintWriter writer = response.getWriter();
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
            mapper.writeValue((Writer)writer, outputObject);
        }
    }

    private SubjectCreator getSubjectCreator(HttpServletRequest request) {
        SocketAddress localAddress = HttpManagementUtil.getSocketAddress(request);
        return HttpManagementUtil.getManagementConfiguration(this.getServletContext()).getSubjectCreator(localAddress);
    }

    protected Subject getAuthorisedSubject(HttpServletRequest request) {
        return HttpManagementUtil.getAuthorisedSubject(request.getSession());
    }
}

