/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Model;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureServlet
extends AbstractServlet {
    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json");
        response.setStatus(200);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        Map<String, Object> structure = this.generateStructure((ConfiguredObject)this.getBroker(), Broker.class);
        PrintWriter writer = response.getWriter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        mapper.writeValue((Writer)writer, structure);
        response.setStatus(200);
    }

    private Map<String, Object> generateStructure(ConfiguredObject object, Class<? extends ConfiguredObject> clazz) {
        LinkedHashMap<String, Object> structure = new LinkedHashMap<String, Object>();
        structure.put("id", object.getId());
        structure.put("name", object.getName());
        for (Class childClass : Model.getInstance().getChildTypes(clazz)) {
            Collection children = object.getChildren(childClass);
            if (children == null) continue;
            ArrayList<Map<String, Object>> childObjects = new ArrayList<Map<String, Object>>();
            for (ConfiguredObject child : children) {
                childObjects.add(this.generateStructure(child, childClass));
            }
            if (childObjects.isEmpty()) continue;
            structure.put(this.pluralize(childClass), childObjects);
        }
        return structure;
    }

    private String pluralize(Class<? extends ConfiguredObject> childClass) {
        String name = childClass.getSimpleName().toLowerCase();
        return name + (name.endsWith("s") ? "es" : "s");
    }
}

