/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest.action;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.qpid.server.management.plugin.servlet.rest.Action;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.plugin.AuthenticationManagerFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAuthenticationProviderAttributes
implements Action {
    private static final String ATTRIBUTES = "attributes";
    private static final String DESCRIPTIONS = "descriptions";
    private Map<String, AuthenticationManagerFactory> _factories = new TreeMap<String, AuthenticationManagerFactory>();

    public ListAuthenticationProviderAttributes() {
        Iterable factories = new QpidServiceLoader().instancesOf(AuthenticationManagerFactory.class);
        for (AuthenticationManagerFactory factory : factories) {
            this._factories.put(factory.getType(), factory);
        }
    }

    @Override
    public String getName() {
        return ListAuthenticationProviderAttributes.class.getSimpleName();
    }

    @Override
    public Object perform(Map<String, Object> request, Broker broker) {
        TreeMap attributes = new TreeMap();
        for (String providerType : this._factories.keySet()) {
            AuthenticationManagerFactory factory = this._factories.get(providerType);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(ATTRIBUTES, factory.getAttributeNames());
            Map resources = factory.getAttributeDescriptions();
            if (resources != null) {
                data.put(DESCRIPTIONS, resources);
            }
            attributes.put(factory.getType(), data);
        }
        return attributes;
    }
}

