/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.session;

import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.log4j.Logger;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.messages.ManagementConsoleMessages;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;

public class LoginLogoutReporter
implements HttpSessionBindingListener {
    private static final Logger LOGGER = Logger.getLogger(LoginLogoutReporter.class);
    private final LogActor _logActor;
    private final Subject _subject;
    private final Principal _principal;

    public LoginLogoutReporter(LogActor logActor, Subject subject) {
        this._logActor = logActor;
        this._subject = subject;
        this._principal = AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject((Subject)this._subject);
    }

    public void valueBound(HttpSessionBindingEvent arg0) {
        this.reportLogin();
    }

    public void valueUnbound(HttpSessionBindingEvent arg0) {
        this.reportLogout();
    }

    private void reportLogin() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("User logging in : " + this._principal));
        }
        Subject.doAs(this._subject, new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                LoginLogoutReporter.this._logActor.message(ManagementConsoleMessages.OPEN((String)LoginLogoutReporter.this._principal.getName()));
                return null;
            }
        });
    }

    private void reportLogout() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("User logging out : " + this._principal));
        }
        Subject.doAs(this._subject, new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                LoginLogoutReporter.this._logActor.message(ManagementConsoleMessages.CLOSE((String)LoginLogoutReporter.this._principal.getName()));
                return null;
            }
        });
    }
}

