/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpRequestPreemptiveAuthenticator;
import org.apache.qpid.server.management.plugin.servlet.ServletConnectionPrincipal;
import org.apache.qpid.server.management.plugin.session.LoginLogoutReporter;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.SecurityManager;

public class HttpManagementUtil {
    public static final String ATTR_BROKER = "Qpid.broker";
    public static final String ATTR_MANAGEMENT_CONFIGURATION = "Qpid.managementConfiguration";
    private static final String ATTR_LOGIN_LOGOUT_REPORTER = "Qpid.loginLogoutReporter";
    private static final String ATTR_SUBJECT = "Qpid.subject";
    public static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    public static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    public static final String GZIP_CONTENT_ENCODING = "gzip";
    private static final Collection<HttpRequestPreemptiveAuthenticator> AUTHENTICATORS;

    public static Broker<?> getBroker(ServletContext servletContext) {
        return (Broker)servletContext.getAttribute(ATTR_BROKER);
    }

    public static HttpManagementConfiguration getManagementConfiguration(ServletContext servletContext) {
        return (HttpManagementConfiguration)servletContext.getAttribute(ATTR_MANAGEMENT_CONFIGURATION);
    }

    public static Subject getAuthorisedSubject(HttpSession session) {
        return (Subject)session.getAttribute(ATTR_SUBJECT);
    }

    public static void checkRequestAuthenticatedAndAccessAuthorized(HttpServletRequest request, Broker broker, HttpManagementConfiguration managementConfig) {
        HttpSession session = request.getSession();
        Subject subject = HttpManagementUtil.getAuthorisedSubject(session);
        if (subject == null) {
            subject = HttpManagementUtil.tryToAuthenticate(request, managementConfig);
            if (subject == null) {
                throw new SecurityException("Only authenticated users can access the management interface");
            }
            Subject original = subject;
            subject = new Subject(false, original.getPrincipals(), original.getPublicCredentials(), original.getPrivateCredentials());
            subject.getPrincipals().add((Principal)((Object)new ServletConnectionPrincipal((ServletRequest)request)));
            subject.setReadOnly();
            HttpManagementUtil.assertManagementAccess(broker.getSecurityManager(), subject);
            HttpManagementUtil.saveAuthorisedSubject(session, subject);
        }
    }

    public static void assertManagementAccess(final SecurityManager securityManager, Subject subject) {
        Subject.doAs(subject, new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                securityManager.accessManagement();
                return null;
            }
        });
    }

    public static void saveAuthorisedSubject(HttpSession session, Subject subject) {
        session.setAttribute(ATTR_SUBJECT, (Object)subject);
        session.setAttribute(ATTR_LOGIN_LOGOUT_REPORTER, (Object)new LoginLogoutReporter(subject, (EventLoggerProvider)HttpManagementUtil.getBroker(session.getServletContext())));
    }

    public static Subject tryToAuthenticate(HttpServletRequest request, HttpManagementConfiguration managementConfig) {
        HttpRequestPreemptiveAuthenticator authenticator;
        Subject subject = null;
        Iterator<HttpRequestPreemptiveAuthenticator> i$ = AUTHENTICATORS.iterator();
        while (i$.hasNext() && (subject = (authenticator = i$.next()).attemptAuthentication(request, managementConfig)) == null) {
        }
        return subject;
    }

    public static OutputStream getOutputStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return HttpManagementUtil.getOutputStream(request, response, HttpManagementUtil.getManagementConfiguration(request.getServletContext()));
    }

    public static OutputStream getOutputStream(HttpServletRequest request, HttpServletResponse response, HttpManagementConfiguration managementConfiguration) throws IOException {
        Object outputStream;
        if (HttpManagementUtil.isCompressingAccepted(request, managementConfiguration)) {
            outputStream = new GZIPOutputStream((OutputStream)response.getOutputStream());
            response.setHeader(CONTENT_ENCODING_HEADER, GZIP_CONTENT_ENCODING);
        } else {
            outputStream = response.getOutputStream();
        }
        return outputStream;
    }

    public static boolean isCompressingAccepted(HttpServletRequest request, HttpManagementConfiguration managementConfiguration) {
        return managementConfiguration.isCompressResponses() && Collections.list(request.getHeaderNames()).contains(ACCEPT_ENCODING_HEADER) && request.getHeader(ACCEPT_ENCODING_HEADER).contains(GZIP_CONTENT_ENCODING);
    }

    public static String ensureFilenameIsRfc2183(String requestedFilename) {
        return requestedFilename.replaceAll("[\\P{InBasic_Latin}\\\\:/\\p{Cntrl}]", "");
    }

    static {
        ArrayList<HttpRequestPreemptiveAuthenticator> authenticators = new ArrayList<HttpRequestPreemptiveAuthenticator>();
        for (HttpRequestPreemptiveAuthenticator authenticator : new QpidServiceLoader().instancesOf(HttpRequestPreemptiveAuthenticator.class)) {
            authenticators.add(authenticator);
        }
        AUTHENTICATORS = Collections.unmodifiableList(authenticators);
    }
}

